/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sparkproject.org.apache.arrow.memory.ArrowBuf;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.memory.util.CommonUtil;
import org.sparkproject.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.sparkproject.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.sparkproject.org.apache.arrow.util.Preconditions;
import org.sparkproject.org.apache.arrow.vector.BaseValueVector;
import org.sparkproject.org.apache.arrow.vector.BitVectorHelper;
import org.sparkproject.org.apache.arrow.vector.BufferBacked;
import org.sparkproject.org.apache.arrow.vector.FieldVector;
import org.sparkproject.org.apache.arrow.vector.ValueIterableVector;
import org.sparkproject.org.apache.arrow.vector.ValueVector;
import org.sparkproject.org.apache.arrow.vector.complex.AbstractStructVector;
import org.sparkproject.org.apache.arrow.vector.complex.NonNullableStructVector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.NullableStructReaderImpl;
import org.sparkproject.org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.sparkproject.org.apache.arrow.vector.holders.ComplexHolder;
import org.sparkproject.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.sparkproject.org.apache.arrow.vector.types.pojo.ArrowType;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;
import org.sparkproject.org.apache.arrow.vector.types.pojo.FieldType;
import org.sparkproject.org.apache.arrow.vector.util.CallBack;
import org.sparkproject.org.apache.arrow.vector.util.OversizedAllocationException;
import org.sparkproject.org.apache.arrow.vector.util.TransferPair;

public class StructVector
extends NonNullableStructVector
implements FieldVector,
ValueIterableVector<Map<String, ?>> {
    private final NullableStructReaderImpl reader = new NullableStructReaderImpl(this);
    private final NullableStructWriter writer = new NullableStructWriter(this);
    protected ArrowBuf validityBuffer;
    private int validityAllocationSizeInBytes;

    public static StructVector empty(String name, BufferAllocator allocator) {
        FieldType fieldType = FieldType.nullable(ArrowType.Struct.INSTANCE);
        return new StructVector(name, allocator, fieldType, null, AbstractStructVector.ConflictPolicy.CONFLICT_REPLACE, false);
    }

    public static StructVector emptyWithDuplicates(String name, BufferAllocator allocator) {
        FieldType fieldType = new FieldType(false, ArrowType.Struct.INSTANCE, null, null);
        return new StructVector(name, allocator, fieldType, null, AbstractStructVector.ConflictPolicy.CONFLICT_APPEND, true);
    }

    public StructVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        super(name, Preconditions.checkNotNull(allocator), fieldType, callBack);
        this.validityBuffer = allocator.getEmpty();
        this.validityAllocationSizeInBytes = BitVectorHelper.getValidityBufferSize(3970);
    }

    public StructVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack, AbstractStructVector.ConflictPolicy conflictPolicy, boolean allowConflictPolicyChanges) {
        super(name, Preconditions.checkNotNull(allocator), fieldType, callBack, conflictPolicy, allowConflictPolicyChanges);
        this.validityBuffer = allocator.getEmpty();
        this.validityAllocationSizeInBytes = BitVectorHelper.getValidityBufferSize(3970);
    }

    public StructVector(Field field, BufferAllocator allocator, CallBack callBack) {
        super(field, Preconditions.checkNotNull(allocator), callBack);
        this.validityBuffer = allocator.getEmpty();
        this.validityAllocationSizeInBytes = BitVectorHelper.getValidityBufferSize(3970);
    }

    public StructVector(Field field, BufferAllocator allocator, CallBack callBack, AbstractStructVector.ConflictPolicy conflictPolicy, boolean allowConflictPolicyChanges) {
        super(field, Preconditions.checkNotNull(allocator), callBack, conflictPolicy, allowConflictPolicyChanges);
        this.validityBuffer = allocator.getEmpty();
        this.validityAllocationSizeInBytes = BitVectorHelper.getValidityBufferSize(3970);
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 1) {
            throw new IllegalArgumentException("Illegal buffer count, expected 1, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.valueCount = fieldNode.getLength();
        this.validityAllocationSizeInBytes = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(1);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.validityBuffer.writerIndex(BitVectorHelper.getValidityBufferSize(this.valueCount));
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public NullableStructReaderImpl getReader() {
        return this.reader;
    }

    public NullableStructWriter getWriter() {
        return this.writer;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new NullableStructTransferPair(this, new StructVector(this.name, allocator, this.field.getFieldType(), null, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new NullableStructTransferPair(this, (StructVector)to, false);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new NullableStructTransferPair(this, new StructVector(ref, allocator, this.field.getFieldType(), null, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new NullableStructTransferPair(this, new StructVector(ref, allocator, this.field.getFieldType(), callBack, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new NullableStructTransferPair(this, new StructVector(field, allocator, null, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new NullableStructTransferPair(this, new StructVector(field, allocator, callBack, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    private void splitAndTransferValidityBuffer(int startIndex, int length, StructVector target) {
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BitVectorHelper.getValidityBufferSize(length);
        int offset = startIndex % 8;
        if (length > 0) {
            if (offset == 0) {
                if (target.validityBuffer != null) {
                    target.validityBuffer.getReferenceManager().release();
                }
                target.validityBuffer = this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                target.validityBuffer.getReferenceManager().retain(1);
            } else {
                byte b1;
                target.allocateValidityBuffer(byteSizeTarget);
                for (int i = 0; i < byteSizeTarget - 1; ++i) {
                    byte b12 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + i, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + i + 1, offset);
                    target.validityBuffer.setByte((long)i, b12 + b2);
                }
                if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                    target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
                } else {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
                }
            }
        }
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity() * 8L);
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.getValidityBufferValueCapacity(), super.getValueCapacity());
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.validityBuffer);
            list.addAll(Arrays.asList(super.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.clearValidityBuffer();
        super.close();
    }

    @Override
    public void clear() {
        this.clearValidityBuffer();
        super.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    private void clearValidityBuffer() {
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = this.allocator.getEmpty();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return super.getBufferSize() + BitVectorHelper.getValidityBufferSize(this.valueCount);
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return super.getBufferSizeFor(valueCount) + BitVectorHelper.getValidityBufferSize(valueCount);
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.validityAllocationSizeInBytes = BitVectorHelper.getValidityBufferSize(numRecords);
        super.setInitialCapacity(numRecords);
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        this.validityAllocationSizeInBytes = BitVectorHelper.getValidityBufferSize(numRecords);
        super.setInitialCapacity(numRecords, density);
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            this.clear();
            this.allocateValidityBuffer(this.validityAllocationSizeInBytes);
            success = super.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return success;
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0L);
        this.validityAllocationSizeInBytes = curSize;
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocValidityBuffer();
        super.reAlloc();
    }

    private void reallocValidityBuffer() {
        int currentBufferCapacity = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
        long newAllocationSize = this.getNewAllocationSize(currentBufferCapacity);
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.validityBuffer, 0L, (long)currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - (long)currentBufferCapacity);
        this.validityBuffer.getReferenceManager().release(1);
        this.validityBuffer = newBuf;
        this.validityAllocationSizeInBytes = (int)newAllocationSize;
    }

    private long getNewAllocationSize(int currentBufferCapacity) {
        long newAllocationSize = (long)currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.validityAllocationSizeInBytes > 0 ? (long)this.validityAllocationSizeInBytes : (long)BitVectorHelper.getValidityBufferSize(3970) * 2L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > BaseValueVector.MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        return newAllocationSize;
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ?> getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return super.getObject(index);
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isSet(index) == 0) {
            return 0;
        }
        return super.hashCode(index, hasher);
    }

    @Override
    public void get(int index, ComplexHolder holder) {
        holder.isSet = this.isSet(index);
        if (holder.isSet == 0) {
            holder.reader = null;
            return;
        }
        super.get(index, holder);
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    public void setIndexDefined(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
    }

    @Override
    public void setNull(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.unsetBit(this.validityBuffer, index);
    }

    @Override
    public void setValueCount(int valueCount) {
        Preconditions.checkArgument(valueCount >= 0);
        while (valueCount > this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        super.setValueCount(valueCount);
        this.valueCount = valueCount;
    }

    protected class NullableStructTransferPair
    extends NonNullableStructVector.StructTransferPair {
        private StructVector target;

        protected NullableStructTransferPair(StructVector from, StructVector to, boolean allocate) {
            super(from, to, allocate);
            this.target = to;
        }

        @Override
        public void transfer() {
            this.target.clear();
            this.target.validityBuffer = BaseValueVector.transferBuffer(StructVector.this.validityBuffer, this.target.allocator);
            super.transfer();
            StructVector.this.clear();
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            while (toIndex >= this.target.getValidityBufferValueCapacity()) {
                this.target.reallocValidityBuffer();
            }
            BitVectorHelper.setValidityBit(this.target.validityBuffer, toIndex, StructVector.this.isSet(fromIndex));
            super.copyValueSafe(fromIndex, toIndex);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= StructVector.this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)StructVector.this.valueCount);
            this.target.clear();
            StructVector.this.splitAndTransferValidityBuffer(startIndex, length, this.target);
            super.splitAndTransfer(startIndex, length);
        }
    }
}

