/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.TargetEncoder;
import org.apache.spark.ml.feature.TargetEncoderModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaTargetEncoderExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaTargetEncoderExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0.0, 1.0, 0, 10.0}), RowFactory.create((Object[])new Object[]{1.0, 0.0, 1, 20.0}), RowFactory.create((Object[])new Object[]{2.0, 1.0, 0, 30.0}), RowFactory.create((Object[])new Object[]{0.0, 2.0, 1, 40.0}), RowFactory.create((Object[])new Object[]{0.0, 1.0, 0, 50.0}), RowFactory.create((Object[])new Object[]{2.0, 0.0, 1, 60.0}));
        StructType schema = new StructType(new StructField[]{new StructField("categoryIndex1", DataTypes.DoubleType, false, Metadata.empty()), new StructField("categoryIndex2", DataTypes.DoubleType, false, Metadata.empty()), new StructField("binaryLabel", DataTypes.DoubleType, false, Metadata.empty()), new StructField("continuousLabel", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        TargetEncoder bin_encoder = new TargetEncoder().setInputCols(new String[]{"categoryIndex1", "categoryIndex2"}).setOutputCols(new String[]{"categoryIndex1Target", "categoryIndex2Target"}).setLabelCol("binaryLabel").setTargetType("binary");
        TargetEncoderModel bin_model = bin_encoder.fit(df);
        Dataset bin_encoded = bin_model.transform(df);
        bin_encoded.show();
        TargetEncoder cont_encoder = new TargetEncoder().setInputCols(new String[]{"categoryIndex1", "categoryIndex2"}).setOutputCols(new String[]{"categoryIndex1Target", "categoryIndex2Target"}).setLabelCol("continuousLabel").setTargetType("continuous");
        TargetEncoderModel cont_model = cont_encoder.fit(df);
        Dataset cont_encoded = cont_model.transform(df);
        cont_encoded.show();
        spark.stop();
    }
}

