/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.ExternalShuffleService;
import org.apache.spark.deploy.worker.Worker;
import org.apache.spark.deploy.worker.WorkerArguments;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcAddress$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.util.SparkUncaughtExceptionHandler;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class Worker$
implements Logging {
    public static final Worker$ MODULE$ = new Worker$();
    private static final String SYSTEM_NAME;
    private static final String ENDPOINT_NAME;
    private static final Regex org$apache$spark$deploy$worker$Worker$$SSL_NODE_LOCAL_CONFIG_PATTERN;
    private static final DateTimeFormatter org$apache$spark$deploy$worker$Worker$$DATE_TIME_FORMATTER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        SYSTEM_NAME = "sparkWorker";
        ENDPOINT_NAME = "Worker";
        org$apache$spark$deploy$worker$Worker$$SSL_NODE_LOCAL_CONFIG_PATTERN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\-Dspark\\.ssl\\.useNodeLocalConf\\=(.+)"));
        org$apache$spark$deploy$worker$Worker$$DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.US).withZone(ZoneId.systemDefault());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$7() {
        return null;
    }

    public Option<String> $lessinit$greater$default$10() {
        return None$.MODULE$;
    }

    public Supplier<ExternalShuffleService> $lessinit$greater$default$11() {
        return null;
    }

    public String SYSTEM_NAME() {
        return SYSTEM_NAME;
    }

    public String ENDPOINT_NAME() {
        return ENDPOINT_NAME;
    }

    public Regex org$apache$spark$deploy$worker$Worker$$SSL_NODE_LOCAL_CONFIG_PATTERN() {
        return org$apache$spark$deploy$worker$Worker$$SSL_NODE_LOCAL_CONFIG_PATTERN;
    }

    public DateTimeFormatter org$apache$spark$deploy$worker$Worker$$DATE_TIME_FORMATTER() {
        return org$apache$spark$deploy$worker$Worker$$DATE_TIME_FORMATTER;
    }

    public void main(String[] argStrings) {
        Thread.setDefaultUncaughtExceptionHandler(new SparkUncaughtExceptionHandler(false));
        Utils$.MODULE$.resetStructuredLogging();
        Utils$.MODULE$.initDaemon(this.log());
        SparkConf conf = new SparkConf();
        WorkerArguments args = new WorkerArguments(argStrings, conf);
        String x$1 = args.host();
        int x$2 = args.port();
        int x$3 = args.webUiPort();
        int x$4 = args.cores();
        int x$5 = args.memory();
        String[] x$6 = args.masters();
        String x$7 = args.workDir();
        SparkConf x$8 = conf;
        Option x$9 = (Option)conf.get(org.apache.spark.internal.config.Worker$.MODULE$.SPARK_WORKER_RESOURCE_FILE());
        Option<Object> x$10 = this.startRpcEnvAndEndpoint$default$8();
        RpcEnv rpcEnv = this.startRpcEnvAndEndpoint(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$10, x$8, (Option<String>)x$9);
        boolean externalShuffleServiceEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()));
        int sparkWorkerInstances = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARK_WORKER_INSTANCES", (Function0 & Serializable)() -> "1")));
        Predef$.MODULE$.require(!externalShuffleServiceEnabled || sparkWorkerInstances <= 1, (Function0 & Serializable)() -> "Starting multiple workers on one host is failed because we may launch no more than one external shuffle service on each host, please set spark.shuffle.service.enabled to false or set SPARK_WORKER_INSTANCES to 1 to resolve the conflict.");
        rpcEnv.awaitTermination();
    }

    public RpcEnv startRpcEnvAndEndpoint(String host, int port, int webUiPort, int cores, int memory, String[] masterUrls, String workDir, Option<Object> workerNumber, SparkConf conf, Option<String> resourceFileOpt) {
        String systemName = this.SYSTEM_NAME() + workerNumber.map((Function1 & Serializable)x$16 -> Worker$.$anonfun$startRpcEnvAndEndpoint$1(BoxesRunTime.unboxToInt((Object)x$16))).getOrElse((Function0 & Serializable)() -> "");
        SecurityManager securityMgr = new SecurityManager(conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3());
        RpcEnv rpcEnv = RpcEnv$.MODULE$.create(systemName, host, port, conf, securityMgr, RpcEnv$.MODULE$.create$default$6());
        RpcAddress[] masterAddresses = (RpcAddress[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])masterUrls), (Function1 & Serializable)sparkUrl -> RpcAddress$.MODULE$.fromSparkURL((String)sparkUrl), ClassTag$.MODULE$.apply(RpcAddress.class));
        rpcEnv.setupEndpoint(this.ENDPOINT_NAME(), new Worker(rpcEnv, webUiPort, cores, memory, masterAddresses, this.ENDPOINT_NAME(), workDir, conf, securityMgr, resourceFileOpt, this.$lessinit$greater$default$11()));
        return rpcEnv;
    }

    public Option<Object> startRpcEnvAndEndpoint$default$8() {
        return None$.MODULE$;
    }

    public SparkConf startRpcEnvAndEndpoint$default$9() {
        return new SparkConf();
    }

    public Option<String> startRpcEnvAndEndpoint$default$10() {
        return None$.MODULE$;
    }

    public boolean isUseLocalNodeSSLConfig(Command cmd) {
        Option result = cmd.javaOpts().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = Worker$.MODULE$.org$apache$spark$deploy$worker$Worker$$SSL_NODE_LOCAL_CONFIG_PATTERN().unapplySeq(A1)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                    String _result = (String)((LinearSeqOps)option.get()).apply(0);
                    return (B1)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(_result)));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                Option option;
                String string = x1;
                return string != null && !(option = Worker$.MODULE$.org$apache$spark$deploy$worker$Worker$$SSL_NODE_LOCAL_CONFIG_PATTERN().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0;
            }
        });
        return BoxesRunTime.unboxToBoolean((Object)result.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public Command maybeUpdateSSLSettings(Command cmd, SparkConf conf) {
        String prefix = "spark.ssl.";
        String useNLC = "spark.ssl.useNodeLocalConf";
        if (this.isUseLocalNodeSSLConfig(cmd)) {
            Seq newJavaOpts;
            Seq x$1 = newJavaOpts = (Seq)((SeqOps)((IterableOps)cmd.javaOpts().filter((Function1 & Serializable)opt -> BoxesRunTime.boxToBoolean((boolean)Worker$.$anonfun$maybeUpdateSSLSettings$1(prefix, opt)))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])conf.getAll()), (PartialFunction)new Serializable(prefix){
                private static final long serialVersionUID = 0L;
                private final String prefix$1;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String key = (String)A1._1();
                        String value = (String)A1._2();
                        if (key.startsWith(this.prefix$1)) {
                            return (B1)("-D" + key + "=" + value);
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    String key;
                    Tuple2<String, String> tuple2 = x1;
                    return tuple2 != null && (key = (String)tuple2._1()).startsWith(this.prefix$1);
                }
                {
                    this.prefix$1 = prefix$1;
                }
            }, ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)("-D" + useNLC + "=true"));
            String x$2 = cmd.copy$default$1();
            Seq<String> x$3 = cmd.copy$default$2();
            Map<String, String> x$4 = cmd.copy$default$3();
            Seq<String> x$5 = cmd.copy$default$4();
            Seq<String> x$6 = cmd.copy$default$5();
            return cmd.copy(x$2, x$3, x$4, x$5, x$6, (Seq<String>)x$1);
        }
        return cmd;
    }

    public static final /* synthetic */ String $anonfun$startRpcEnvAndEndpoint$1(int x$16) {
        return Integer.toString(x$16);
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateSSLSettings$1(String prefix$1, String opt) {
        return !opt.startsWith("-D" + prefix$1);
    }

    private Worker$() {
    }
}

