/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.rbac.AggregationRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AggregationRuleFluent<A extends AggregationRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LabelSelectorBuilder> clusterRoleSelectors = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AggregationRuleFluent() {
    }

    public AggregationRuleFluent(AggregationRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AggregationRule instance) {
        AggregationRule aggregationRule = instance = instance != null ? instance : new AggregationRule();
        if (instance != null) {
            this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToClusterRoleSelectors(int index, LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this._visitables.get((Object)"clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        } else {
            this._visitables.get((Object)"clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClusterRoleSelectors(int index, LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this._visitables.get((Object)"clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        } else {
            this._visitables.get((Object)"clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClusterRoleSelectors(LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToClusterRoleSelectors(Collection<LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClusterRoleSelectors(LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            return (A)((Object)this);
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"clusterRoleSelectors").remove(builder);
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClusterRoleSelectors(Collection<LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            return (A)((Object)this);
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"clusterRoleSelectors").remove(builder);
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromClusterRoleSelectors(Predicate<LabelSelectorBuilder> predicate) {
        if (this.clusterRoleSelectors == null) {
            return (A)((Object)this);
        }
        Iterator<LabelSelectorBuilder> each = this.clusterRoleSelectors.iterator();
        List visitables = this._visitables.get((Object)"clusterRoleSelectors");
        while (each.hasNext()) {
            LabelSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LabelSelector> buildClusterRoleSelectors() {
        return this.clusterRoleSelectors != null ? AggregationRuleFluent.build(this.clusterRoleSelectors) : null;
    }

    public LabelSelector buildClusterRoleSelector(int index) {
        return this.clusterRoleSelectors.get(index).build();
    }

    public LabelSelector buildFirstClusterRoleSelector() {
        return this.clusterRoleSelectors.get(0).build();
    }

    public LabelSelector buildLastClusterRoleSelector() {
        return this.clusterRoleSelectors.get(this.clusterRoleSelectors.size() - 1).build();
    }

    public LabelSelector buildMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClusterRoleSelectors(List<LabelSelector> clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this._visitables.get((Object)"clusterRoleSelectors").clear();
        }
        if (clusterRoleSelectors != null) {
            this.clusterRoleSelectors = new ArrayList();
            for (LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        } else {
            this.clusterRoleSelectors = null;
        }
        return (A)((Object)this);
    }

    public A withClusterRoleSelectors(LabelSelector ... clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this.clusterRoleSelectors.clear();
            this._visitables.remove((Object)"clusterRoleSelectors");
        }
        if (clusterRoleSelectors != null) {
            for (LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClusterRoleSelectors() {
        return this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty();
    }

    public ClusterRoleSelectorsNested<A> addNewClusterRoleSelector() {
        return new ClusterRoleSelectorsNested(-1, null);
    }

    public ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(LabelSelector item) {
        return new ClusterRoleSelectorsNested(-1, item);
    }

    public ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index, LabelSelector item) {
        return new ClusterRoleSelectorsNested(index, item);
    }

    public ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index) {
        if (this.clusterRoleSelectors.size() <= index) {
            throw new RuntimeException("Can't edit clusterRoleSelectors. Index exceeds size.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector() {
        if (this.clusterRoleSelectors.size() == 0) {
            throw new RuntimeException("Can't edit first clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(0, this.buildClusterRoleSelector(0));
    }

    public ClusterRoleSelectorsNested<A> editLastClusterRoleSelector() {
        int index = this.clusterRoleSelectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterRoleSelectors.size(); ++i) {
            if (!predicate.test(this.clusterRoleSelectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterRoleSelectors. No match found.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregationRuleFluent that = (AggregationRuleFluent)((Object)o);
        if (!Objects.equals(this.clusterRoleSelectors, that.clusterRoleSelectors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterRoleSelectors, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty()) {
            sb.append("clusterRoleSelectors:");
            sb.append(String.valueOf(this.clusterRoleSelectors) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterRoleSelectorsNested<N>
    extends LabelSelectorFluent<ClusterRoleSelectorsNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;
        int index;

        ClusterRoleSelectorsNested(int index, LabelSelector item) {
            this.index = index;
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)AggregationRuleFluent.this.setToClusterRoleSelectors(this.index, this.builder.build());
        }

        public N endClusterRoleSelector() {
            return this.and();
        }
    }
}

