/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampFromDateTime;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampFromDateTime$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec[, timezone]) - Create the current timestamp with local time zone from year, month, day, hour, min, sec and timezone fields. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.\n\n    _FUNC_(date[, time[, timezone]]) - Create timestamp from date and time fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * date - a date expression\n      * time - a time expression (optional). Default is 00:00:00.\n      * timezone - the time zone identifier (optional). For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28');\n       2014-12-28 00:00:00\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887', 'CET');\n       2014-12-27 21:30:45.887\n  ", group="datetime_funcs", since="3.0.0")
public final class MakeTimestampExpressionBuilder$
implements ExpressionBuilder {
    public static final MakeTimestampExpressionBuilder$ MODULE$ = new MakeTimestampExpressionBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 1) {
            return new MakeTimestampFromDateTime((Expression)expressions.apply(0), MakeTimestampFromDateTime$.MODULE$.apply$default$2(), MakeTimestampFromDateTime$.MODULE$.apply$default$3(), MakeTimestampFromDateTime$.MODULE$.apply$default$4());
        }
        if (numArgs == 2) {
            return new MakeTimestampFromDateTime((Expression)expressions.apply(0), (Option<Expression>)new Some(expressions.apply(1)), MakeTimestampFromDateTime$.MODULE$.apply$default$3(), MakeTimestampFromDateTime$.MODULE$.apply$default$4());
        }
        if (numArgs == 3) {
            return new MakeTimestampFromDateTime((Expression)expressions.apply(0), (Option<Expression>)new Some(expressions.apply(1)), (Option<Expression>)new Some(expressions.apply(2)), MakeTimestampFromDateTime$.MODULE$.apply$default$4());
        }
        if (numArgs == 6) {
            return new MakeTimestamp((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3), (Expression)expressions.apply(4), (Expression)expressions.apply(5), MakeTimestamp$.MODULE$.apply$default$7(), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9(), MakeTimestamp$.MODULE$.apply$default$10());
        }
        if (numArgs == 7) {
            return new MakeTimestamp((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3), (Expression)expressions.apply(4), (Expression)expressions.apply(5), (Option<Expression>)new Some(expressions.apply(6)), MakeTimestamp$.MODULE$.apply$default$8(), MakeTimestamp$.MODULE$.apply$default$9(), MakeTimestamp$.MODULE$.apply$default$10());
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 6, 7}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private MakeTimestampExpressionBuilder$() {
    }
}

