/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.types.variant.VariantUtil;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u001d4aa\u0003\u0007!\u0002\u001bY\u0002\"\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011*\u0011%Q\u0003A!A!\u0002\u0013Y\u0003\u0007C\u00052\u0001\t\u0005\t\u0015!\u00033w!)A\b\u0001C\u0001{!1!\t\u0001Q\u0001\n\rCa\u0001\u0014\u0001!\u0002\u0013i\u0005B\u0002(\u0001A\u0003%q\nC\u0003S\u0001\u0011\u00053\u000bC\u0006d\u0001A\u0005\u0019\u0011!A\u0005\n\u0011L\u0003bC3\u0001!\u0003\r\t\u0011!C\u0005Mn\u0012Ab\u0015;sk\u000e$(+Z1eKJT!!\u0004\b\u0002\u000fA\f'/];fi*\u0011q\u0002E\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0012%\u0005IQ\r_3dkRLwN\u001c\u0006\u0003'Q\t1a]9m\u0015\t)b#A\u0003ta\u0006\u00148N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0003\u0001q\u0001\"!\b\u0010\u000e\u00031I!a\b\u0007\u0003)A\u000b'/];fiZ\u000b'/[1oiJ+\u0017\rZ3s\u0003\u0019\u00198\r[3nCB\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\bm\u0006\u0014\u0018.\u00198u\u0015\t1C#A\u0003usB,7/\u0003\u0002)G\tia+\u0019:jC:$8k\u00195f[\u0006L!\u0001\t\u0010\u0002\u0015Q\f'oZ3u)f\u0004X\r\u0005\u0002-]5\tQF\u0003\u0002'%%\u0011q&\f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017B\u0001\u0016\u001f\u0003!\u0019\u0017m\u001d;Be\u001e\u001c\bCA\u001a:\u001b\u0005!$B\u0001\u00136\u0015\t1t'A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u001d\u0013\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001e5\u0005=1\u0016M]5b]R\u001c\u0015m\u001d;Be\u001e\u001c\u0018BA\u0019\u001f\u0003\u0019a\u0014N\\5u}Q!ah\u0010!B!\ti\u0002\u0001C\u0003!\t\u0001\u0007\u0011\u0005C\u0003+\t\u0001\u00071\u0006C\u00032\t\u0001\u0007!'A\tgS\u0016dG-\u00138qkRLe\u000eZ5dKN\u00042\u0001R$J\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%!B!se\u0006L\bC\u0001#K\u0013\tYUIA\u0002J]R\fABZ5fY\u0012\u0014V-\u00193feN\u00042\u0001R$\u001d\u0003QqW-\u001a3V]ND'/\u001a3eK\u0012|%M[3diB\u0011A\tU\u0005\u0003#\u0016\u0013qAQ8pY\u0016\fg.A\u0007sK\u0006$gI]8n)f\u0004X\r\u001a\u000b\u0004)^k\u0006C\u0001#V\u0013\t1VIA\u0002B]fDQ\u0001\u0017\u0005A\u0002e\u000b1A]8x!\tQ6,D\u00018\u0013\tavGA\u0006J]R,'O\\1m%><\b\"\u00020\t\u0001\u0004y\u0016\u0001\u0005;pa2+g/\u001a7NKR\fG-\u0019;b!\r!u\t\u0019\t\u0003\t\u0006L!AY#\u0003\t\tKH/Z\u0001\rgV\u0004XM\u001d\u0013tG\",W.Y\u000b\u0002C\u0005q1/\u001e9fe\u0012\u001a\u0017m\u001d;Be\u001e\u001cX#\u0001\u001a")
public final class StructReader
extends ParquetVariantReader {
    private final int[] fieldInputIndices = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)super.targetType()).fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToInteger((int)StructReader.$anonfun$fieldInputIndices$1(this, f)), (ClassTag)ClassTag$.MODULE$.Int());
    private final ParquetVariantReader[] fieldReaders = (ParquetVariantReader[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])((StructType)super.targetType()).fields()), (IterableOnce)Predef$.MODULE$.wrapIntArray(this.fieldInputIndices))), (Function1 & Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            int inputIdx = tuple2._2$mcI$sp();
            if (inputIdx >= 0) {
                VariantSchema fieldSchema = $this.super$schema().objectSchema[inputIdx].schema;
                return ParquetVariantReader$.MODULE$.apply(fieldSchema, f.dataType(), this.super$castArgs(), ParquetVariantReader$.MODULE$.apply$default$4());
            }
            return null;
        }
        throw new MatchError((Object)tuple2);
    }, ClassTag$.MODULE$.apply(ParquetVariantReader.class));
    private final boolean needUnshreddedObject = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.intArrayOps(this.fieldInputIndices), (Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 < 0);

    private /* synthetic */ VariantSchema super$schema() {
        return super.schema();
    }

    private /* synthetic */ VariantCastArgs super$castArgs() {
        return super.castArgs();
    }

    @Override
    public Object readFromTyped(InternalRow row, byte[] topLevelMetadata) {
        if (super.schema().objectSchema == null) {
            return this.invalidCast(row, topLevelMetadata);
        }
        InternalRow obj = row.getStruct(super.schema().typedIdx, super.schema().objectSchema.length);
        GenericInternalRow result = new GenericInternalRow(this.fieldInputIndices.length);
        Variant unshreddedObject = null;
        if (this.needUnshreddedObject && super.schema().variantIdx >= 0 && !row.isNullAt(super.schema().variantIdx)) {
            unshreddedObject = new Variant(row.getBinary(super.schema().variantIdx), topLevelMetadata);
            VariantUtil.Type type = unshreddedObject.getType();
            VariantUtil.Type type2 = VariantUtil.Type.OBJECT;
            if (type == null ? type2 != null : !type.equals(type2)) {
                throw QueryExecutionErrors$.MODULE$.malformedVariant();
            }
        }
        int numFields = this.fieldInputIndices.length;
        for (int i = 0; i < numFields; ++i) {
            int inputIdx = this.fieldInputIndices[i];
            if (inputIdx >= 0) {
                if (obj.isNullAt(inputIdx)) {
                    throw QueryExecutionErrors$.MODULE$.malformedVariant();
                }
                VariantSchema fieldSchema = super.schema().objectSchema[inputIdx].schema;
                InternalRow fieldInput = obj.getStruct(inputIdx, fieldSchema.numFields);
                if ((fieldSchema.typedIdx < 0 || fieldInput.isNullAt(fieldSchema.typedIdx)) && (fieldSchema.variantIdx < 0 || fieldInput.isNullAt(fieldSchema.variantIdx))) continue;
                result.update(i, this.fieldReaders[i].read(fieldInput, topLevelMetadata));
                continue;
            }
            if (unshreddedObject == null) continue;
            String fieldName = ((StructType)super.targetType()).fields()[i].name();
            DataType fieldType = ((StructType)super.targetType()).fields()[i].dataType();
            Variant unshreddedField = unshreddedObject.getFieldByKey(fieldName);
            if (unshreddedField == null) continue;
            result.update(i, VariantGet$.MODULE$.cast(unshreddedField, fieldType, super.castArgs()));
        }
        return result;
    }

    public static final /* synthetic */ int $anonfun$fieldInputIndices$1(StructReader $this, StructField f) {
        Integer inputIdx;
        Integer n = inputIdx = $this.super$schema().objectSchemaMap != null ? (Integer)$this.super$schema().objectSchemaMap.get(f.name()) : null;
        if (inputIdx != null) {
            return inputIdx;
        }
        return -1;
    }

    public StructReader(VariantSchema schema, StructType targetType, VariantCastArgs castArgs) {
        super(schema, (DataType)targetType, castArgs);
    }
}

