/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\t\u0013\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)\u0011\t\u0001C\u0001\u0005\")\u0011\t\u0001C\u0001)\"1\u0011\t\u0001C\u0001)yC\u0001\u0002\u001e\u0001\t\u0006\u0004%I!\u001e\u0005\t}\u0002A)\u0019!C\u0005\u007f\"I\u0011q\u0001\u0001\t\u0006\u0004%Ia \u0005\n\u0003\u0013\u0001\u0001R1A\u0005\n}D\u0011\"a\u0003\u0001\u0011\u000b\u0007I\u0011B@\t\r\u00055\u0001\u0001\"\u0001\u0000\u0011\u0019\t\t\u0002\u0001C\u0001\u007f\"1\u0011Q\u0003\u0001\u0005\u0002}Da!!\u0007\u0001\t\u0003y\bBBA\u000f\u0001\u0011\u0005q\u0010\u0003\u0005\u0002\"\u0001!\tAFA\u0012\u0005E\u0011Vm\u001a:fgNLwN\\'fiJL7m\u001d\u0006\u0003'Q\t!\"\u001a<bYV\fG/[8o\u0015\t)b#A\u0003nY2L'M\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qEF\u0001\tS:$XM\u001d8bY&\u0011\u0011F\n\u0002\b\u0019><w-\u001b8h\u0003e\u0001(/\u001a3jGRLwN\\!oI>\u00137/\u001a:wCRLwN\\:1\u00051\"\u0004cA\u00171e5\taF\u0003\u00020-\u0005\u0019!\u000f\u001a3\n\u0005Er#a\u0001*E\tB\u00111\u0007\u000e\u0007\u0001\t%)\u0014!!A\u0001\u0002\u000b\u0005aGA\u0002`IE\n\"a\u000e\u001e\u0011\u0005}A\u0014BA\u001d!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aH\u001e\n\u0005q\u0002#a\u0002)s_\u0012,8\r^\u0001\u000ei\"\u0014x.^4i\u001fJLw-\u001b8\u0011\u0005}y\u0014B\u0001!!\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcA\"F\u0015B\u0011A\tA\u0007\u0002%!)!f\u0001a\u0001\rB\u0012q)\u0013\t\u0004[AB\u0005CA\u001aJ\t%)T)!A\u0001\u0002\u000b\u0005a\u0007C\u0003>\u0007\u0001\u0007a\bK\u0002\u0004\u0019J\u0003\"!\u0014)\u000e\u00039S!a\u0014\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002R\u001d\n)1+\u001b8dK\u0006\n1+A\u00033]Ar\u0003\u0007\u0006\u0002D+\")!\u0006\u0002a\u0001-B\u0012q+\u0017\t\u0004[AB\u0006CA\u001aZ\t%QV+!A\u0001\u0002\u000b\u0005aGA\u0002`IIB3\u0001\u0002']C\u0005i\u0016!B\u0019/e9\u0002DCA\"`\u0011\u0015QS\u00011\u0001a!\t\t\u0017O\u0004\u0002c]:\u00111\r\u001c\b\u0003I.t!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!d\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\tI\"$\u0003\u0002\u00181%\u0011QNF\u0001\u0004gFd\u0017BA8q\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u001c\f\n\u0005I\u001c(!\u0003#bi\u00064%/Y7f\u0015\ty\u0007/A\u0004tk6l\u0017M]=\u0016\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\tM$\u0018\r\u001e\u0006\u0003wZ\t!!\u001c7\n\u0005uD(\u0001E*v[6\f'/\u001b>fe\n+hMZ3s\u0003\r\u00196+_\u000b\u0003\u0003\u0003\u00012aHA\u0002\u0013\r\t)\u0001\t\u0002\u0007\t>,(\r\\3\u0002\u000bM\u001bVM\u001d:\u0002\u000bM\u001bFo\u001c;\u0002\u000bM\u001b&/Z4\u0002#\u0015D\b\u000f\\1j]\u0016$g+\u0019:jC:\u001cW\rK\u0002\f\u0019r\u000b\u0011#\\3b]\u0006\u00137o\u001c7vi\u0016,%O]8sQ\raA\nX\u0001\u0011[\u0016\fgnU9vCJ,G-\u0012:s_JD3!\u0004']\u0003Q\u0011xn\u001c;NK\u0006t7+];be\u0016$WI\u001d:pe\"\u001aa\u0002\u0014/\u0002\u0005I\u0014\u0004fA\bM9\u0006)1m\\;oiV\u0011\u0011Q\u0005\t\u0004?\u0005\u001d\u0012bAA\u0015A\t!Aj\u001c8hQ\r\u0001A\n\u0018")
public class RegressionMetrics
implements Logging {
    private SummarizerBuffer summary;
    private double SSy;
    private double SSerr;
    private double SStot;
    private double SSreg;
    private final RDD<? extends Product> predictionAndObservations;
    private final boolean throughOrigin;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SummarizerBuffer summary$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                RDD weightedVectors = this.predictionAndObservations.map((Function1 & Serializable)x0$1 -> {
                    Product product = x0$1;
                    if (product instanceof Tuple3) {
                        Tuple3 tuple3 = (Tuple3)product;
                        Object prediction = tuple3._1();
                        Object observation = tuple3._2();
                        Object weight = tuple3._3();
                        if (prediction instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)prediction);
                            if (observation instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)observation);
                                if (weight instanceof Double) {
                                    double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                    return new Tuple2((Object)Vectors$.MODULE$.dense(d2, (Seq<Object>)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{d2 - d, d})), (Object)BoxesRunTime.boxToDouble((double)d3));
                                }
                            }
                        }
                    }
                    if (!(product instanceof Tuple2)) throw new MatchError((Object)product);
                    Tuple2 tuple2 = (Tuple2)product;
                    Object prediction = tuple2._1();
                    Object observation = tuple2._2();
                    if (!(prediction instanceof Double)) throw new MatchError((Object)product);
                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (!(observation instanceof Double)) throw new MatchError((Object)product);
                    double d4 = BoxesRunTime.unboxToDouble((Object)observation);
                    return new Tuple2((Object)Vectors$.MODULE$.dense(d4, (Seq<Object>)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{d4 - d, d})), (Object)BoxesRunTime.boxToDouble((double)1.0));
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                this.summary = Statistics$.MODULE$.colStats((RDD<Tuple2<Vector, Object>>)weightedVectors, (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "normL1", "normL2", "variance"}))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.summary;
    }

    private SummarizerBuffer summary() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.summary$lzycompute() : this.summary;
    }

    private double SSy$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.SSy = package$.MODULE$.pow(this.summary().normL2().apply(0), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.SSy;
    }

    private double SSy() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.SSy$lzycompute() : this.SSy;
    }

    private double SSerr$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SSerr = package$.MODULE$.pow(this.summary().normL2().apply(1), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SSerr;
    }

    private double SSerr() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SSerr$lzycompute() : this.SSerr;
    }

    private double SStot$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SStot = this.summary().variance().apply(0) * (this.summary().weightSum() - 1.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SStot;
    }

    private double SStot() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SStot$lzycompute() : this.SStot;
    }

    private double SSreg$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.SSreg = package$.MODULE$.pow(this.summary().normL2().apply(2), 2.0) + package$.MODULE$.pow(this.summary().mean().apply(0), 2.0) * this.summary().weightSum() - (double)2 * this.summary().mean().apply(0) * this.summary().mean().apply(2) * this.summary().weightSum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.SSreg;
    }

    private double SSreg() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.SSreg$lzycompute() : this.SSreg;
    }

    public double explainedVariance() {
        return this.SSreg() / this.summary().weightSum();
    }

    public double meanAbsoluteError() {
        return this.summary().normL1().apply(1) / this.summary().weightSum();
    }

    public double meanSquaredError() {
        return this.SSerr() / this.summary().weightSum();
    }

    public double rootMeanSquaredError() {
        return package$.MODULE$.sqrt(this.meanSquaredError());
    }

    public double r2() {
        return this.throughOrigin ? 1.0 - this.SSerr() / this.SSy() : 1.0 - this.SSerr() / this.SStot();
    }

    public long count() {
        return this.summary().count();
    }

    public RegressionMetrics(RDD<? extends Product> predictionAndObservations, boolean throughOrigin) {
        this.predictionAndObservations = predictionAndObservations;
        this.throughOrigin = throughOrigin;
        Logging.$init$((Logging)this);
    }

    public RegressionMetrics(RDD<? extends Product> predictionAndObservations) {
        this(predictionAndObservations, false);
    }

    public RegressionMetrics(Dataset<Row> predictionAndObservations) {
        this((RDD<? extends Product>)predictionAndObservations.rdd().map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple3<Object, Object, Object> apply(Row x0$1) {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                    Object prediction = ((SeqOps)some.get()).apply(0);
                    Object label = ((SeqOps)some.get()).apply(1);
                    Object weight = ((SeqOps)some.get()).apply(2);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            if (weight instanceof Double) {
                                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
                            }
                        }
                    }
                }
                if (row == null) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                Some some2 = Row$.MODULE$.unapplySeq(row);
                if (some2.isEmpty()) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                if (some2.get() == null) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                if (((SeqOps)some2.get()).lengthCompare(2) != 0) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                Object prediction = ((SeqOps)some2.get()).apply(0);
                Object label = ((SeqOps)some2.get()).apply(1);
                if (!(prediction instanceof Double)) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                double d = BoxesRunTime.unboxToDouble((Object)prediction);
                if (!(label instanceof Double)) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                double d4 = BoxesRunTime.unboxToDouble((Object)label);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d4), (Object)BoxesRunTime.boxToDouble((double)1.0));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)));
    }
}

