/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\u0010 \u0001)B\u0001B\u0011\u0001\u0003\u0006\u0004%\te\u0011\u0005\t5\u0002\u0011\t\u0011)A\u0005\t\")A\f\u0001C\u0001;\")A\f\u0001C\u0001C\")1\r\u0001C\u0001I\")Q\u000e\u0001C\u0001]\")\u0011\u000f\u0001C\u0001e\")q\u000f\u0001C)q\"A\u00111\u0004\u0001\u0005\u0002\r\ni\u0002C\u0004\u00026\u0001!I!a\u000e\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011\u0011\r\u0001\u0005B\u0005\rtaBA=?!\u0005\u00111\u0010\u0004\u0007=}A\t!! \t\rqsA\u0011AAN\u0011%\tiJ\u0004b\u0001\n\u0003y2\tC\u0004\u0002 :\u0001\u000b\u0011\u0002#\t\u0013\u0005\u0005fB1A\u0005\u0002}\u0019\u0005bBAR\u001d\u0001\u0006I\u0001\u0012\u0005\n\u0003Ks!\u0019!C\u0001?\rCq!a*\u000fA\u0003%A\tC\u0005\u0002*:\u0011\r\u0011\"\u0001 \u0007\"9\u00111\u0016\b!\u0002\u0013!\u0005BCAW\u001d\t\u0007I\u0011A\u0010\u00020\"A\u0011\u0011\u0019\b!\u0002\u0013\t\t\f\u0003\u0005\u0002D:!\t!IAc\u0011!\t\tN\u0004C\u0001C\u0005M\u0007bBAl\u001d\u0011\u0005\u0013\u0011\u001c\u0005\n\u0003Kt\u0011\u0011!C\u0005\u0003O\u0014!BT1jm\u0016\u0014\u0015-_3t\u0015\t\u0001\u0013%\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\t\u001a\u0013AA7m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-JD\bE\u0003-[=*d'D\u0001 \u0013\tqsDA\fQe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5feB\u0011\u0001gM\u0007\u0002c)\u0011!'I\u0001\u0007Y&t\u0017\r\\4\n\u0005Q\n$A\u0002,fGR|'\u000f\u0005\u0002-\u0001A\u0011AfN\u0005\u0003q}\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\t\u0003YiJ!aO\u0010\u0003!9\u000b\u0017N^3CCf,7\u000fU1sC6\u001c\bCA\u001fA\u001b\u0005q$BA \"\u0003\u0011)H/\u001b7\n\u0005\u0005s$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#\u0001#\u0011\u0005\u0015seB\u0001$M!\t9%*D\u0001I\u0015\tI\u0015&\u0001\u0004=e>|GO\u0010\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJS\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N\u0015\"\u001a\u0011A\u0015-\u0011\u0005M3V\"\u0001+\u000b\u0005U\u001b\u0013AC1o]>$\u0018\r^5p]&\u0011q\u000b\u0016\u0002\u0006'&t7-Z\u0011\u00023\u0006)\u0011GL\u001b/a\u0005!Q/\u001b3!Q\r\u0011!\u000bW\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Ur\u0006\"\u0002\"\u0004\u0001\u0004!\u0005f\u00010S1\"\u001a1A\u0015-\u0015\u0003UB3\u0001\u0002*Y\u00031\u0019X\r^*n_>$\b.\u001b8h)\t)g-D\u0001\u0001\u0011\u00159W\u00011\u0001i\u0003\u00151\u0018\r\\;f!\tI'.D\u0001K\u0013\tY'J\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u000bIC\u0016\u0001D:fi6{G-\u001a7UsB,GCA3p\u0011\u00159g\u00011\u0001EQ\r1!\u000bW\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0003KNDQaZ\u0004A\u0002\u0011C3a\u0002*vC\u00051\u0018!\u0002\u001a/c9\u0002\u0014!\u0002;sC&tGC\u0001\u001cz\u0011\u0015Q\b\u00021\u0001|\u0003\u001d!\u0017\r^1tKR\u00044\u0001`A\u0005!\u0015i\u0018\u0011AA\u0003\u001b\u0005q(BA@$\u0003\r\u0019\u0018\u000f\\\u0005\u0004\u0003\u0007q(a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u000f\tI\u0001\u0004\u0001\u0005\u0017\u0005-\u00110!A\u0001\u0002\u000b\u0005\u0011Q\u0002\u0002\u0004?\u0012\n\u0014\u0003BA\b\u0003+\u00012![A\t\u0013\r\t\u0019B\u0013\u0002\b\u001d>$\b.\u001b8h!\rI\u0017qC\u0005\u0004\u00033Q%aA!os\u0006\u0019BO]1j]^KG\u000f\u001b'bE\u0016d7\t[3dWR)a'a\b\u0002,!1!0\u0003a\u0001\u0003C\u0001D!a\t\u0002(A)Q0!\u0001\u0002&A!\u0011qAA\u0014\t1\tI#a\b\u0002\u0002\u0003\u0005)\u0011AA\u0007\u0005\ryFE\r\u0005\b\u0003[I\u0001\u0019AA\u0018\u0003AqwN\u001c(fO\u0006$\u0018N^3MC\n,G\u000eE\u0002j\u0003cI1!a\rK\u0005\u001d\u0011un\u001c7fC:\f\u0011\u0003\u001e:bS:$\u0015n]2sKR,\u0017*\u001c9m)\u00151\u0014\u0011HA#\u0011\u0019Q(\u00021\u0001\u0002<A\"\u0011QHA!!\u0015i\u0018\u0011AA !\u0011\t9!!\u0011\u0005\u0019\u0005\r\u0013\u0011HA\u0001\u0002\u0003\u0015\t!!\u0004\u0003\u0007}#3\u0007C\u0004\u0002H)\u0001\r!!\u0013\u0002\u000b%t7\u000f\u001e:\u0011\u0007u\nY%C\u0002\u0002Ny\u0012q\"\u00138tiJ,X.\u001a8uCRLwN\\\u0001\u0012iJ\f\u0017N\\$bkN\u001c\u0018.\u00198J[BdG#\u0002\u001c\u0002T\u0005}\u0003B\u0002>\f\u0001\u0004\t)\u0006\r\u0003\u0002X\u0005m\u0003#B?\u0002\u0002\u0005e\u0003\u0003BA\u0004\u00037\"A\"!\u0018\u0002T\u0005\u0005\t\u0011!B\u0001\u0003\u001b\u00111a\u0018\u00135\u0011\u001d\t9e\u0003a\u0001\u0003\u0013\nAaY8qsR\u0019Q'!\u001a\t\u000f\u0005\u001dD\u00021\u0001\u0002j\u0005)Q\r\u001f;sCB!\u00111NA9\u001b\t\tiGC\u0002\u0002p\u0005\nQ\u0001]1sC6LA!a\u001d\u0002n\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002\r%bC3\u0001\u0001*Y\u0003)q\u0015-\u001b<f\u0005\u0006LXm\u001d\t\u0003Y9\u0019rADA@\u0003\u000b\u000bY\tE\u0002j\u0003\u0003K1!a!K\u0005\u0019\te.\u001f*fMB!Q(a\"6\u0013\r\tII\u0010\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b!![8\u000b\u0005\u0005U\u0015\u0001\u00026bm\u0006LA!!'\u0002\u0010\na1+\u001a:jC2L'0\u00192mKR\u0011\u00111P\u0001\f\u001bVdG/\u001b8p[&\fG.\u0001\u0007Nk2$\u0018N\\8nS\u0006d\u0007%A\u0005CKJtw.\u001e7mS\u0006Q!)\u001a:o_VdG.\u001b\u0011\u0002\u0011\u001d\u000bWo]:jC:\f\u0011bR1vgNL\u0017M\u001c\u0011\u0002\u0015\r{W\u000e\u001d7f[\u0016tG/A\u0006D_6\u0004H.Z7f]R\u0004\u0013aE:vaB|'\u000f^3e\u001b>$W\r\u001c+za\u0016\u001cXCAAY!\u0015\t\u0019,!0E\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016!C5n[V$\u0018M\u00197f\u0015\r\tYLS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA`\u0003k\u00131aU3u\u0003Q\u0019X\u000f\u001d9peR,G-T8eK2$\u0016\u0010]3tA\u0005A\"/Z9vSJ,gj\u001c8oK\u001e\fG/\u001b<f-\u0006dW/Z:\u0015\t\u0005\u001d\u0017Q\u001a\t\u0004S\u0006%\u0017bAAf\u0015\n!QK\\5u\u0011\u0019\tyM\u0007a\u0001_\u0005\ta/A\u000fsKF,\u0018N]3[KJ|wJ\\3CKJtw.\u001e7mSZ\u000bG.^3t)\u0011\t9-!6\t\r\u0005=7\u00041\u00010\u0003\u0011aw.\u00193\u0015\u0007U\nY\u000e\u0003\u0004\u0002^r\u0001\r\u0001R\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u001d%\u0006\u0005\u0018EAAr\u0003\u0015\tdF\u000e\u00181\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tI\u000f\u0005\u0003\u0002l\u0006EXBAAw\u0015\u0011\ty/a%\u0002\t1\fgnZ\u0005\u0005\u0003g\fiO\u0001\u0004PE*,7\r\u001e\u0015\u0005\u001dI\u000b\t\u000f\u000b\u0003\u000e%\u0006\u0005\b")
public class NaiveBayes
extends ProbabilisticClassifier<Vector, NaiveBayes, NaiveBayesModel>
implements NaiveBayesParams,
DefaultParamsWritable {
    private final String uid;
    private DoubleParam smoothing;
    private Param<String> modelType;
    private Param<String> weightCol;

    public static NaiveBayes load(String path) {
        return NaiveBayes$.MODULE$.load(path);
    }

    public static MLReader<NaiveBayes> read() {
        return NaiveBayes$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public NaiveBayes setSmoothing(double value) {
        return (NaiveBayes)this.set(this.smoothing(), BoxesRunTime.boxToDouble((double)value));
    }

    public NaiveBayes setModelType(String value) {
        return (NaiveBayes)this.set(this.modelType(), value);
    }

    public NaiveBayes setWeightCol(String value) {
        return (NaiveBayes)this.set(this.weightCol(), value);
    }

    @Override
    public NaiveBayesModel train(Dataset<?> dataset) {
        return this.trainWithLabelCheck(dataset, true);
    }

    public NaiveBayesModel trainWithLabelCheck(Dataset<?> dataset, boolean nonNegativeLabel) {
        return (NaiveBayesModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            NaiveBayesModel naiveBayesModel;
            boolean bl;
            Column column;
            boolean bl2;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.weightCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.modelType(), this.smoothing(), this.thresholds()}));
            Column validatedLabelCol = nonNegativeLabel ? DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)this.get(this.thresholds()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)NaiveBayes.$anonfun$trainWithLabelCheck$2(x$1)))) : DatasetUtils$.MODULE$.checkRegressionLabels(this.$(this.labelCol()));
            Column validatedWeightCol = DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()));
            String string = this.$(this.modelType());
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl2 = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Complement();
                String string5 = string;
                bl2 = !(string4 != null ? !string4.equals(string5) : string5 != null);
            }
            if (bl2) {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_NaiveBayes$$typecreator1$1(NaiveBayes $outer) {
                    }
                }
                UserDefinedFunction checkNonNegativeVector = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToBoolean((boolean)NaiveBayes.$anonfun$trainWithLabelCheck$3(vector)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator1$1(null)));
                Column vecCol = functions$.MODULE$.col(this.$(this.featuresCol()));
                column = functions$.MODULE$.when(vecCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(checkNonNegativeVector.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vecCol})).unary_$bang(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST NOT be Negative, NaN or Infinity, but got "), vecCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vecCol);
            } else {
                String string6 = NaiveBayes$.MODULE$.Bernoulli();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_NaiveBayes$$typecreator2$1(NaiveBayes $outer) {
                        }
                    }
                    UserDefinedFunction checkBinaryVector = functions$.MODULE$.udf((Function1 & Serializable)vector -> BoxesRunTime.boxToBoolean((boolean)NaiveBayes.$anonfun$trainWithLabelCheck$6(vector)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator2$1(null)));
                    Column vecCol = functions$.MODULE$.col(this.$(this.featuresCol()));
                    column = functions$.MODULE$.when(vecCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(checkBinaryVector.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{vecCol})).unary_$bang(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST be in {0, 1}, but got "), vecCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vecCol);
                } else {
                    column = DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()));
                }
            }
            Column validatedfeaturesCol = column;
            Dataset validated = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{validatedLabelCol.as("_validated_label_"), validatedWeightCol.as("_validated_weight_"), validatedfeaturesCol.as("_validated_features_")}));
            String string8 = this.$(this.modelType());
            String string9 = NaiveBayes$.MODULE$.Bernoulli();
            String string10 = string8;
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                bl = true;
            } else {
                String string11 = NaiveBayes$.MODULE$.Multinomial();
                String string12 = string8;
                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                    bl = true;
                } else {
                    String string13 = NaiveBayes$.MODULE$.Complement();
                    String string14 = string8;
                    bl = !(string13 != null ? !string13.equals(string14) : string14 != null);
                }
            }
            if (bl) {
                naiveBayesModel = this.trainDiscreteImpl((Dataset<?>)validated, (Instrumentation)instr);
            } else {
                String string15 = NaiveBayes$.MODULE$.Gaussian();
                String string16 = string8;
                if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                    naiveBayesModel = this.trainGaussianImpl((Dataset<?>)validated, (Instrumentation)instr);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(20).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(".").toString());
                }
            }
            return naiveBayesModel;
        });
    }

    private NaiveBayesModel trainDiscreteImpl(Dataset<?> dataset, Instrumentation instr) {
        NaiveBayesModel naiveBayesModel;
        boolean bl;
        Iterator iterator;
        boolean bl2;
        Object object;
        SparkSession spark = dataset.sparkSession();
        String[] stringArray = dataset.schema().fieldNames();
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String label = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String weight = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String featuers = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        Tuple3 tuple3 = new Tuple3((Object)label, (Object)weight, (Object)featuers);
        Tuple3 tuple32 = tuple3;
        String label2 = (String)tuple32._1();
        String weight2 = (String)tuple32._2();
        String featuers2 = (String)tuple32._3();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1(NaiveBayes $outer) {
            }
        }
        Tuple4[] aggregated = (Tuple4[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])dataset.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(label2)})).agg(functions$.MODULE$.sum(functions$.MODULE$.col(weight2)).as("weightSum"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sum", "count"})).summary(functions$.MODULE$.col(featuers2), functions$.MODULE$.col(weight2)).as("summary")})).select(label2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"weightSum", "summary.sum", "summary.count"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1(null)))).collect()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainDiscreteImpl$1(x$3)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        int numFeatures = ((Vector)((Tuple4)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated)))._3()).size();
        instr.logNumFeatures(numFeatures);
        long numSamples = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)NaiveBayes.$anonfun$trainDiscreteImpl$2(x$4)), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        instr.logNumExamples(numSamples);
        int numLabels = aggregated.length;
        instr.logNumClasses(numLabels);
        double numDocuments = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainDiscreteImpl$3(x$5)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        instr.logSumOfWeights(numDocuments);
        double[] labelArray = new double[numLabels];
        double[] piArray = new double[numLabels];
        double[] thetaArray = new double[numLabels * numFeatures];
        String string = this.$(this.modelType());
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl2 = true;
        } else {
            String string4 = NaiveBayes$.MODULE$.Bernoulli();
            String string5 = string;
            bl2 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl2) {
            iterator = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated));
        } else {
            String string6 = NaiveBayes$.MODULE$.Complement();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                Vector featureSum = Vectors$.MODULE$.zeros(numFeatures);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x0$1 -> {
                    NaiveBayes.$anonfun$trainDiscreteImpl$4(featureSum, x0$1);
                    return BoxedUnit.UNIT;
                });
                iterator = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated)).map((Function1 & Serializable)x0$2 -> {
                    Tuple4 tuple4 = x0$2;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double n = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    Vector sumTermFreqs = (Vector)tuple4._3();
                    long count = BoxesRunTime.unboxToLong((Object)tuple4._4());
                    Vector comp = featureSum.copy();
                    BLAS$.MODULE$.axpy(-1.0, sumTermFreqs, comp);
                    Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)n), (Object)comp, (Object)BoxesRunTime.boxToLong((long)count));
                    return tuple42;
                });
            } else {
                throw new MatchError((Object)string);
            }
        }
        Iterator aggIter = iterator;
        double lambda = BoxesRunTime.unboxToDouble((Object)this.$(this.smoothing()));
        double piLogDenom = scala.math.package$.MODULE$.log(numDocuments + (double)numLabels * lambda);
        IntRef i = IntRef.create((int)0);
        aggIter.foreach((Function1 & Serializable)x0$3 -> {
            NaiveBayes.$anonfun$trainDiscreteImpl$6(this, labelArray, i, piArray, lambda, piLogDenom, numFeatures, thetaArray, x0$3);
            return BoxedUnit.UNIT;
        });
        Vector pi = Vectors$.MODULE$.dense(piArray);
        String string8 = this.$(this.modelType());
        String string9 = NaiveBayes$.MODULE$.Multinomial();
        String string10 = string8;
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            bl = true;
        } else {
            String string11 = NaiveBayes$.MODULE$.Bernoulli();
            String string12 = string8;
            bl = !(string11 != null ? !string11.equals(string12) : string12 != null);
        }
        if (bl) {
            DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, thetaArray, true);
            naiveBayesModel = new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), Matrices$.MODULE$.zeros(0, 0)).setOldLabels(labelArray);
        } else {
            String string13 = NaiveBayes$.MODULE$.Complement();
            String string14 = string8;
            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(thetaArray), (Function1)(JFunction1.mcDD.sp & Serializable)v -> -v, (ClassTag)ClassTag$.MODULE$.Double()), true);
                naiveBayesModel = new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), Matrices$.MODULE$.zeros(0, 0));
            } else {
                throw new MatchError((Object)string8);
            }
        }
        return naiveBayesModel;
    }

    private NaiveBayesModel trainGaussianImpl(Dataset<?> dataset, Instrumentation instr) {
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator10$1(NaiveBayes $outer) {
            }
        }
        Object object;
        SparkSession spark = dataset.sparkSession();
        String[] stringArray = dataset.schema().fieldNames();
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String label = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String weight = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String featuers = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        Tuple3 tuple3 = new Tuple3((Object)label, (Object)weight, (Object)featuers);
        Tuple3 tuple32 = tuple3;
        String label2 = (String)tuple32._1();
        String weight2 = (String)tuple32._2();
        String featuers2 = (String)tuple32._3();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$2(NaiveBayes $outer) {
            }
        }
        Tuple4[] aggregated = (Tuple4[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])dataset.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(label2)})).agg(functions$.MODULE$.sum(functions$.MODULE$.col(weight2)).as("weightSum"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "normL2"})).summary(functions$.MODULE$.col(featuers2), functions$.MODULE$.col(weight2)).as("summary")})).select(label2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"weightSum", "summary.mean", "summary.normL2"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$2(null)))).map((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector normL2 = (Vector)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)weightSum), (Object)mean, (Object)Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(normL2.toArray()), (Function1)(JFunction1.mcDD.sp & Serializable)v -> v * v, (ClassTag)ClassTag$.MODULE$.Double())));
            return tuple42;
        }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator10$1(null)))).collect()), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainGaussianImpl$3(x$7)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        int numFeatures = ((Vector)((Tuple4)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated)))._3()).size();
        instr.logNumFeatures(numFeatures);
        int numLabels = aggregated.length;
        instr.logNumClasses(numLabels);
        double numInstances = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainGaussianImpl$4(x$8)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        instr.logSumOfWeights(numInstances);
        double epsilon = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, numFeatures).map((Function1)(JFunction1.mcDI.sp & Serializable)j -> {
            DoubleRef globalSum = DoubleRef.create((double)0.0);
            DoubleRef globalSqrSum = DoubleRef.create((double)0.0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x0$2 -> {
                NaiveBayes.$anonfun$trainGaussianImpl$6(globalSum, j, globalSqrSum, x0$2);
                return BoxedUnit.UNIT;
            });
            return globalSqrSum.elem / numInstances - globalSum.elem * globalSum.elem / numInstances / numInstances;
        }).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)) * 1.0E-9;
        double[] piArray = new double[numLabels];
        double[] thetaArray = new double[numLabels * numFeatures];
        double[] sigmaArray = new double[numLabels * numFeatures];
        IntRef i = IntRef.create((int)0);
        double logNumInstances = scala.math.package$.MODULE$.log(numInstances);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])aggregated), (Function1 & Serializable)x0$3 -> {
            NaiveBayes.$anonfun$trainGaussianImpl$7(piArray, i, logNumInstances, numFeatures, thetaArray, sigmaArray, epsilon, x0$3);
            return BoxedUnit.UNIT;
        });
        Vector pi = Vectors$.MODULE$.dense(piArray);
        DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, thetaArray, true);
        DenseMatrix sigma = new DenseMatrix(numLabels, numFeatures, sigmaArray, true);
        return new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), sigma.compressed());
    }

    @Override
    public NaiveBayes copy(ParamMap extra) {
        return (NaiveBayes)this.defaultCopy(extra);
    }

    public static final /* synthetic */ int $anonfun$trainWithLabelCheck$2(double[] x$1) {
        return x$1.length;
    }

    public static final /* synthetic */ boolean $anonfun$trainWithLabelCheck$3(Vector vector) {
        boolean bl;
        Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(denseVector.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> v >= 0.0 && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(v)));
        } else if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(sparseVector.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> v >= 0.0 && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(v)));
        } else {
            throw new MatchError((Object)vector2);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$trainWithLabelCheck$6(Vector vector) {
        boolean bl;
        Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(denseVector.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> v == 0.0 || v == 1.0);
        } else if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            bl = ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(sparseVector.values()), (Function1)(JFunction1.mcZD.sp & Serializable)v -> v == 0.0 || v == 1.0);
        } else {
            throw new MatchError((Object)vector2);
        }
        return bl;
    }

    public static final /* synthetic */ double $anonfun$trainDiscreteImpl$1(Tuple4 x$3) {
        return BoxesRunTime.unboxToDouble((Object)x$3._1());
    }

    public static final /* synthetic */ long $anonfun$trainDiscreteImpl$2(Tuple4 x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4._4());
    }

    public static final /* synthetic */ double $anonfun$trainDiscreteImpl$3(Tuple4 x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5._2());
    }

    public static final /* synthetic */ void $anonfun$trainDiscreteImpl$4(Vector featureSum$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Vector sumTermFreqs = (Vector)tuple4._3();
        BLAS$.MODULE$.axpy(1.0, sumTermFreqs, featureSum$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$trainDiscreteImpl$6(NaiveBayes $this, double[] labelArray$1, IntRef i$1, double[] piArray$1, double lambda$1, double piLogDenom$1, int numFeatures$1, double[] thetaArray$1, Tuple4 x0$3) {
        Tuple4 tuple4 = x0$3;
        if (tuple4 != null) {
            double d;
            boolean bl;
            double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double n = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector sumTermFreqs = (Vector)tuple4._3();
            labelArray$1[i$1.elem] = label;
            piArray$1[i$1.elem] = scala.math.package$.MODULE$.log(n + lambda$1) - piLogDenom$1;
            String string = $this.$($this.modelType());
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Complement();
                String string5 = string;
                bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
            }
            if (bl) {
                d = scala.math.package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(sumTermFreqs.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + (double)numFeatures$1 * lambda$1);
            } else {
                String string6 = NaiveBayes$.MODULE$.Bernoulli();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    d = scala.math.package$.MODULE$.log(n + 2.0 * lambda$1);
                } else {
                    throw new MatchError((Object)string);
                }
            }
            double thetaLogDenom = d;
            int offset = i$1.elem * numFeatures$1;
            for (int j = 0; j < numFeatures$1; ++j) {
                thetaArray$1[offset + j] = scala.math.package$.MODULE$.log(sumTermFreqs.apply(j) + lambda$1) - thetaLogDenom;
            }
            ++i$1.elem;
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$trainGaussianImpl$3(Tuple4 x$7) {
        return BoxesRunTime.unboxToDouble((Object)x$7._1());
    }

    public static final /* synthetic */ double $anonfun$trainGaussianImpl$4(Tuple4 x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8._2());
    }

    public static final /* synthetic */ void $anonfun$trainGaussianImpl$6(DoubleRef globalSum$1, int j$1, DoubleRef globalSqrSum$1, Tuple4 x0$2) {
        Tuple4 tuple4 = x0$2;
        if (tuple4 != null) {
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector squareSum = (Vector)tuple4._4();
            globalSum$1.elem += mean.apply(j$1) * weightSum;
            globalSqrSum$1.elem += squareSum.apply(j$1);
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$trainGaussianImpl$7(double[] piArray$2, IntRef i$2, double logNumInstances$1, int numFeatures$2, double[] thetaArray$2, double[] sigmaArray$1, double epsilon$1, Tuple4 x0$3) {
        Tuple4 tuple4 = x0$3;
        if (tuple4 != null) {
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector squareSum = (Vector)tuple4._4();
            piArray$2[i$2.elem] = scala.math.package$.MODULE$.log(weightSum) - logNumInstances$1;
            int offset = i$2.elem * numFeatures$2;
            for (int j = 0; j < numFeatures$2; ++j) {
                double m;
                thetaArray$2[offset + j] = m = mean.apply(j);
                sigmaArray$1[offset + j] = epsilon$1 + squareSum.apply(j) / weightSum - m * m;
            }
            ++i$2.elem;
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public NaiveBayes(String uid) {
        this.uid = uid;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public NaiveBayes() {
        this(Identifiable$.MODULE$.randomUID("nb"));
    }
}

