/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.pythonconverters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.SparkException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class AvroConversionUtil$
implements Serializable {
    public static final AvroConversionUtil$ MODULE$ = new AvroConversionUtil$();

    public Object fromAvro(Object obj, Schema schema) {
        Object object;
        if (obj == null) {
            return null;
        }
        Schema.Type type = schema.getType();
        if (Schema.Type.UNION.equals(type)) {
            object = this.unpackUnion(obj, schema);
        } else if (Schema.Type.ARRAY.equals(type)) {
            object = this.unpackArray(obj, schema);
        } else if (Schema.Type.FIXED.equals(type)) {
            object = this.unpackFixed(obj, schema);
        } else if (Schema.Type.MAP.equals(type)) {
            object = this.unpackMap(obj, schema);
        } else if (Schema.Type.BYTES.equals(type)) {
            object = this.unpackBytes(obj);
        } else if (Schema.Type.RECORD.equals(type)) {
            object = this.unpackRecord(obj);
        } else if (Schema.Type.STRING.equals(type)) {
            object = obj.toString();
        } else if (Schema.Type.ENUM.equals(type)) {
            object = obj.toString();
        } else if (Schema.Type.NULL.equals(type)) {
            object = obj;
        } else if (Schema.Type.BOOLEAN.equals(type)) {
            object = obj;
        } else if (Schema.Type.DOUBLE.equals(type)) {
            object = obj;
        } else if (Schema.Type.FLOAT.equals(type)) {
            object = obj;
        } else if (Schema.Type.INT.equals(type)) {
            object = obj;
        } else if (Schema.Type.LONG.equals(type)) {
            object = obj;
        } else {
            throw new SparkException(new StringBuilder(25).append("Unknown Avro schema type ").append(type.getName()).toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> unpackRecord(Object obj) {
        void var3_2;
        HashMap map = new HashMap();
        Object object = obj;
        if (!(object instanceof IndexedRecord)) {
            throw new SparkException(new StringBuilder(24).append("Unsupported RECORD type ").append(object.getClass().getName()).toString());
        }
        IndexedRecord indexedRecord = (IndexedRecord)object;
        ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(indexedRecord.getSchema().getFields()).asScala()).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Schema.Field f = (Schema.Field)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Object object = map.put(f.name(), MODULE$.fromAvro(indexedRecord.get(i), f.schema()));
            return object;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return var3_2;
    }

    public java.util.Map<String, Object> unpackMap(Object obj, Schema schema) {
        return (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((Map)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)obj).asScala()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key.toString(), MODULE$.fromAvro(value, schema.getValueType()));
            return tuple22;
        })).asJava();
    }

    public byte[] unpackFixed(Object obj, Schema schema) {
        return this.unpackBytes(((GenericFixed)obj).bytes());
    }

    public byte[] unpackBytes(Object obj) {
        byte[] byArray;
        Object object = obj;
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] arr = new byte[byteBuffer.remaining()];
            byteBuffer.get(arr);
            byArray = arr;
        } else if (object instanceof byte[]) {
            byte[] byArray2;
            byArray = byArray2 = (byte[])object;
        } else {
            throw new SparkException(new StringBuilder(19).append("Unknown BYTES type ").append(object.getClass().getName()).toString());
        }
        byte[] bytes = byArray;
        byte[] bytearray = new byte[bytes.length];
        System.arraycopy(bytes, 0, bytearray, 0, bytes.length);
        return bytearray;
    }

    public Collection<Object> unpackArray(Object obj, Schema schema) {
        Object object;
        Collection collection;
        Object object2 = obj;
        if (object2 instanceof Collection) {
            Collection collection2 = (Collection)object2;
            collection = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection2).asScala()).map((Function1 & Serializable)x$1 -> MODULE$.fromAvro(x$1, schema.getElementType()))).toSeq()).asJava();
        } else if (ScalaRunTime$.MODULE$.isArray(object2, 1) && (object = object2).getClass().getComponentType().isPrimitive()) {
            collection = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(object))).asJava();
        } else if (ScalaRunTime$.MODULE$.isArray(object2, 1)) {
            Object object3 = object2;
            collection = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object3), (Function1 & Serializable)x$2 -> MODULE$.fromAvro(x$2, schema.getElementType()), ClassTag$.MODULE$.Any())))).asJava();
        } else {
            throw new SparkException(new StringBuilder(19).append("Unknown ARRAY type ").append(object2.getClass().getName()).toString());
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object unpackUnion(Object obj, Schema schema) {
        SeqOps seqOps;
        SeqOps seqOps2;
        List list = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getTypes()).asScala()).toList();
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) {
            Schema s = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            return this.fromAvro(obj, s);
        }
        if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Schema n = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Schema s = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            Schema.Type type = n.getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (type == null) {
                if (type2 == null) return this.fromAvro(obj, s);
            } else if (type.equals(type2)) {
                return this.fromAvro(obj, s);
            }
        }
        if (list == null) throw new SparkException("Unions may only consist of a concrete type and null");
        SeqOps seqOps3 = package$.MODULE$.List().unapplySeq((SeqOps)list);
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3)) throw new SparkException("Unions may only consist of a concrete type and null");
        if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) == null) throw new SparkException("Unions may only consist of a concrete type and null");
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) != 0) throw new SparkException("Unions may only consist of a concrete type and null");
        Schema s = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
        Schema n = (Schema)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
        Schema.Type type = n.getType();
        Schema.Type type3 = Schema.Type.NULL;
        if (type != null) {
            if (!type.equals(type3)) throw new SparkException("Unions may only consist of a concrete type and null");
            return this.fromAvro(obj, s);
        }
        if (type3 == null) return this.fromAvro(obj, s);
        throw new SparkException("Unions may only consist of a concrete type and null");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AvroConversionUtil$.class);
    }

    private AvroConversionUtil$() {
    }
}

