/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.Empty2Null;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Pmod;
import org.apache.spark.sql.catalyst.expressions.Pmod$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.optimizer.EliminateSorts$;
import org.apache.spark.sql.catalyst.optimizer.FoldablePropagation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.WriteFilesExec;
import org.apache.spark.sql.execution.datasources.WriterBucketSpec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class V1WritesUtils$ {
    public static final V1WritesUtils$ MODULE$ = new V1WritesUtils$();

    public Option<WriterBucketSpec> getWriterBucketSpec(Option<BucketSpec> bucketSpec, Seq<Attribute> dataColumns, Map<String, String> options) {
        return bucketSpec.map((Function1 & Serializable)spec -> {
            WriterBucketSpec writerBucketSpec;
            Seq bucketColumns = (Seq)spec.bucketColumnNames().map((Function1 & Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$getWriterBucketSpec$3(c, x$3))).get());
            Object object = options.getOrElse((Object)BucketingUtils$.MODULE$.optionForHiveCompatibleBucketWrite(), (Function0 & Serializable)() -> "false");
            String string = "true";
            if (!(object != null ? !object.equals(string) : string != null)) {
                BitwiseAnd hashId = new BitwiseAnd((Expression)new HiveHash(bucketColumns), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
                Pmod bucketIdExpression = new Pmod((Expression)hashId, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)spec.numBuckets())), Pmod$.MODULE$.apply$default$3());
                Function1 & Serializable fileNamePrefix = (Function1 & Serializable)bucketId -> V1WritesUtils$.$anonfun$getWriterBucketSpec$5(BoxesRunTime.unboxToInt((Object)bucketId));
                writerBucketSpec = new WriterBucketSpec((Expression)bucketIdExpression, (Function1<Object, String>)fileNamePrefix);
            } else {
                Expression bucketIdExpression = new HashPartitioning(bucketColumns, spec.numBuckets()).partitionIdExpression();
                writerBucketSpec = new WriterBucketSpec(bucketIdExpression, (Function1<Object, String>)(Function1 & Serializable)x$4 -> V1WritesUtils$.$anonfun$getWriterBucketSpec$6(BoxesRunTime.unboxToInt((Object)x$4)));
            }
            return writerBucketSpec;
        });
    }

    public Seq<Attribute> getBucketSortColumns(Option<BucketSpec> bucketSpec, Seq<Attribute> dataColumns) {
        return (Seq)Option$.MODULE$.option2Iterable(bucketSpec).toSeq().flatMap((Function1 & Serializable)spec -> (Seq)spec.sortColumnNames().map((Function1 & Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$getBucketSortColumns$3(c, x$5))).get()));
    }

    public Seq<SortOrder> getSortOrder(Seq<Attribute> outputColumns, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Map<String, String> options, int numStaticPartitionCols) {
        Predef$.MODULE$.require(partitionColumns.size() >= numStaticPartitionCols);
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq dataColumns = (Seq)outputColumns.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionSet.contains(elem)));
        Option<WriterBucketSpec> writerBucketSpec = this.getWriterBucketSpec(bucketSpec, (Seq<Attribute>)dataColumns, options);
        Seq<Attribute> sortColumns = this.getBucketSortColumns(bucketSpec, (Seq<Attribute>)dataColumns);
        Seq dynamicPartitionColumns = (Seq)partitionColumns.drop(numStaticPartitionCols);
        return SQLConf$.MODULE$.get().maxConcurrentOutputFileWriters() > 0 && sortColumns.isEmpty() ? (Seq)package$.MODULE$.Seq().empty() : (Seq)((IterableOps)((IterableOps)dynamicPartitionColumns.$plus$plus((IterableOnce)writerBucketSpec.map((Function1 & Serializable)x$6 -> x$6.bucketIdExpression()))).$plus$plus(sortColumns)).map((Function1 & Serializable)x$7 -> SortOrder$.MODULE$.apply(x$7, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()));
    }

    public int getSortOrder$default$5() {
        return 0;
    }

    public Seq<NamedExpression> convertEmptyToNull(Seq<Attribute> output, Seq<Attribute> partitionColumns) {
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        BooleanRef needConvert = BooleanRef.create((boolean)false);
        Seq projectList = (Seq)output.map((Function1 & Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (!partitionSet.contains((NamedExpression)attribute)) return attribute;
            DataType dataType = attribute.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType == null) {
                if (stringType$ != null) {
                    return attribute;
                }
            } else if (!dataType.equals(stringType$)) return attribute;
            if (!attribute.nullable()) return attribute;
            needConvert$1.elem = true;
            Empty2Null x$1 = new Empty2Null((Expression)attribute);
            String x$2 = attribute.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
            return new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
        });
        return needConvert.elem ? projectList : package$.MODULE$.Nil();
    }

    public boolean hasEmptyToNull(Seq<Expression> expressions) {
        return expressions.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$hasEmptyToNull$2(x$9)))));
    }

    public LogicalPlan eliminateFoldableOrdering(Seq<SortOrder> ordering2, LogicalPlan query) {
        return EliminateSorts$.MODULE$.apply(FoldablePropagation$.MODULE$.apply((LogicalPlan)new Sort(ordering2, false, query)));
    }

    public boolean isOrderingMatched(Seq<Expression> requiredOrdering, Seq<SortOrder> outputOrdering) {
        return requiredOrdering.length() > outputOrdering.length() ? false : ((IterableOnceOps)requiredOrdering.zip(outputOrdering)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$isOrderingMatched$1(x0$1)));
    }

    public Option<WriteFilesExec> getWriteFilesOpt(SparkPlan child) {
        return child.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof WriteFilesExec) {
                    WriteFilesExec writeFilesExec = (WriteFilesExec)A1;
                    object = writeFilesExec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof WriteFilesExec;
                return bl;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$getWriterBucketSpec$3(String c$1, Attribute x$3) {
        String string = x$3.name();
        String string2 = c$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$getWriterBucketSpec$5(int bucketId) {
        int arg$macro$1 = bucketId;
        return StringOps$.MODULE$.format$extension("%05d_0_", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
    }

    public static final /* synthetic */ String $anonfun$getWriterBucketSpec$6(int x$4) {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$getBucketSortColumns$3(String c$2, Attribute x$5) {
        String string = x$5.name();
        String string2 = c$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasEmptyToNull$2(Expression x$9) {
        return x$9 instanceof Empty2Null;
    }

    public static final /* synthetic */ boolean $anonfun$isOrderingMatched$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression requiredOrder = (Expression)tuple2._1();
        SortOrder outputOrder = (SortOrder)tuple2._2();
        boolean bl = outputOrder.satisfies(outputOrder.copy(requiredOrder, outputOrder.copy$default$2(), outputOrder.copy$default$3(), outputOrder.copy$default$4()));
        return bl;
    }

    private V1WritesUtils$() {
    }
}

