/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class DataLabel
extends LinkedHashMap<String, String> {
    public static final String GENERAL_LABEL_NAME = "_";
    public static final String PERCENTILE_LABEL_NAME = "p";

    public void put(String labels) {
        if (labels.startsWith("{") && labels.endsWith("}")) {
            String labelsStr = labels.substring(1, labels.length() - 1);
            if (StringUtil.isNotEmpty((String)labelsStr)) {
                String[] labelArr = labelsStr.split(",");
                this.put(labelArr);
            }
        } else {
            this.put(GENERAL_LABEL_NAME, labels);
        }
    }

    private void put(String[] labels) {
        for (String label : labels) {
            int i = label.indexOf("=");
            if (i <= 0) continue;
            String key = label.substring(0, i);
            String value = label.substring(i + 1);
            this.put(key, value);
        }
    }

    public String getLabelString(String key) {
        return key + "=" + (String)this.get(key);
    }

    @Override
    public String put(String key, String value) {
        return super.put(key, value);
    }

    @Override
    public String toString() {
        Iterator i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry e = i.next();
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',');
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataLabel)) {
            return false;
        }
        DataLabel other = (DataLabel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataLabel;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

