/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.data.BufferedData;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.StorageID;

public class MergableBufferedData<METRICS extends Metrics>
implements BufferedData<METRICS> {
    private Map<StorageID, METRICS> buffer = new HashMap<StorageID, METRICS>();

    @Override
    public void accept(METRICS data) {
        StorageID id = ((Metrics)data).id();
        Metrics existed = (Metrics)this.buffer.get(id);
        if (existed == null) {
            this.buffer.put(id, data);
        } else {
            existed.combine((Metrics)data);
        }
    }

    @Override
    public List<METRICS> read() {
        try {
            List list = this.buffer.values().stream().collect(Collectors.toList());
            return list;
        }
        finally {
            this.buffer.clear();
        }
    }
}

