/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.gridded;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.gridded.GridLoader;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.system.DataDirectory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.FactoryException;

public final class GridFile {
    private static final AtomicBoolean datumDirectoryLogged = new AtomicBoolean();
    private final DataDirectory localDirectory;
    public final URI parameter;
    private URI resolved;
    private URI base;
    private Path asPath;

    public GridFile(URI resolved) {
        this.parameter = resolved;
        this.resolved = resolved;
        this.localDirectory = DataDirectory.DATUM_CHANGES;
    }

    public GridFile(Parameters group, ParameterDescriptor<URI> param) throws MissingFactoryResourceException {
        this(group, param, DataDirectory.DATUM_CHANGES);
    }

    public GridFile(Parameters group, ParameterDescriptor<URI> param, DataDirectory localDirectory) throws MissingFactoryResourceException {
        RuntimeException error = null;
        this.localDirectory = localDirectory;
        this.parameter = group.getMandatoryValue(param);
        if (this.parameter.isAbsolute()) {
            this.resolved = this.parameter.normalize();
        } else {
            URI document;
            if (localDirectory != null) {
                this.base = localDirectory.getDirectoryAsURI();
                if (this.base != null) {
                    try {
                        this.resolved = this.base.resolve(this.parameter).normalize();
                        this.asPath = Path.of(this.resolved);
                        if (Files.exists(this.asPath, new LinkOption[0])) {
                            return;
                        }
                    }
                    catch (IllegalArgumentException | FileSystemNotFoundException e) {
                        error = e;
                    }
                }
            }
            if ((document = (URI)group.getSourceFile(param).orElse(null)) == null) {
                String env;
                if (this.resolved != null) {
                    return;
                }
                String message = this.parameter.isOpaque() ? Errors.format((short)14, (Object)this.parameter) : ((env = DataDirectory.getenv()) == null ? Messages.format((short)16, (Object)"SIS_DATA") : Messages.format((short)13, (Object)"SIS_DATA", (Object)env));
                throw new MissingFactoryResourceException(message, error);
            }
            this.base = document;
            this.resolved = document.resolve(this.parameter).normalize();
        }
        try {
            this.asPath = Path.of(this.resolved);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e) {
            if (error == null) {
                error = e;
            } else {
                error.addSuppressed(e);
            }
            this.asPath = null;
        }
        if (error != null) {
            Logging.ignorableException((Logger)AbstractProvider.LOGGER, GridFile.class, (String)"<init>", (Throwable)error);
        }
    }

    public URI resolved() {
        return this.resolved;
    }

    public Optional<Path> path() {
        return Optional.ofNullable(this.asPath);
    }

    public ReadableByteChannel newByteChannel() throws IOException {
        if (this.asPath != null) {
            return Files.newByteChannel(this.asPath, new OpenOption[0]);
        }
        return Channels.newChannel(this.resolved.toURL().openStream());
    }

    public BufferedReader newBufferedReader() throws IOException {
        if (this.asPath != null) {
            return Files.newBufferedReader(this.asPath);
        }
        return new BufferedReader(new InputStreamReader(this.resolved.toURL().openStream()));
    }

    public void startLoading(Class<?> caller) {
        GridFile.startLoading(caller, this.parameter);
    }

    public static void startLoading(Class<?> caller, Object file) {
        GridLoader.log(caller, Resources.forLocale(null).createLogRecord(Level.FINE, (short)32, file));
    }

    public FactoryException canNotLoad(Class<?> caller, String format, Exception cause) {
        Path directory;
        if (this.localDirectory != null && !datumDirectoryLogged.get() && (directory = this.localDirectory.getDirectory()) != null && !datumDirectoryLogged.getAndSet(true)) {
            GridLoader.log(caller, Resources.forLocale(null).createLogRecord(Level.INFO, (short)92, directory));
        }
        boolean notFound = cause instanceof NoSuchFileException || cause instanceof FileNotFoundException;
        String message = Resources.format(notFound ? (short)90 : 91, format, this.parameter);
        if (notFound) {
            return new MissingFactoryResourceException(message, cause);
        }
        return new FactoryDataException(message, cause);
    }

    public String toString() {
        return String.valueOf(this.resolved);
    }
}

