/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class TransformJoiner {
    private static final double IDENTITY_TOLERANCE = 1.0E-16;
    private final List<MathTransform> steps;
    private int replaceIndex;
    public final MathTransformFactory factory;
    private final ConcatenatedTransform[] pool;
    MathTransform replacement;

    TransformJoiner(List<MathTransform> steps, MathTransformFactory factory, List<ConcatenatedTransform> pool) {
        this.steps = steps;
        this.factory = factory;
        this.pool = (ConcatenatedTransform[])pool.toArray(ConcatenatedTransform[]::new);
    }

    final void reset(int i) {
        this.replaceIndex = i;
        this.replacement = null;
    }

    public Optional<MathTransform> getTransform(int relativeIndex) {
        block6: {
            int i = this.replaceIndex + relativeIndex;
            if (i >= 0 && i < this.steps.size()) {
                int direction = Integer.signum(relativeIndex);
                int j = this.replaceIndex;
                while ((j += direction) != i) {
                    if (!(this.steps.get(j) instanceof ConcatenatedTransform)) continue;
                    break block6;
                }
                MathTransform step = this.steps.get(i);
                switch (direction) {
                    case -1: {
                        step = MathTransforms.getLastStep(step);
                        break;
                    }
                    case 1: {
                        step = MathTransforms.getFirstStep(step);
                    }
                }
                return Optional.of(step);
            }
        }
        return Optional.empty();
    }

    final Matrix getMatrix(int relativeIndex) {
        return MathTransforms.getMatrix(this.getTransform(relativeIndex).orElse(null));
    }

    final boolean removeUnusedDimensions(int relativeIndex, int lower, int upper, IntFunction<MathTransform> reduce) throws FactoryException {
        MathTransform reduced;
        int dimension;
        Matrix matrix = this.getMatrix(relativeIndex);
        if (matrix == null || relativeIndex == 0) {
            return false;
        }
        boolean before = relativeIndex < 0;
        for (dimension = lower; dimension < upper; ++dimension) {
            if (before) {
                int i = matrix.getNumCol();
                while (--i >= 0) {
                    if (matrix.getElement(dimension, i) == 0.0) continue;
                    return false;
                }
                continue;
            }
            int j = matrix.getNumRow();
            while (--j >= 0) {
                if (matrix.getElement(j, dimension) == 0.0) continue;
                return false;
            }
        }
        dimension = (before ? matrix.getNumRow() : matrix.getNumCol()) - (upper - lower) - 1;
        try {
            reduced = reduce.apply(dimension);
        }
        catch (BackingStoreException e) {
            throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
        }
        if (reduced == null) {
            return false;
        }
        MatrixSIS m = MatrixSIS.castOrCopy(matrix);
        m = before ? m.removeRows(lower, upper) : m.removeColumns(lower, upper);
        MathTransform linear = this.factory.createAffineTransform((Matrix)m);
        return this.replace(relativeIndex, this.concatenate(before ? linear : reduced, before ? reduced : linear));
    }

    public boolean replace(int firstOrLast, MathTransform concatenation) throws FactoryException {
        return this.replace(Math.min(firstOrLast, 0), Math.max(firstOrLast, 0), concatenation);
    }

    public boolean replace(int from, int to, MathTransform concatenation) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"concatenation", (Object)concatenation);
        if (from > 0 || to < 0) {
            throw new IllegalArgumentException(Errors.format((short)76, (Object)from, (Object)to));
        }
        if (this.replacement == null) {
            int count = this.steps.size();
            if ((from += this.replaceIndex) >= 0 && (to += this.replaceIndex) < count) {
                int i = from;
                while (++i < to) {
                    if (i == this.replaceIndex || !(this.steps.get(i) instanceof ConcatenatedTransform)) continue;
                    return false;
                }
                if (from < this.replaceIndex) {
                    concatenation = this.replaceStep(this.steps.get(from), concatenation, 1);
                }
                if (to > this.replaceIndex) {
                    concatenation = this.replaceStep(this.steps.get(to), concatenation, 0);
                }
                while (--from >= 0) {
                    concatenation = this.concatenate(this.steps.get(from), concatenation);
                }
                while (++to < count) {
                    concatenation = this.concatenate(concatenation, this.steps.get(to));
                }
                this.replacement = concatenation;
                return true;
            }
        }
        return false;
    }

    private MathTransform replaceStep(MathTransform step, MathTransform concatenation, int firstOrLast) throws FactoryException {
        if (step instanceof ConcatenatedTransform) {
            ConcatenatedTransform c = (ConcatenatedTransform)step;
            MathTransform[] tr = new MathTransform[]{c.transform1, c.transform2};
            tr[firstOrLast] = this.replaceStep(tr[firstOrLast], concatenation, firstOrLast);
            concatenation = this.concatenate(tr[0], tr[1]);
        }
        return concatenation;
    }

    public boolean replaceRoundtrip(int middle, UnaryOperator<MathTransform> mapper) throws FactoryException {
        MathTransform concatenation;
        int indexOfInverse;
        MathTransform inverse;
        if (Math.abs(middle) == 1 && (inverse = (MathTransform)this.getTransform(indexOfInverse = middle * 2).orElse(null)) != null && TransformJoiner.isInverseEquals(this.steps.get(this.replaceIndex), inverse) && (concatenation = (MathTransform)mapper.apply(this.getTransform(middle).get())) != null) {
            return this.replace(indexOfInverse, concatenation);
        }
        return false;
    }

    public boolean replacePassThrough(Map<Integer, Integer> dimensions) throws FactoryException {
        Matrix after;
        Matrix before = this.getMatrix(-1);
        if (!TransformJoiner.isAffine(before) || !TransformJoiner.isAffine(after = this.getMatrix(1))) {
            return false;
        }
        LinkedHashMap<Integer, Integer> sourceToTarget = new LinkedHashMap<Integer, Integer>(dimensions);
        LinkedHashMap<Integer, Integer> targetToSource = new LinkedHashMap<Integer, Integer>();
        MathTransform tr = this.steps.get(this.replaceIndex);
        sourceToTarget.put(tr.getSourceDimensions(), tr.getTargetDimensions());
        Iterator<Map.Entry<Integer, Integer>> it = sourceToTarget.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> entry = it.next();
            Integer source = entry.getKey();
            Integer target = entry.getValue();
            if (targetToSource.put(target, source) != null) {
                throw new IllegalArgumentException(Errors.format((short)40, (Object)target));
            }
            if (source < before.getNumCol()) continue;
            it.remove();
        }
        int typeIfSimplifyBefore = TransformJoiner.removeInvalidPassThrough(sourceToTarget, before, true);
        int typeIfSimplifyAfter = TransformJoiner.removeInvalidPassThrough(targetToSource, after, false);
        int typeOfSimplestMatrix = Math.min(typeIfSimplifyBefore >>> 16, typeIfSimplifyAfter >>> 16);
        if (Math.min(typeIfSimplifyBefore &= Short.MAX_VALUE, typeIfSimplifyAfter &= Short.MAX_VALUE) >= typeOfSimplestMatrix) {
            return false;
        }
        boolean moveFromBeforeToAfter = typeIfSimplifyBefore != typeIfSimplifyAfter ? typeIfSimplifyBefore < typeIfSimplifyAfter : after.getNumRow() * after.getNumCol() < before.getNumRow() * before.getNumCol();
        Map<Integer, Integer> map = dimensions = moveFromBeforeToAfter ? sourceToTarget : targetToSource;
        if (dimensions.isEmpty()) {
            return false;
        }
        MatrixSIS simplified = Matrices.copy(moveFromBeforeToAfter ? before : after);
        int dim = moveFromBeforeToAfter ? after.getNumCol() : before.getNumRow();
        MatrixSIS moved = Matrices.create(dim, dim, ExtendedPrecisionMatrix.CREATE_IDENTITY);
        for (Map.Entry<Integer, Integer> entry : dimensions.entrySet()) {
            int srcRow = entry.getKey();
            int tgtRow = entry.getValue();
            moved.setElement(tgtRow, tgtRow, 0.0);
            if (!moveFromBeforeToAfter && srcRow >= simplified.getNumRow()) continue;
            dimensions.forEach((srcCol, tgtCol) -> moved.setNumber(tgtRow, (int)tgtCol, simplified.getElement(srcRow, (int)srcCol)));
            int i = simplified.getNumCol();
            while (--i >= 0) {
                simplified.setElement(srcRow, i, i == srcRow ? 1.0 : 0.0);
            }
        }
        if (moveFromBeforeToAfter) {
            before = simplified;
            after = Matrices.multiply(after, moved);
        } else {
            after = simplified;
            before = Matrices.multiply(moved, before);
        }
        return this.replace(-1, 1, this.concatenate(this.factory.createAffineTransform(before), this.concatenate(tr, this.factory.createAffineTransform(after))));
    }

    private static int removeInvalidPassThrough(Map<Integer, Integer> dimensions, Matrix matrix, boolean moveFromBeforeToAfter) {
        boolean again;
        do {
            again = false;
            Iterator<Integer> it = dimensions.keySet().iterator();
            block1: while (it.hasNext()) {
                int srcRow = it.next();
                if (!moveFromBeforeToAfter && srcRow >= matrix.getNumRow()) continue;
                int srcCol = matrix.getNumCol();
                while (--srcCol >= 0) {
                    double value = matrix.getElement(srcRow, srcCol);
                    if (value == 0.0 || Double.isNaN(value) || dimensions.containsKey(srcCol)) continue;
                    it.remove();
                    again = true;
                    continue block1;
                }
            }
        } while (again);
        int typeOfOriginalMatrix = 0;
        int typeOfSimplifiedMatrix = 0;
        int translationColumn = matrix.getNumCol() - 1;
        int j = matrix.getNumRow();
        while (--j >= 0) {
            for (int i = translationColumn; i >= 0; --i) {
                double element = matrix.getElement(j, i);
                if (element == (double)(i == j ? 1 : 0)) continue;
                int type = i == translationColumn ? 2 : (element == 0.0 || element == 1.0 ? 1 : (i == j ? 4 : 5));
                typeOfOriginalMatrix |= type;
                if (dimensions.containsKey(j)) continue;
                typeOfSimplifiedMatrix |= type;
            }
        }
        return typeOfOriginalMatrix << 16 | typeOfSimplifiedMatrix;
    }

    final MathTransform concatenate(MathTransform tr1, MathTransform tr2) throws FactoryException {
        for (ConcatenatedTransform tr : this.pool) {
            if (tr.transform1 != tr1 || tr.transform2 != tr2) continue;
            return tr;
        }
        return this.factory.createConcatenatedTransform(tr1, tr2);
    }

    final void reassemble() {
        boolean again;
        do {
            again = false;
            MathTransform tr2 = null;
            int i = this.steps.size();
            while (--i >= 0) {
                MathTransform tr1 = this.steps.get(i);
                for (ConcatenatedTransform tr : this.pool) {
                    if (tr.transform1 != tr1 || tr.transform2 != tr2) continue;
                    this.steps.remove(i + 1);
                    this.steps.set(i, tr);
                    tr1 = tr;
                    again = true;
                    break;
                }
                tr2 = tr1;
            }
        } while (again);
    }

    final boolean simplify() throws FactoryException {
        boolean again;
        boolean changed = false;
        do {
            MathTransform tr2;
            MathTransform tr1;
            again = false;
            this.steps.removeIf(MathTransform::isIdentity);
            int i = this.steps.size() - 1;
            while (--i >= 0) {
                tr1 = this.steps.get(i);
                if (!TransformJoiner.isInverseEquals(tr1, tr2 = this.steps.get(i + 1)) && !TransformJoiner.isInverseEquals(tr2, tr1)) continue;
                assert (tr1.getSourceDimensions() == tr2.getTargetDimensions());
                assert (tr1.getTargetDimensions() == tr2.getSourceDimensions());
                this.steps.subList(i, i + 2).clear();
                again = true;
                --i;
            }
            i = this.steps.size() - 1;
            while (--i >= 0) {
                tr1 = this.steps.get(i);
                MathTransform concatenated = this.multiply(tr1, tr2 = this.steps.get(i + 1));
                if (concatenated == null) continue;
                if (concatenated instanceof AbstractLinearTransform) {
                    AbstractLinearTransform impl = (AbstractLinearTransform)concatenated;
                    if (impl.inverse == null) {
                        try {
                            MathTransform inverse = this.multiply(tr2.inverse(), tr1.inverse());
                            if (inverse instanceof LinearTransform) {
                                impl.inverse = (LinearTransform)inverse;
                            }
                        }
                        catch (NoninvertibleTransformException e) {
                            TransformJoiner.recoverableException(e);
                        }
                    }
                }
                this.steps.set(i, concatenated);
                this.steps.remove(i + 1);
                again = true;
            }
            changed |= again;
        } while (again);
        return changed;
    }

    private MathTransform multiply(MathTransform tr1, MathTransform tr2) throws FactoryException {
        Matrix matrix2;
        Matrix matrix1 = MathTransforms.getMatrix(tr1);
        if (matrix1 != null && (matrix2 = MathTransforms.getMatrix(tr2)) != null) {
            MatrixSIS matrix = Matrices.multiply(matrix2, matrix1);
            if (Matrices.isIdentity(matrix, 1.0E-16)) {
                return MathTransforms.identity(matrix.getNumRow() - 1);
            }
            return this.factory.createAffineTransform((Matrix)matrix);
        }
        return null;
    }

    private static boolean isAffine(Matrix matrix) {
        if (matrix == null) {
            return false;
        }
        double e = 1.0;
        int j = matrix.getNumRow() - 1;
        int i = matrix.getNumCol();
        while (--i >= 0) {
            if (matrix.getElement(j, i) != e) {
                return false;
            }
            e = 0.0;
        }
        return true;
    }

    private static boolean isInverseEquals(MathTransform tr1, MathTransform tr2) {
        if (tr1.getSourceDimensions() != tr2.getTargetDimensions() || tr1.getTargetDimensions() != tr2.getSourceDimensions()) {
            return false;
        }
        if (MathTransforms.isLinear(tr1) != MathTransforms.isLinear(tr2)) {
            return false;
        }
        try {
            tr1 = tr1.inverse();
        }
        catch (NoninvertibleTransformException e) {
            TransformJoiner.recoverableException(e);
            return false;
        }
        if (tr1 == tr2) {
            return true;
        }
        if (tr1 instanceof LenientComparable) {
            return ((LenientComparable)tr1).equals((Object)tr2, ComparisonMode.APPROXIMATE);
        }
        if (tr2 instanceof LenientComparable) {
            return ((LenientComparable)tr2).equals((Object)tr1, ComparisonMode.APPROXIMATE);
        }
        return tr1.equals((Object)tr2);
    }

    private static void recoverableException(NoninvertibleTransformException e) {
        Logging.recoverableException((Logger)AbstractMathTransform.LOGGER, TransformJoiner.class, (String)"simplify", (Throwable)e);
    }
}

