/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind;

import java.net.URI;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.MarshallerPool;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.bind.ScopedIdentifier;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.internal.shared.ExternalLinkHandler;
import org.apache.sis.xml.internal.shared.LegacyNamespaces;

public final class Context
extends MarshalContext {
    public static final int MARSHALLING = 1;
    public static final int SUBSTITUTE_LANGUAGE = 2;
    public static final int SUBSTITUTE_COUNTRY = 4;
    public static final int SUBSTITUTE_FILENAME = 8;
    public static final int SUBSTITUTE_MIMETYPE = 16;
    public static final int LEGACY_METADATA = 32;
    public static final int LENIENT_UNMARSHAL = 64;
    private static final int CLEAR_SEMAPHORE = 128;
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    public static final Object INVALID_OBJECT = Void.TYPE;
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.xml");
    private final MarshallerPool pool;
    final int bitMasks;
    private final Locale locale;
    private final ZoneId timezone;
    private final Map<String, String> schemas;
    private final Version versionGML;
    private final ExternalLinkHandler linkHandler;
    private final ReferenceResolver resolver;
    private final ValueConverter converter;
    private final Map<String, Object> xmlidToObject;
    private final Map<Object, String> objectToXmlid;
    private final Map<Object, Map<String, Object>> documentToXmlids;
    final Map<ScopedIdentifier<?>, Object> identifiedObjects;
    private final Filter logFilter;
    private PropertyType<?, ?> wrapper;
    private final Context previous;

    public Context(int bitMasks, MarshallerPool pool, Locale locale, ZoneId timezone, Map<String, String> schemas, Version versionGML, Version versionMetadata, ExternalLinkHandler linkHandler, ReferenceResolver resolver, ValueConverter converter, Filter logFilter) {
        if (versionMetadata != null && versionMetadata.compareTo(LegacyNamespaces.VERSION_2014) < 0) {
            bitMasks |= 0x20;
        }
        this.pool = pool;
        this.locale = locale;
        this.timezone = timezone;
        this.schemas = schemas;
        this.versionGML = versionGML;
        this.linkHandler = linkHandler;
        this.resolver = resolver;
        this.converter = converter;
        this.logFilter = logFilter;
        this.xmlidToObject = new HashMap<String, Object>();
        this.objectToXmlid = new IdentityHashMap<Object, String>();
        this.documentToXmlids = new HashMap<Object, Map<String, Object>>();
        this.identifiedObjects = new HashMap();
        this.previous = CURRENT.get();
        if ((bitMasks & 1) != 0 && !Semaphores.queryAndSet((int)1)) {
            bitMasks |= 0x80;
        }
        this.bitMasks = bitMasks;
        CURRENT.set(this);
    }

    private Context(Context parent, Locale locale, ExternalLinkHandler linkHandler, boolean inline) {
        assert (parent == CURRENT.get());
        this.previous = parent;
        this.locale = locale;
        this.linkHandler = linkHandler;
        this.pool = parent.pool;
        this.timezone = parent.timezone;
        this.schemas = parent.schemas;
        this.versionGML = parent.versionGML;
        this.resolver = parent.resolver;
        this.converter = parent.converter;
        this.logFilter = parent.logFilter;
        this.bitMasks = parent.bitMasks & 0xFFFFFF7F;
        if (inline) {
            this.xmlidToObject = parent.xmlidToObject;
            this.objectToXmlid = parent.objectToXmlid;
        } else {
            this.xmlidToObject = new HashMap<String, Object>();
            this.objectToXmlid = new IdentityHashMap<Object, String>();
        }
        this.documentToXmlids = parent.documentToXmlids;
        this.identifiedObjects = parent.identifiedObjects;
    }

    @Override
    public final MarshallerPool getPool() {
        return this.pool;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    public final ZoneId getZoneId() {
        return this.timezone;
    }

    @Override
    public final Version getVersion(String prefix) {
        switch (prefix) {
            case "gml": {
                return this.versionGML;
            }
            case "gmd": {
                if ((this.bitMasks & 1) == 0) break;
                return (this.bitMasks & 0x20) == 0 ? LegacyNamespaces.VERSION_2016 : LegacyNamespaces.VERSION_2007;
            }
        }
        return null;
    }

    @Override
    public final Optional<URI> getDocumentURI() {
        return this.linkHandler != null ? Optional.ofNullable(this.linkHandler.getURI()) : Optional.empty();
    }

    public static Context current() {
        return CURRENT.get();
    }

    public final Context createChild(Object systemId, ExternalLinkHandler linkHandler) {
        Context context = new Context(this, this.locale, linkHandler, false);
        this.documentToXmlids.put(systemId, context.xmlidToObject);
        CURRENT.set(context);
        return context;
    }

    public static void push(Locale locale) {
        Context current = Context.current();
        if (current != null) {
            if (locale == null) {
                locale = current.locale;
            }
            CURRENT.set(new Context(current, locale, current.linkHandler, true));
        }
    }

    public static void pull() {
        Context c = Context.current();
        if (c != null) {
            c = c.previous;
            if (c != null) {
                CURRENT.set(c);
            } else {
                CURRENT.remove();
            }
        }
    }

    public static boolean isFlagSet(Context context, int flag) {
        return context != null && (context.bitMasks & flag) != 0;
    }

    public static boolean isGMLVersion(Context context, Version version) {
        Version versionGML;
        if (context != null && (versionGML = context.versionGML) != null) {
            return versionGML.compareTo(version) >= 0;
        }
        return true;
    }

    public static StringBuilder schema(Context context, String key, String defaultSchema) {
        String schema;
        Map<String, String> schemas;
        StringBuilder buffer = new StringBuilder(128);
        if (context != null && (schemas = context.schemas) != null && (schema = schemas.get(key)) != null) {
            defaultSchema = schema;
        }
        buffer.append(defaultSchema);
        int length = buffer.length();
        if (length != 0 && buffer.charAt(length - 1) != '/') {
            buffer.append('/');
        }
        return buffer;
    }

    public static PropertyType<?, ?> getWrapper(Context context) {
        return context != null ? context.wrapper : null;
    }

    public static void setWrapper(Context context, PropertyType<?, ?> wrapper) {
        if (context != null) {
            context.wrapper = wrapper;
        }
    }

    public static String getObjectID(Context context, Object object) {
        return context != null ? context.objectToXmlid.get(object) : null;
    }

    public static Object getObjectForID(Context context, String id) {
        return context != null ? context.xmlidToObject.get(id) : null;
    }

    public static boolean setObjectForID(Context context, Object object, String id) {
        if (context != null) {
            Object existing = context.xmlidToObject.putIfAbsent(id, object);
            if (existing != null) {
                return existing == object;
            }
            if (context.objectToXmlid.put(object, id) != null) {
                throw new CorruptedObjectException(id);
            }
        }
        return true;
    }

    public final Object getExternalObjectForID(Object systemId, String fragment) {
        Map<String, Object> cache = this.documentToXmlids.get(systemId);
        if (cache == null) {
            return null;
        }
        Object value = cache.get(fragment);
        if (value == null && cache.get(null) == INVALID_OBJECT) {
            return INVALID_OBJECT;
        }
        return value;
    }

    public final void cacheDocument(Object systemId, Object document) {
        Map<String, Object> cache = this.documentToXmlids.get(systemId);
        if (cache == null || cache.isEmpty()) {
            this.documentToXmlids.put(systemId, Collections.singletonMap(null, document));
        } else {
            cache.put(null, document);
        }
    }

    public static ExternalLinkHandler linkHandler(Context context) {
        ExternalLinkHandler linkHandler;
        if (context != null && (linkHandler = context.linkHandler) != null) {
            return linkHandler;
        }
        return ExternalLinkHandler.DEFAULT;
    }

    public static ReferenceResolver resolver(Context context) {
        ReferenceResolver resolver;
        if (context != null && (resolver = context.resolver) != null) {
            return resolver;
        }
        return ReferenceResolver.DEFAULT;
    }

    public static ValueConverter converter(Context context) {
        ValueConverter converter;
        if (context != null && (converter = context.converter) != null) {
            return converter;
        }
        return ValueConverter.DEFAULT;
    }

    public static void warningOccured(Context context, Level level, Class<?> classe, String method, Throwable exception, Class<? extends IndexedResourceBundle> resources, short key, Object ... arguments) {
        Filter logFilter;
        LogRecord record;
        Locale locale;
        Locale locale2 = locale = context != null ? context.locale : null;
        if (resources != null) {
            Errors bundle;
            if (resources == Errors.class) {
                bundle = Errors.forLocale((Locale)locale);
            } else if (resources == Messages.class) {
                bundle = Messages.forLocale((Locale)locale);
            } else {
                throw new IllegalArgumentException(String.valueOf(resources));
            }
            record = bundle.createLogRecord(level, key, (Object)arguments);
        } else {
            record = new LogRecord(level, Exceptions.formatChainedMessages((Locale)locale, null, (Throwable)exception));
        }
        record.setSourceClassName(classe.getCanonicalName());
        record.setSourceMethodName(method);
        record.setLoggerName("org.apache.sis.xml");
        if (context != null && (logFilter = context.logFilter) != null) {
            record.setThrown(exception);
            if (!logFilter.isLoggable(record)) {
                return;
            }
            record.setThrown(null);
        }
        LOGGER.log(record);
    }

    public static void warningOccured(Context context, Class<?> classe, String method, Class<? extends IndexedResourceBundle> resources, short key, Object ... arguments) {
        Context.warningOccured(context, Level.WARNING, classe, method, null, resources, key, arguments);
    }

    public static void warningOccured(Context context, Class<?> classe, String method, Exception cause, boolean isWarning) {
        Context.warningOccured(context, isWarning ? Level.WARNING : Level.FINE, classe, method, cause, null, (short)0, (Object[])null);
    }

    public final void finish() {
        if ((this.bitMasks & 0x80) != 0) {
            Semaphores.clear((int)1);
        }
        if (this.previous != null) {
            CURRENT.set(this.previous);
        } else {
            CURRENT.remove();
        }
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"operation", (this.bitMasks & 1) != 0 ? "marshal" : "unmarshal", "locale", this.locale, "timezone", this.timezone, null, (this.bitMasks & 0x40) != 0 ? "lenient" : null});
    }
}

