/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.nio.Buffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.StringJoiner;
import java.util.function.IntSupplier;
import java.util.logging.Logger;
import org.apache.sis.math.ArrayVector;
import org.apache.sis.math.ConcatenatedVector;
import org.apache.sis.math.LinearlyDerivedVector;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.PackedVector;
import org.apache.sis.math.RepeatedVector;
import org.apache.sis.math.SequenceVector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class Vector
extends AbstractList<Number>
implements RandomAccess {
    static final int PRIME = 31;

    public static Vector create(Object array, boolean isUnsigned) throws IllegalArgumentException {
        Buffer buffer;
        if (array == null) {
            return null;
        }
        if (array.getClass().isArray()) {
            return ArrayVector.newInstance(array, isUnsigned);
        }
        if (array instanceof Vector) {
            return (Vector)array;
        }
        if (array instanceof Buffer && (buffer = (Buffer)array).hasArray()) {
            int offset = buffer.arrayOffset();
            return ArrayVector.newInstance(buffer.array(), isUnsigned).subList(offset + buffer.position(), offset + buffer.limit());
        }
        throw new IllegalArgumentException(Errors.format((short)57, "array", array.getClass()));
    }

    public static Vector create(double[] array) {
        return array != null ? new ArrayVector.Doubles(array) : null;
    }

    public static Vector createForDecimal(float[] array) {
        return array != null ? new ArrayVector.Decimal(array) : null;
    }

    public static Vector createSequence(Number first, Number increment, int length) {
        Class<? extends Number> type = Numbers.widestClass(first, increment);
        type = Numbers.widestClass(type, Numbers.narrowestClass(first.doubleValue() + increment.doubleValue() * (double)(length - 1)));
        return Vector.createSequence(type, first, increment, length);
    }

    static Vector createSequence(Class<? extends Number> type, Number first, Number increment, int length) {
        byte t = Numbers.getEnumConstant(type);
        if (t >= 3 && t <= 6) {
            return new SequenceVector.Longs(type, first, increment, length);
        }
        if (t == 8) {
            return new SequenceVector.Floats(type, first, increment, length);
        }
        return new SequenceVector.Doubles(type, first, increment, length);
    }

    protected Vector() {
    }

    public abstract Class<? extends Number> getElementType();

    public boolean isSinglePrecision() {
        byte type = Numbers.getEnumConstant(this.getElementType());
        return type == 8 || type >= 3 && type <= 4;
    }

    private int getBitCount() {
        try {
            return Numbers.primitiveBitCount(this.getElementType());
        }
        catch (IllegalArgumentException e) {
            return 32;
        }
    }

    public boolean isInteger() {
        if (!Numbers.isInteger(this.getElementType())) {
            int i = this.size();
            while (--i >= 0) {
                if (Numerics.isInteger(this.doubleValue(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnsigned() {
        return false;
    }

    @Override
    public abstract int size();

    public boolean isEmptyOrNaN() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.isNaN(i)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isNaN(int var1);

    public abstract double doubleValue(int var1);

    public float floatValue(int index) {
        return (float)this.doubleValue(index);
    }

    public long longValue(int index) {
        double value = this.doubleValue(index);
        long result = Math.round(value);
        if (Math.abs((double)result - value) <= 0.5) {
            return result;
        }
        throw this.canNotConvert(index, Long.TYPE);
    }

    public int intValue(int index) {
        long value = this.longValue(index);
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw this.canNotConvert(index, Integer.TYPE);
    }

    public short shortValue(int index) {
        long value = this.longValue(index);
        if (value >= -32768L && value <= 32767L) {
            return (short)value;
        }
        throw this.canNotConvert(index, Short.TYPE);
    }

    public byte byteValue(int index) {
        long value = this.longValue(index);
        if (value >= -128L && value <= 127L) {
            return (byte)value;
        }
        throw this.canNotConvert(index, Byte.TYPE);
    }

    private ArithmeticException canNotConvert(int index, Class<?> target) {
        return new ArithmeticException(Errors.format((short)12, this.stringValue(index), target));
    }

    public abstract String stringValue(int var1);

    @Override
    public abstract Number get(int var1);

    @Override
    public abstract Number set(int var1, Number var2);

    public void fill(int fromIndex, int toIndex, Number value) {
        Objects.checkFromToIndex(fromIndex, toIndex, this.size());
        while (fromIndex < toIndex) {
            this.set(fromIndex++, value);
        }
    }

    int indexOf(int toSearch, int index, boolean equality) {
        Number first = this.get(toSearch);
        int size = this.size();
        while (index < size && first.equals(this.get(index)) != equality) {
            ++index;
        }
        return index;
    }

    public int[] repetitions(int ... candidates) {
        int size;
        if (candidates != null && candidates.length == 0) {
            candidates = null;
        }
        if ((size = this.size()) >= 2) {
            int r0 = 0;
            for (int i = 0; i < size - 1; i += r0) {
                int p = r0;
                r0 = this.indexOf(i, i + 1, false) - i;
                if (r0 > 1 && p % r0 == 0) continue;
                r0 = 1;
                break;
            }
            int candidateIndex = 0;
            int skip = r0 == 1 ? this.indexOf(0, 1, false) : 0;
            int r = 0;
            block1: while (true) {
                int base;
                if (candidates != null) {
                    int n;
                    do {
                        if (candidateIndex >= candidates.length) {
                            r = size;
                            break block1;
                        }
                        n = candidates[candidateIndex++];
                        ArgumentChecks.ensureStrictlyPositive("candidates", n);
                    } while ((r = Math.multiplyExact(r0, n)) <= 0 || r >= size);
                } else {
                    r += r0;
                    if (skip != 0) {
                        r = this.indexOf(0, r, true);
                        if (skip != 1) {
                            if (r + skip >= size) break;
                            int end = this.indexOf(r, r + 1, false);
                            if (end - r != skip) {
                                r = end - 1;
                                continue;
                            }
                        }
                    }
                    if (r >= size) break;
                }
                if ((base = Math.min(r0, size - r)) >= skip && !this.equals(skip, base, this, r + skip)) continue;
                for (int i = r; i < size; i += r) {
                    if (this.equals(0, Math.min(r, size - i), this, i)) continue;
                    continue block1;
                }
                break;
            }
            if (r < size) {
                return new int[]{r0, r / r0};
            }
            if (r0 != 1) {
                return new int[]{r0};
            }
        }
        return ArraysExt.EMPTY_INT;
    }

    final long subtract(long a, long b) {
        long inc = a - b;
        if ((((long)(this.isUnsigned() ? Long.compareUnsigned(a, b) : Long.compare(a, b)) ^ inc) & Long.MIN_VALUE) != 0L) {
            throw new ArithmeticException(Errors.format((short)91, 64));
        }
        return inc;
    }

    public Number increment(double tolerance) {
        ArgumentChecks.ensurePositive("tolerance", tolerance);
        int i = this.size();
        if (i >= 2) {
            try {
                int pz;
                byte type = Numbers.getEnumConstant(this.getElementType());
                if (type >= 3 && type <= 6 && tolerance < 0.5) {
                    long l = this.longValue(--i);
                    long p = this.longValue(--i);
                    long inc = this.subtract(l, p);
                    while (i != 0) {
                        if (p - (p = this.longValue(--i)) == inc) continue;
                        return null;
                    }
                    switch (type) {
                        case 3: {
                            if (inc >= -128L && inc <= 127L) {
                                return (byte)inc;
                            }
                        }
                        case 4: {
                            if (inc >= -32768L && inc <= 32767L) {
                                return (short)inc;
                            }
                        }
                        case 5: {
                            if (inc < Integer.MIN_VALUE || inc > Integer.MAX_VALUE) break;
                            return (int)inc;
                        }
                    }
                    return inc;
                }
                double first = this.doubleValue(0);
                double inc = (this.doubleValue(--i) - first) / (double)i;
                if ((type == 9 || type == 11) && this.doubleValue(pz = Math.max(0, Math.min(i, (int)Math.rint(-first / inc)))) == 0.0) {
                    Number value;
                    Number number = value = pz == i ? (Number)this.get(pz - 1) : (Number)this.get(pz + 1);
                    if (value != null && !(value instanceof Float)) {
                        inc = value.doubleValue();
                        if (pz == i) {
                            inc = -inc;
                        }
                    }
                }
                if (type == 8) {
                    while (i >= 1) {
                        float value = this.floatValue(i);
                        double delta = Math.abs(first + inc * (double)i-- - (double)value);
                        double accur = Math.ulp(value);
                        if (!(accur > tolerance) ? delta <= tolerance : delta < accur) continue;
                        return null;
                    }
                    float f = (float)inc;
                    if ((double)f == inc) {
                        return Float.valueOf(f);
                    }
                } else {
                    while (i >= 1) {
                        double delta;
                        if ((delta = Math.abs(first + inc * (double)i - this.doubleValue(i--))) <= tolerance) continue;
                        return null;
                    }
                }
                return inc;
            }
            catch (ArithmeticException e) {
                this.warning("increment", e);
            }
        }
        return null;
    }

    public NumberRange<?> range() {
        return this.range(null, this.size());
    }

    NumberRange<?> range(IntSupplier indices, int n) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        while (--n >= 0) {
            double value = this.doubleValue(indices != null ? indices.getAsInt() : n);
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return NumberRange.create(min, true, max, true);
    }

    public final Vector subList(int lower, int upper) {
        return this.subSampling(lower, 1, upper - lower);
    }

    public Vector subSampling(int first, int step, int length) {
        int size = this.size();
        if (step == 1 && first == 0 && length == size) {
            return this;
        }
        long last = (long)first + (long)step * ((long)length - 1L);
        if (first < 0 || first >= size || last < 0L || last >= (long)size || length < 0) {
            Object arg2;
            Object arg1;
            short key;
            if (step == 1) {
                key = 76;
                arg1 = first;
                arg2 = last;
            } else {
                key = 59;
                arg1 = "range";
                arg2 = "[" + first + ":" + step + ":" + last + "]";
            }
            throw new IndexOutOfBoundsException(Errors.format(key, arg1, arg2));
        }
        return this.createSubSampling(first, step, length);
    }

    Vector createSubSampling(int first, int step, int length) {
        return new SubSampling(first, step, length);
    }

    Vector backingVector() {
        return this;
    }

    int[] toBacking(int[] indices) {
        indices = (int[])indices.clone();
        int length = this.size();
        for (int i : indices) {
            Objects.checkIndex(i, length);
        }
        return indices;
    }

    public Vector pick(int ... indices) {
        int step;
        int first;
        indices = this.toBacking(indices);
        switch (indices.length) {
            case 0: {
                first = 0;
                step = 1;
                break;
            }
            case 1: {
                first = indices[0];
                step = 1;
                break;
            }
            default: {
                first = indices[0];
                int limit = indices[1];
                step = limit - first;
                for (int i = 2; i < indices.length; ++i) {
                    int current = indices[i];
                    if (current - limit != step) {
                        Vector vector = this.backingVector();
                        Objects.requireNonNull(vector);
                        return vector.new Pick(indices);
                    }
                    limit = current;
                }
            }
        }
        return this.subSampling(first, step, indices.length);
    }

    public Vector concatenate(Vector toAppend) {
        if (toAppend.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return toAppend;
        }
        return this.createConcatenate(toAppend);
    }

    Vector createConcatenate(Vector toAppend) {
        return new ConcatenatedVector(this, toAppend);
    }

    public Vector repeat(boolean eachValue, int count) {
        switch (count) {
            case 0: {
                return this.subList(0, 0);
            }
            case 1: {
                return this;
            }
        }
        ArgumentChecks.ensurePositive("count", count);
        int size = this.size();
        return new RepeatedVector(this, eachValue ? count : 1, size, Math.multiplyExact(size, count));
    }

    public final Vector reverse() {
        int length = this.size();
        return length > 1 ? this.subSampling(length - 1, -1, length) : this;
    }

    public Vector transform(double scale, double offset) {
        if (scale == 1.0 && offset == 0.0) {
            return this;
        }
        ArgumentChecks.ensureFinite("scale", scale);
        ArgumentChecks.ensureFinite("offset", offset);
        if (scale == 0.0) {
            return new SequenceVector.Doubles(Double.class, 0, 0, this.size());
        }
        return this.createTransform(scale, offset);
    }

    Vector createTransform(double scale, double offset) {
        return new LinearlyDerivedVector(this, scale, offset);
    }

    public Vector compress(double tolerance) {
        NumberRange<?> range;
        int length = this.size();
        Number inc = this.increment(tolerance);
        if (inc != null) {
            return Vector.createSequence(this.getElementType(), this.get(0), inc, length);
        }
        int i = 0;
        do {
            if (i < length) continue;
            Double NaN = Double.NaN;
            return Vector.createSequence(this.getElementType(), NaN, NaN, length);
        } while (this.isNaN(i++));
        if (length > 640 / this.getBitCount()) {
            int[] repetitions = this.repetitions(MathFunctions.divisors(length));
            switch (repetitions.length) {
                default: {
                    if (length - repetitions[1] < length / 4) break;
                }
                case 1: {
                    return new RepeatedVector(this, repetitions, tolerance);
                }
                case 0: 
            }
        }
        if ((range = this.range()) != null && !range.isEmpty()) {
            Vector vec;
            boolean isInteger;
            Number min = (Number)range.getMinValue();
            Number max = (Number)range.getMaxValue();
            boolean bl = isInteger = min.doubleValue() >= -9.223372036854776E18 && max.doubleValue() <= 9.223372036854776E18 && this.isInteger();
            if (isInteger) {
                vec = PackedVector.compress(this, min.longValue(), max.longValue());
                if (vec == null) {
                    vec = ArrayVector.compress(this, min.longValue(), max.longValue());
                }
            } else {
                vec = ArrayVector.compress(this, tolerance);
            }
            if (vec != null) {
                return vec;
            }
        }
        return this;
    }

    final void warning(String method, RuntimeException e) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.math"), Vector.class, method, e);
    }

    public Optional<Buffer> buffer() {
        return Optional.empty();
    }

    public double[] doubleValues() {
        double[] array = new double[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.doubleValue(i);
        }
        return array;
    }

    public float[] floatValues() {
        float[] array = new float[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.floatValue(i);
        }
        return array;
    }

    final Vector copy() {
        Object[] array;
        int size = this.size();
        switch (Numbers.getEnumConstant(this.getElementType())) {
            case 9: {
                array = this.doubleValues();
                break;
            }
            case 8: {
                array = this.floatValues();
                if (size == 0 || !(this.get(0) instanceof Double)) break;
                return Vector.createForDecimal((float[])array);
            }
            case 6: {
                long[] data = new long[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = this.longValue(i);
                }
                array = data;
                break;
            }
            case 5: {
                int[] data = new int[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = (int)this.longValue(i);
                }
                array = data;
                break;
            }
            case 4: {
                short[] data = new short[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = (short)this.intValue(i);
                }
                array = data;
                break;
            }
            case 3: {
                byte[] data = new byte[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = (byte)this.intValue(i);
                }
                array = data;
                break;
            }
            default: {
                array = this.toArray(new Number[size]);
            }
        }
        return ArrayVector.newInstance(array, this.isUnsigned());
    }

    @Override
    public String toString() {
        StringJoiner buffer = new StringJoiner(", ", "[", "]");
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            buffer.add(this.stringValue(i));
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = 31 * hash + this.get(i).hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Vector) {
            Vector other = (Vector)object;
            int size = this.size();
            if (size == other.size()) {
                return this.equals(0, size, other, 0);
            }
        }
        return false;
    }

    boolean equals(int lower, int upper, Vector other, int otherOffset) {
        while (lower < upper) {
            if (this.get(lower++).equals(other.get(otherOffset++))) continue;
            return false;
        }
        return true;
    }

    private final class SubSampling
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 7641036842053528486L;
        final int first;
        final int step;
        final int length;

        SubSampling(int first, int step, int length) {
            this.first = first;
            this.step = step;
            this.length = length;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        final int toBacking(int index) {
            return Objects.checkIndex(index, this.length) * this.step + this.first;
        }

        @Override
        int[] toBacking(int[] index) {
            int[] ni = new int[index.length];
            for (int j = 0; j < ni.length; ++j) {
                ni[j] = this.toBacking(index[j]);
            }
            return ni;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public boolean isSinglePrecision() {
            return Vector.this.isSinglePrecision();
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public boolean isUnsigned() {
            return Vector.this.isUnsigned();
        }

        @Override
        public boolean isNaN(int index) {
            return Vector.this.isNaN(this.toBacking(index));
        }

        @Override
        public double doubleValue(int index) {
            return Vector.this.doubleValue(this.toBacking(index));
        }

        @Override
        public float floatValue(int index) {
            return Vector.this.floatValue(this.toBacking(index));
        }

        @Override
        public long longValue(int index) {
            return Vector.this.longValue(this.toBacking(index));
        }

        @Override
        public int intValue(int index) {
            return Vector.this.intValue(this.toBacking(index));
        }

        @Override
        public short shortValue(int index) {
            return Vector.this.shortValue(this.toBacking(index));
        }

        @Override
        public byte byteValue(int index) {
            return Vector.this.byteValue(this.toBacking(index));
        }

        @Override
        public String stringValue(int index) {
            return Vector.this.stringValue(this.toBacking(index));
        }

        @Override
        public Number get(int index) {
            return Vector.this.get(this.toBacking(index));
        }

        @Override
        public Number set(int index, Number v) {
            Number old = Vector.this.set(this.toBacking(index), v);
            ++this.modCount;
            return old;
        }

        @Override
        Vector createTransform(double scale, double offset) {
            return Vector.this.transform(scale, offset).subSampling(this.first, this.step, this.length);
        }

        @Override
        Vector createSubSampling(int first, int step, int length) {
            first = this.toBacking(first);
            return Vector.this.subSampling(first, step *= this.step, length);
        }

        @Override
        Vector createConcatenate(Vector toAppend) {
            if (toAppend instanceof SubSampling && toAppend.backingVector() == Vector.this) {
                SubSampling other = (SubSampling)toAppend;
                if (other.step == this.step && other.first == this.first + this.step * this.length) {
                    return Vector.this.subSampling(this.first, this.step, this.length + other.length);
                }
            }
            return super.createConcatenate(toAppend);
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            if (indices != null) {
                return Vector.this.range(() -> this.toBacking(indices.getAsInt()), n);
            }
            IntSupplier supplier = null;
            if (this.first != 0 || this.step != 1) {
                supplier = new IntSupplier(){
                    private int index;
                    {
                        this.index = SubSampling.this.first;
                    }

                    @Override
                    public int getAsInt() {
                        int i = this.index;
                        this.index += SubSampling.this.step;
                        return i;
                    }
                };
            }
            return Vector.this.range(supplier, n);
        }

        @Override
        public Vector compress(double tolerance) {
            Vector c = super.compress(tolerance);
            return c != this ? c : this.copy();
        }

        @Override
        public Optional<Buffer> buffer() {
            if (this.step == 1) {
                Vector.this.buffer().map(b -> b.position(this.first).limit(this.first + this.length).slice());
            }
            return super.buffer();
        }
    }

    private final class Pick
    extends Vector
    implements Serializable {
        private static final long serialVersionUID = 6574040261355090760L;
        private final int[] indices;

        Pick(int[] indices) {
            this.indices = indices;
        }

        @Override
        Vector backingVector() {
            return Vector.this;
        }

        @Override
        int[] toBacking(int[] i) {
            int[] ni = new int[i.length];
            for (int j = 0; j < ni.length; ++j) {
                ni[j] = this.indices[i[j]];
            }
            return ni;
        }

        @Override
        public Class<? extends Number> getElementType() {
            return Vector.this.getElementType();
        }

        @Override
        public boolean isSinglePrecision() {
            return Vector.this.isSinglePrecision();
        }

        @Override
        public int size() {
            return this.indices.length;
        }

        @Override
        public boolean isUnsigned() {
            return Vector.this.isUnsigned();
        }

        @Override
        public boolean isNaN(int i) {
            return Vector.this.isNaN(this.indices[i]);
        }

        @Override
        public double doubleValue(int i) {
            return Vector.this.doubleValue(this.indices[i]);
        }

        @Override
        public float floatValue(int i) {
            return Vector.this.floatValue(this.indices[i]);
        }

        @Override
        public long longValue(int i) {
            return Vector.this.longValue(this.indices[i]);
        }

        @Override
        public int intValue(int i) {
            return Vector.this.intValue(this.indices[i]);
        }

        @Override
        public short shortValue(int i) {
            return Vector.this.shortValue(this.indices[i]);
        }

        @Override
        public byte byteValue(int i) {
            return Vector.this.byteValue(this.indices[i]);
        }

        @Override
        public String stringValue(int i) {
            return Vector.this.stringValue(this.indices[i]);
        }

        @Override
        public Number get(int i) {
            return Vector.this.get(this.indices[i]);
        }

        @Override
        public Number set(int i, Number v) {
            Number old = Vector.this.set(this.indices[i], v);
            ++this.modCount;
            return old;
        }

        @Override
        Vector createTransform(double scale, double offset) {
            return Vector.this.transform(scale, offset).pick(this.indices);
        }

        @Override
        Vector createSubSampling(int first, int step, int length) {
            int[] ni = new int[length];
            if (step == 1) {
                System.arraycopy(this.indices, first, ni, 0, length);
            } else {
                for (int j = 0; j < length; ++j) {
                    ni[j] = this.indices[first];
                    first += step;
                }
            }
            return Vector.this.pick(ni);
        }

        @Override
        Vector createConcatenate(Vector toAppend) {
            if (toAppend instanceof Pick && toAppend.backingVector() == Vector.this) {
                int[] other = ((Pick)toAppend).indices;
                int[] c = Arrays.copyOf(this.indices, this.indices.length + other.length);
                System.arraycopy(other, 0, c, this.indices.length, other.length);
                return Vector.this.pick(c);
            }
            return super.createConcatenate(toAppend);
        }

        @Override
        NumberRange<?> range(IntSupplier supplier, int n) {
            if (supplier != null) {
                return Vector.this.range(() -> this.indices[supplier.getAsInt()], n);
            }
            return Vector.this.range(new IntSupplier(){
                private int index;

                @Override
                public int getAsInt() {
                    return Pick.this.indices[this.index++];
                }
            }, n);
        }

        @Override
        public Vector compress(double tolerance) {
            Vector c = super.compress(tolerance);
            return c != this ? c : this.copy();
        }
    }
}

