/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.httpclient;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.shenyu.plugin.httpclient.AbstractHttpClientPlugin;
import org.apache.shenyu.plugin.httpclient.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class ExponentialRetryBackoffStrategy<R>
implements RetryStrategy<R> {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialRetryBackoffStrategy.class);
    private final AbstractHttpClientPlugin<R> httpClientPlugin;

    public ExponentialRetryBackoffStrategy(AbstractHttpClientPlugin<R> httpClientPlugin) {
        this.httpClientPlugin = httpClientPlugin;
    }

    @Override
    public Mono<R> execute(Mono<R> response, ServerWebExchange exchange, Duration duration, int retryTimes) {
        RetryBackoffSpec retrySpec = this.initDefaultBackoff(retryTimes);
        return response.retryWhen((Retry)retrySpec).timeout(duration, Mono.error(() -> new TimeoutException("Response took longer than timeout: " + duration))).doOnError(e -> LOG.error(e.getMessage(), e));
    }

    private RetryBackoffSpec initDefaultBackoff(int retryTimes) {
        return Retry.backoff((long)retryTimes, (Duration)Duration.ofMillis(500L)).maxBackoff(Duration.ofSeconds(5L)).transientErrors(true).jitter(0.5).filter(t -> t instanceof IllegalStateException).onRetryExhaustedThrow((retryBackoffSpecErr, retrySignal) -> {
            throw new IllegalStateException("Retry limit exceeded");
        });
    }
}

