/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHousePipedOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.stream.BlockingInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingPipedOutputStream
extends ClickHousePipedOutputStream {
    protected final BlockingQueue<ByteBuffer> queue;
    private final int bufferSize;
    private final int timeout;
    private ByteBuffer buffer;

    public BlockingPipedOutputStream(int bufferSize, int queueLength, int timeout, Runnable postCloseAction) {
        super(postCloseAction);
        this.queue = queueLength <= 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueLength);
        this.bufferSize = ClickHouseUtils.getBufferSize(bufferSize, (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue(), (Integer)ClickHouseClientOption.MAX_BUFFER_SIZE.getDefaultValue());
        this.timeout = timeout;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    private void updateBuffer(boolean allocateNewBuffer) throws IOException {
        ByteBuffer b = this.buffer;
        if (b.hasRemaining()) {
            ((Buffer)b).limit(b.position());
        }
        ((Buffer)b).rewind();
        this.updateBuffer(b);
        if (allocateNewBuffer) {
            this.buffer = ByteBuffer.allocate(this.bufferSize);
        }
    }

    private void updateBuffer(ByteBuffer b) throws IOException {
        try {
            if (this.timeout > 0) {
                if (!this.queue.offer(b, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Write timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(b);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting buffer into queue", e);
        }
    }

    @Override
    public ClickHouseInputStream getInputStream(Runnable postCloseAction) {
        return new BlockingInputStream(this.queue, this.timeout, postCloseAction);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.buffer.position() > 0) {
            this.updateBuffer(false);
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BUFFER;
        try {
            if (this.timeout > 0) {
                if (!this.queue.offer(this.buffer, this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(ClickHouseUtils.format("Close stream timed out after %d ms", this.timeout));
                }
            } else {
                this.queue.put(this.buffer);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread was interrupted when putting EMPTY buffer into queue", e);
        }
        finally {
            this.closed = true;
            if (this.postCloseAction != null) {
                this.postCloseAction.run();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        if (this.buffer.position() > 0) {
            this.updateBuffer(true);
        }
    }

    @Override
    public ClickHouseOutputStream transferBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        ByteBuffer b = this.buffer;
        if (b.position() > 0) {
            this.updateBuffer(true);
        }
        this.updateBuffer(ByteBuffer.wrap(bytes, offset, length));
        return this;
    }

    @Override
    public ClickHouseOutputStream writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.buffer.put(b);
        if (!this.buffer.hasRemaining()) {
            this.updateBuffer(true);
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        ByteBuffer b = this.buffer;
        while (length > 0) {
            int remain = b.remaining();
            if (length < remain) {
                b.put(bytes, offset, length);
                length = 0;
                continue;
            }
            if (b.position() == 0) {
                this.buffer = ByteBuffer.allocate(length);
                this.buffer.put(bytes, offset, length);
                this.updateBuffer(false);
                this.buffer = b;
                length = 0;
                continue;
            }
            b.put(bytes, offset, remain);
            offset += remain;
            length -= remain;
            this.updateBuffer(true);
            b = this.buffer;
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeCustom(ClickHouseDataUpdater writer) throws IOException {
        this.ensureOpen();
        int position = 0;
        int written = 0;
        do {
            byte[] bytes;
            position = this.buffer.position();
            int limit = this.buffer.limit();
            if (this.buffer.hasArray()) {
                bytes = this.buffer.array();
            } else {
                bytes = new byte[limit - position];
                this.buffer.get(bytes);
            }
            written = writer.update(bytes, position, limit);
            if (written >= 0) continue;
            ((Buffer)this.buffer).position(limit);
            this.updateBuffer(true);
        } while (written < 0);
        ((Buffer)this.buffer).position(position + written);
        return this;
    }
}

