/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class FieldWriterFloatMethod<T>
extends FieldWriter<T> {
    protected FieldWriterFloatMethod(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, null, label, fieldType, fieldClass, field, method);
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Float value;
        try {
            value = (Float)this.getFieldValue((Object)object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = jsonWriter.getFeatures(this.features);
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L && (features & JSONWriter.Feature.NotWriteDefaultValue.mask) == 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNumberNull();
                return true;
            }
            return false;
        }
        this.writeFieldName(jsonWriter);
        float floatValue = value.floatValue();
        if (this.decimalFormat != null) {
            jsonWriter.writeFloat(floatValue, this.decimalFormat);
        } else if ((this.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(floatValue);
        } else {
            jsonWriter.writeFloat(floatValue);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Float value = (Float)this.getFieldValue((Object)object);
        if (value == null) {
            jsonWriter.writeNumberNull();
        } else {
            float floatValue = value.floatValue();
            if (this.decimalFormat != null) {
                jsonWriter.writeFloat(floatValue, this.decimalFormat);
            } else {
                jsonWriter.writeFloat(floatValue);
            }
        }
    }
}

