/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder {
    private Boolean daemon = false;
    private Integer priority = null;
    private String nameFormat = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory customizeFactory = null;

    public ThreadFactoryBuilder nameFormat(String nameFormat) {
        this.checkNullParameter(nameFormat, "nameFormat cannot be null.");
        this.nameFormat = nameFormat;
        return this;
    }

    public ThreadFactoryBuilder priority(int priority) {
        if (priority > 10 || priority < 1) {
            throw new IllegalArgumentException(String.format("The value of priority should be between %s and %s", 2, 11));
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.checkNullParameter(uncaughtExceptionHandler, "uncaughtExceptionHandler cannot be null.");
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactoryBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder customizeFactory(ThreadFactory factory) {
        this.checkNullParameter(factory, "factory cannot be null.");
        this.customizeFactory = factory;
        return this;
    }

    public ThreadFactory build() {
        ThreadFactory factory = this.customizeFactory == null ? Executors.defaultThreadFactory() : this.customizeFactory;
        AtomicLong count = this.nameFormat != null ? new AtomicLong(0L) : null;
        return r -> {
            Thread thread = factory.newThread(r);
            if (this.nameFormat != null) {
                thread.setName(this.format(this.nameFormat, count.getAndIncrement()));
            }
            if (this.priority != null) {
                thread.setPriority(this.priority);
            }
            if (this.uncaughtExceptionHandler != null) {
                thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            }
            thread.setDaemon(this.daemon);
            return thread;
        };
    }

    private String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private void checkNullParameter(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }
}

