/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag.model;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.rpc.cluster.router.tag.model.ParamMatch;

public class Tag {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(Tag.class);
    private String name;
    private List<ParamMatch> match;
    private List<String> addresses;

    public static Tag parseFromMap(Map<String, Object> map, String version) {
        Object addresses;
        Tag tag = new Tag();
        tag.setName((String)map.get("name"));
        if (version != null && version.startsWith("v3.0")) {
            if (map.get("match") != null) {
                tag.setMatch(((List)map.get("match")).stream().map(objectMap -> {
                    try {
                        return PojoUtils.mapToPojo(objectMap, ParamMatch.class);
                    }
                    catch (ReflectiveOperationException e) {
                        logger.error("2-15", " Failed to parse tag rule ", String.valueOf(objectMap), "Error occurred when parsing rule component.", e);
                        return null;
                    }
                }).collect(Collectors.toList()));
            } else {
                logger.warn("2-15", "", String.valueOf(map), "It's recommended to use 'match' instead of 'addresses' for v3.0 tag rule.");
            }
        }
        if ((addresses = map.get("addresses")) != null && List.class.isAssignableFrom(addresses.getClass())) {
            tag.setAddresses(((List)addresses).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        return tag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public List<ParamMatch> getMatch() {
        return this.match;
    }

    public void setMatch(List<ParamMatch> match) {
        this.match = match;
    }
}

