/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.RegistryNotifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.zookeeper.ZookeeperInstance;
import org.apache.dubbo.registry.zookeeper.ZookeeperServiceDiscovery;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class ZookeeperServiceDiscoveryChangeWatcher
implements ServiceCacheListener {
    private final Set<ServiceInstancesChangedListener> listeners = new ConcurrentHashSet<ServiceInstancesChangedListener>();
    private final ServiceCache<ZookeeperInstance> cacheInstance;
    private final ZookeeperServiceDiscovery zookeeperServiceDiscovery;
    private final RegistryNotifier notifier;
    private final String serviceName;
    private final CountDownLatch latch;

    public ZookeeperServiceDiscoveryChangeWatcher(ZookeeperServiceDiscovery zookeeperServiceDiscovery, ServiceCache<ZookeeperInstance> cacheInstance, String serviceName, CountDownLatch latch) {
        this.zookeeperServiceDiscovery = zookeeperServiceDiscovery;
        this.cacheInstance = cacheInstance;
        this.serviceName = serviceName;
        this.notifier = new RegistryNotifier(zookeeperServiceDiscovery.getUrl(), zookeeperServiceDiscovery.getDelay(), ScopeModelUtil.getFrameworkModel(zookeeperServiceDiscovery.getUrl().getScopeModel()).getBeanFactory().getBean(FrameworkExecutorRepository.class).getServiceDiscoveryAddressNotificationExecutor()){

            @Override
            protected void doNotify(Object rawAddresses) {
                ZookeeperServiceDiscoveryChangeWatcher.this.listeners.forEach(listener -> listener.onEvent((ServiceInstancesChangedEvent)rawAddresses));
            }
        };
        this.latch = latch;
    }

    public void cacheChanged() {
        try {
            this.latch.await();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        List<ServiceInstance> instanceList = this.zookeeperServiceDiscovery.getInstances(this.serviceName);
        this.notifier.notify(new ServiceInstancesChangedEvent(this.serviceName, instanceList));
    }

    public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
    }

    public ServiceCache<ZookeeperInstance> getCacheInstance() {
        return this.cacheInstance;
    }

    public Set<ServiceInstancesChangedListener> getListeners() {
        return this.listeners;
    }

    public void addListener(ServiceInstancesChangedListener listener) {
        this.listeners.add(listener);
    }
}

