/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class DefaultSerializeClassChecker
implements AllowClassNotifyListener {
    private static final long MAGIC_HASH_CODE = -3750763034362895579L;
    private static final long MAGIC_PRIME = 1099511628211L;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultSerializeClassChecker.class);
    private volatile SerializeCheckStatus checkStatus = AllowClassNotifyListener.DEFAULT_STATUS;
    private volatile boolean checkSerializable = true;
    private final SerializeSecurityManager serializeSecurityManager;
    private volatile long[] allowPrefixes = new long[0];
    private volatile long[] disAllowPrefixes = new long[0];

    public DefaultSerializeClassChecker(FrameworkModel frameworkModel) {
        this.serializeSecurityManager = frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        this.serializeSecurityManager.registerListener(this);
    }

    @Override
    public synchronized void notifyPrefix(Set<String> allowedList, Set<String> disAllowedList) {
        this.allowPrefixes = DefaultSerializeClassChecker.loadPrefix(allowedList);
        this.disAllowPrefixes = DefaultSerializeClassChecker.loadPrefix(disAllowedList);
    }

    @Override
    public synchronized void notifyCheckStatus(SerializeCheckStatus status) {
        this.checkStatus = status;
    }

    @Override
    public synchronized void notifyCheckSerializable(boolean checkSerializable) {
        this.checkSerializable = checkSerializable;
    }

    private static long[] loadPrefix(Set<String> allowedList) {
        long[] array = new long[allowedList.size()];
        int index = 0;
        for (String name : allowedList) {
            if (name == null || name.isEmpty()) continue;
            long hashCode = -3750763034362895579L;
            for (int j = 0; j < name.length(); ++j) {
                int ch = name.charAt(j);
                if (ch == 36) {
                    ch = 46;
                }
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
            array[index++] = hashCode;
        }
        if (index != array.length) {
            array = Arrays.copyOf(array, index);
        }
        Arrays.sort(array);
        return array;
    }

    public Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class<?> aClass = this.loadClass0(classLoader, className);
        if (!aClass.isPrimitive() && !Serializable.class.isAssignableFrom(aClass)) {
            String msg = "[Serialization Security] Serialized class " + className + " has not implement Serializable interface. Current mode is strict check, will disallow to deserialize it by default. ";
            if (this.serializeSecurityManager.getWarnedClasses().add(className)) {
                logger.error("4-21", "", "", msg);
            }
            if (this.checkSerializable) {
                throw new IllegalArgumentException(msg);
            }
        }
        return aClass;
    }

    private Class<?> loadClass0(ClassLoader classLoader, String className) throws ClassNotFoundException {
        int ch;
        int i;
        if (this.checkStatus == SerializeCheckStatus.DISABLE) {
            return ClassUtils.forName(className, classLoader);
        }
        long hash = -3750763034362895579L;
        int typeNameLength = className.length();
        for (i = 0; i < typeNameLength; ++i) {
            ch = className.charAt(i);
            if (ch == 36) {
                ch = 46;
            }
            hash ^= (long)ch;
            if (Arrays.binarySearch(this.allowPrefixes, hash *= 1099511628211L) < 0) continue;
            return ClassUtils.forName(className, classLoader);
        }
        if (this.checkStatus == SerializeCheckStatus.STRICT) {
            String msg = "[Serialization Security] Serialized class " + className + " is not in allow list. Current mode is `STRICT`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
            if (this.serializeSecurityManager.getWarnedClasses().add(className)) {
                logger.error("4-21", "", "", msg);
            }
            throw new IllegalArgumentException(msg);
        }
        hash = -3750763034362895579L;
        typeNameLength = className.length();
        for (i = 0; i < typeNameLength; ++i) {
            ch = className.charAt(i);
            if (ch == 36) {
                ch = 46;
            }
            hash ^= (long)ch;
            if (Arrays.binarySearch(this.disAllowPrefixes, hash *= 1099511628211L) < 0) continue;
            String msg = "[Serialization Security] Serialized class " + className + " is in disallow list. Current mode is `WARN`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
            if (this.serializeSecurityManager.getWarnedClasses().add(className)) {
                logger.warn("4-21", "", "", msg);
            }
            throw new IllegalArgumentException(msg);
        }
        hash = -3750763034362895579L;
        typeNameLength = className.length();
        for (i = 0; i < typeNameLength; ++i) {
            ch = Character.toLowerCase(className.charAt(i));
            if (ch == 36) {
                ch = 46;
            }
            hash ^= (long)ch;
            if (Arrays.binarySearch(this.disAllowPrefixes, hash *= 1099511628211L) < 0) continue;
            String msg = "[Serialization Security] Serialized class " + className + " is in disallow list. Current mode is `WARN`, will disallow to deserialize it by default. Please add it into security/serialize.allowlist or follow FAQ to configure it.";
            if (this.serializeSecurityManager.getWarnedClasses().add(className)) {
                logger.warn("4-21", "", "", msg);
            }
            throw new IllegalArgumentException(msg);
        }
        Class<?> clazz = ClassUtils.forName(className, classLoader);
        if (this.serializeSecurityManager.getWarnedClasses().add(className)) {
            logger.warn("4-21", "", "", "[Serialization Security] Serialized class " + className + " is not in allow list. Current mode is `WARN`, will allow to deserialize it by default. Dubbo will set to `STRICT` mode by default in the future. Please add it into security/serialize.allowlist or follow FAQ to configure it.");
        }
        return clazz;
    }

    public static DefaultSerializeClassChecker getInstance() {
        return FrameworkModel.defaultModel().getBeanFactory().getBean(DefaultSerializeClassChecker.class);
    }

    public boolean isCheckSerializable() {
        return this.checkSerializable;
    }
}

