/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.profiler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ProfilerEntry {
    private final List<ProfilerEntry> sub = new ArrayList<ProfilerEntry>(4);
    private final String message;
    private final ProfilerEntry parent;
    private final ProfilerEntry first;
    private final long startTime;
    private final AtomicInteger requestCount;
    private long endTime;

    public ProfilerEntry(String message) {
        this.message = message;
        this.parent = null;
        this.first = this;
        this.startTime = System.nanoTime();
        this.requestCount = new AtomicInteger(1);
    }

    public ProfilerEntry(String message, ProfilerEntry parentEntry, ProfilerEntry firstEntry) {
        this.message = message;
        this.parent = parentEntry;
        this.first = firstEntry;
        this.startTime = System.nanoTime();
        this.requestCount = parentEntry.getRequestCount();
    }

    public List<ProfilerEntry> getSub() {
        return this.sub;
    }

    public String getMessage() {
        return this.message;
    }

    public ProfilerEntry getParent() {
        return this.parent;
    }

    public ProfilerEntry getFirst() {
        return this.first;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }
}

