/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.context.path;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.context.path.handler.ContextPathPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ContextPathPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ContextPathPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        ContextMappingRuleHandle ruleHandle = this.buildRuleHandle(rule);
        if (Objects.isNull(ruleHandle)) {
            LOG.error("context path rule configuration is null \uff1a{}", (Object)rule);
            return chain.execute(exchange);
        }
        this.buildRealURI(exchange, shenyuContext, ruleHandle);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.CONTEXT_PATH.getCode();
    }

    public String named() {
        return PluginEnum.CONTEXT_PATH.getName();
    }

    private ContextMappingRuleHandle buildRuleHandle(RuleData rule) {
        return (ContextMappingRuleHandle)ContextPathPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
    }

    private void buildRealURI(ServerWebExchange exchange, ShenyuContext context, ContextMappingRuleHandle handle) {
        String addPrefix;
        Map attributes = exchange.getAttributes();
        Object realURI = "";
        String contextPath = handle.getContextPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contextPath})) {
            realURI = context.getPath().substring(contextPath.length());
            attributes.put("contextPath", contextPath);
        }
        Integer percentage = Optional.ofNullable(handle.getPercentage()).orElse(100);
        String rewriteContextPath = handle.getRewriteContextPath();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteContextPath}) && ThreadLocalRandom.current().nextInt(100) < percentage) {
            MetaData metaData = MetaDataCache.getInstance().obtain(rewriteContextPath + (String)realURI);
            Optional.ofNullable(exchange.getAttribute("metaData")).ifPresent(metadata -> attributes.put("old_context_path_meta_data", metadata));
            if (Objects.nonNull(metaData)) {
                attributes.put("metaData", metaData);
            }
            attributes.put("rewrite_context_path", rewriteContextPath);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addPrefix = handle.getAddPrefix()})) {
            realURI = StringUtils.isNotBlank((CharSequence)realURI) ? addPrefix + (String)realURI : addPrefix + context.getPath();
        }
        context.setRealUrl((String)realURI);
    }
}

