/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.exception;

import com.tencent.polaris.api.exception.ErrorCode;

public interface ServerCodes {
    public static final int EXECUTE_SUCCESS = 200000;
    public static final int DATA_NO_CHANGE = 200001;
    public static final int EXISTED_RESOURCE = 400201;
    public static final int NOT_FOUND_RESOURCE = 400202;
    public static final int NOT_FOUND_SERVICE = 400301;

    public static int toHttpCode(int code) {
        return code / 100000 * 100;
    }

    public static ErrorCode convertServerErrorToRpcError(int code) {
        int typCode = code / 1000;
        switch (typCode) {
            case 200: {
                return ErrorCode.Success;
            }
            case 400: {
                return ErrorCode.INVALID_REQUEST;
            }
            case 401: {
                return ErrorCode.UNAUTHORIZED;
            }
            case 403: {
                return ErrorCode.REQUEST_LIMIT;
            }
            case 404: {
                return ErrorCode.CMDB_NOT_FOUND;
            }
            case 500: {
                return ErrorCode.SERVER_ERROR;
            }
        }
        return ErrorCode.UNKNOWN_SERVER_ERROR;
    }
}

