/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.algorithm;

import java.util.Arrays;
import java.util.List;
import org.apache.shenyu.common.enums.RateLimitEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.plugin.ratelimiter.algorithm.AbstractRateLimiterAlgorithm;
import org.apache.shenyu.spi.Join;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

@Join
public class ConcurrentRateLimiterAlgorithm
extends AbstractRateLimiterAlgorithm {
    public ConcurrentRateLimiterAlgorithm() {
        super(RateLimitEnum.CONCURRENT.getScriptName());
    }

    @Override
    protected String getKeyName() {
        return RateLimitEnum.CONCURRENT.getKeyName();
    }

    @Override
    public List<String> getKeys(String id) {
        String hashKeyPart = ".{" + id + "}";
        String tokenKey = this.getKeyName() + hashKeyPart + ".tokens";
        String requestKey = UUIDUtils.getInstance().generateShortUuid() + hashKeyPart + ".request";
        return Arrays.asList(tokenKey, requestKey);
    }

    @Override
    public void callback(RedisScript<?> script, List<String> keys, List<?> scriptArgs) {
        ((ReactiveRedisTemplate)Singleton.INST.get(ReactiveRedisTemplate.class)).opsForZSet().remove((Object)keys.get(0), new Object[]{keys.get(1)}).subscribe();
    }
}

