/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.eclipse.parsson.JsonArrayBuilderImpl;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonNumberImpl;
import org.eclipse.parsson.JsonObjectBuilderImpl;
import org.eclipse.parsson.JsonStringImpl;

public final class MapUtil {
    private MapUtil() {
    }

    static JsonValue handle(Object value, JsonContext jsonContext) {
        if (value == null) {
            return JsonValue.NULL;
        }
        if (value instanceof JsonValue) {
            return (JsonValue)value;
        }
        if (value instanceof JsonArrayBuilder) {
            return ((JsonArrayBuilder)value).build();
        }
        if (value instanceof JsonObjectBuilder) {
            return ((JsonObjectBuilder)value).build();
        }
        if (value instanceof BigDecimal) {
            return JsonNumberImpl.getJsonNumber((BigDecimal)value, jsonContext.bigIntegerScaleLimit());
        }
        if (value instanceof BigInteger) {
            return JsonNumberImpl.getJsonNumber((BigInteger)value, jsonContext.bigIntegerScaleLimit());
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Double) {
            return JsonNumberImpl.getJsonNumber((Double)value, jsonContext.bigIntegerScaleLimit());
        }
        if (value instanceof Integer) {
            return JsonNumberImpl.getJsonNumber((Integer)value, jsonContext.bigIntegerScaleLimit());
        }
        if (value instanceof Long) {
            return JsonNumberImpl.getJsonNumber((Long)value, jsonContext.bigIntegerScaleLimit());
        }
        if (value instanceof String) {
            return new JsonStringImpl((String)value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            JsonArrayBuilderImpl jsonArrayBuilder = new JsonArrayBuilderImpl(collection, jsonContext);
            return jsonArrayBuilder.build();
        }
        if (value instanceof Map) {
            JsonObjectBuilderImpl object = new JsonObjectBuilderImpl((Map)value, jsonContext);
            return object.build();
        }
        throw new IllegalArgumentException(String.format("Type %s is not supported.", value.getClass()));
    }
}

