/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.DataPermission;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.discovery.DiscoveryLevel;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryProcessorHolder;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.DiscoveryRelMapper;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorConditionMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryHandlerDO;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.entity.SelectorConditionDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.plugin.BatchNamespacePluginDeletedEvent;
import org.apache.shenyu.admin.model.event.selector.SelectorCreatedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.SelectorConditionQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.query.SelectorQueryCondition;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.DiscoveryUpstreamVO;
import org.apache.shenyu.admin.model.vo.DiscoveryVO;
import org.apache.shenyu.admin.model.vo.SelectorConditionVO;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.service.publish.SelectorEventPublisher;
import org.apache.shenyu.admin.transfer.ConditionTransfer;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.admin.utils.SelectorUtil;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SelectorServiceImpl
implements SelectorService {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorServiceImpl.class);
    private final SelectorMapper selectorMapper;
    private final SelectorConditionMapper selectorConditionMapper;
    private final PluginMapper pluginMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final SelectorEventPublisher selectorEventPublisher;
    private final DiscoveryHandlerMapper discoveryHandlerMapper;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final DiscoveryMapper discoveryMapper;
    private final DiscoveryRelMapper discoveryRelMapper;
    private final DiscoveryProcessorHolder discoveryProcessorHolder;

    public SelectorServiceImpl(SelectorMapper selectorMapper, SelectorConditionMapper selectorConditionMapper, PluginMapper pluginMapper, ApplicationEventPublisher eventPublisher, DiscoveryMapper discoveryMapper, DiscoveryHandlerMapper discoveryHandlerMapper, DiscoveryRelMapper discoveryRelMapper, DiscoveryUpstreamMapper discoveryUpstreamMapper, DiscoveryProcessorHolder discoveryProcessorHolder, SelectorEventPublisher selectorEventPublisher) {
        this.selectorMapper = selectorMapper;
        this.selectorConditionMapper = selectorConditionMapper;
        this.pluginMapper = pluginMapper;
        this.discoveryMapper = discoveryMapper;
        this.discoveryHandlerMapper = discoveryHandlerMapper;
        this.discoveryRelMapper = discoveryRelMapper;
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryProcessorHolder = discoveryProcessorHolder;
        this.eventPublisher = eventPublisher;
        this.selectorEventPublisher = selectorEventPublisher;
    }

    @Override
    public void doConditionPreProcessing(SelectorQueryCondition condition) {
        if (SessionUtil.isAdmin()) {
            condition.setUserId(null);
        }
    }

    @Override
    public List<SelectorVO> searchByCondition(SelectorQueryCondition condition) {
        condition.init();
        List<SelectorDO> dolist = this.selectorMapper.selectByCondition(condition);
        List<SelectorVO> list = dolist.stream().map(SelectorVO::buildSelectorVO).collect(Collectors.toList());
        for (SelectorVO selector : list) {
            selector.setMatchModeName(MatchModeEnum.getMatchModeByCode((int)selector.getMatchMode()));
            selector.setTypeName(SelectorTypeEnum.getSelectorTypeByCode((int)selector.getType()));
        }
        return list;
    }

    @Override
    public String registerDefault(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        if (StringUtils.isEmpty((CharSequence)selectorDTO.getId())) {
            this.selectorMapper.insertSelective(selectorDO);
            this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        }
        this.selectorEventPublisher.publish(new SelectorCreatedEvent(selectorDO, selectorDO.getNamespaceId()));
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions(), Collections.emptyList());
        return selectorDO.getId();
    }

    @Override
    public String registerDefault(MetaDataRegisterDTO dto, String pluginName, String selectorHandler) {
        String namespaceId;
        String contextPath = ContextPathUtils.buildContextPath((String)dto.getContextPath(), (String)dto.getAppName());
        SelectorDO selectorDO = this.findByNameAndPluginNameAndNamespaceId(contextPath, pluginName, namespaceId = (String)StringUtils.defaultIfEmpty((CharSequence)dto.getNamespaceId(), (CharSequence)"649330b6-c2d7-4edc-be8e-8a54df9eb385"));
        if (Objects.isNull(selectorDO)) {
            SelectorDTO selectorDTO = SelectorUtil.buildSelectorDTO(contextPath, this.pluginMapper.selectByName(pluginName).getId());
            selectorDTO.setHandle(selectorHandler);
            selectorDTO.setNamespaceId(namespaceId);
            return this.registerDefault(selectorDTO);
        }
        return selectorDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(SelectorDTO selectorDTO) {
        return SelectorService.super.createOrUpdate(selectorDTO);
    }

    @Override
    public int create(SelectorDTO selectorDTO) {
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        int selectorCount = this.selectorMapper.insertSelective(selectorDO);
        selectorDTO.setId(selectorDO.getId());
        this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions(), Collections.emptyList());
        if (selectorCount > 0) {
            this.selectorEventPublisher.onCreated(selectorDO);
        }
        return selectorCount;
    }

    @Override
    public int update(SelectorDTO selectorDTO) {
        List currentCondition;
        SelectorDO before = this.selectorMapper.selectById(selectorDTO.getId());
        SelectorDO selectorDO = SelectorDO.buildSelectorDO(selectorDTO);
        int selectorCount = this.selectorMapper.updateSelective(selectorDO);
        List<SelectorConditionDO> beforeSelectorConditionList = this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId()));
        List beforeCondition = beforeSelectorConditionList.stream().map(selectorConditionDO -> SelectorConditionDTO.builder().selectorId(selectorConditionDO.getSelectorId()).operator(selectorConditionDO.getOperator()).paramName(selectorConditionDO.getParamName()).paramType(selectorConditionDO.getParamType()).paramValue(selectorConditionDO.getParamValue()).build()).collect(Collectors.toList());
        if (CollectionUtils.isEqualCollection(beforeCondition, currentCondition = selectorDTO.getSelectorConditions().stream().map(selectorConditionDTO -> SelectorConditionDTO.builder().selectorId(selectorConditionDTO.getSelectorId()).operator(selectorConditionDTO.getOperator()).paramName(selectorConditionDTO.getParamName()).paramType(selectorConditionDTO.getParamType()).paramValue(selectorConditionDTO.getParamValue()).build()).collect(Collectors.toList()))) {
            beforeSelectorConditionList = Collections.emptyList();
        }
        this.selectorConditionMapper.deleteByQuery(new SelectorConditionQuery(selectorDO.getId()));
        this.createCondition(selectorDO.getId(), selectorDTO.getSelectorConditions());
        this.publishEvent(selectorDO, selectorDTO.getSelectorConditions(), beforeSelectorConditionList);
        if (selectorCount > 0) {
            this.selectorEventPublisher.onUpdated(selectorDO, before);
        }
        return selectorCount;
    }

    @Override
    public int updateSelective(SelectorDO selectorDO) {
        SelectorDO before = this.selectorMapper.selectById(selectorDO.getId());
        int updateCount = this.selectorMapper.updateSelective(selectorDO);
        if (updateCount > 0) {
            this.selectorEventPublisher.onUpdated(selectorDO, before);
        }
        return updateCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteByNamespaceId(List<String> ids, String namespaceId) {
        List<SelectorDO> selectors = this.selectorMapper.selectByIdSet(new TreeSet<String>(ids));
        List<PluginDO> pluginDOS = this.pluginMapper.selectByIds(ListUtil.map(selectors, SelectorDO::getPluginId));
        this.unbindDiscovery(selectors, pluginDOS);
        return this.deleteSelector(selectors, pluginDOS);
    }

    private void unbindDiscovery(List<SelectorDO> selectors, List<PluginDO> pluginDOS) {
        Map pluginMap = ListUtil.toMap(pluginDOS, BaseDO::getId, PluginDO::getName);
        for (SelectorDO selector : selectors) {
            DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(selector.getId());
            if (Objects.isNull(discoveryHandlerDO)) continue;
            this.discoveryHandlerMapper.delete(discoveryHandlerDO.getId());
            this.discoveryRelMapper.deleteByDiscoveryHandlerId(discoveryHandlerDO.getId());
            this.discoveryUpstreamMapper.deleteByDiscoveryHandlerId(discoveryHandlerDO.getId());
            DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryHandlerDO.getDiscoveryId());
            if (!Objects.nonNull(discoveryDO)) continue;
            DiscoveryProcessor discoveryProcessor = this.discoveryProcessorHolder.chooseProcessor(discoveryDO.getDiscoveryType());
            ProxySelectorDTO proxySelectorDTO = new ProxySelectorDTO();
            proxySelectorDTO.setId(selector.getId());
            proxySelectorDTO.setName(selector.getSelectorName());
            proxySelectorDTO.setPluginName(pluginMap.getOrDefault(selector.getPluginId(), ""));
            proxySelectorDTO.setNamespaceId(selector.getNamespaceId());
            discoveryProcessor.removeProxySelector(DiscoveryTransfer.INSTANCE.mapToDTO(discoveryHandlerDO), proxySelectorDTO);
            if (!DiscoveryLevel.SELECTOR.getCode().equals(discoveryDO.getDiscoveryLevel())) continue;
            discoveryProcessor.removeDiscovery(discoveryDO);
            discoveryProcessor.removeSelectorUpstream(proxySelectorDTO);
            this.discoveryMapper.delete(discoveryDO.getId());
        }
    }

    @Override
    public SelectorVO findById(String id) {
        List conditions = ListUtil.map(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(id)), SelectorConditionVO::buildSelectorConditionVO);
        SelectorVO selectorVO = SelectorVO.buildSelectorVO(this.selectorMapper.selectById(id), conditions);
        DiscoveryHandlerDO discoveryHandlerDO = this.discoveryHandlerMapper.selectBySelectorId(id);
        if (Objects.nonNull(discoveryHandlerDO)) {
            selectorVO.setDiscoveryHandler(DiscoveryTransfer.INSTANCE.mapToVo(discoveryHandlerDO));
            String discoveryId = discoveryHandlerDO.getDiscoveryId();
            DiscoveryDO discoveryDO = this.discoveryMapper.selectById(discoveryId);
            DiscoveryVO discoveryVO = DiscoveryTransfer.INSTANCE.mapToVo(discoveryDO);
            selectorVO.setDiscoveryVO(discoveryVO);
            List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryHandlerDO.getId());
            Optional.ofNullable(discoveryUpstreamDOS).ifPresent(list -> {
                List<DiscoveryUpstreamVO> upstreamVOS = list.stream().map(DiscoveryTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
                selectorVO.setDiscoveryUpstreams(upstreamVOS);
            });
        }
        return selectorVO;
    }

    @Override
    public SelectorDO findByNameAndNamespaceId(String name, String namespaceId) {
        List<SelectorDO> doList = this.selectorMapper.selectByNameAndNamespaceId(name, namespaceId);
        return CollectionUtils.isNotEmpty(doList) ? doList.get(0) : null;
    }

    @Override
    public List<SelectorDO> findListByNameAndNamespaceId(String name, String namespaceId) {
        return this.selectorMapper.selectByNameAndNamespaceId(name, namespaceId);
    }

    @Override
    public SelectorDO findByNameAndPluginNameAndNamespaceId(String name, String pluginName, String namespaceId) {
        PluginDO pluginDO = this.pluginMapper.selectByName(pluginName);
        LOG.info("pluginDO info: {}.", (Object)pluginDO);
        return this.selectorMapper.findByNameAndPluginIdAndNamespaceId(name, pluginDO.getId(), namespaceId);
    }

    @Override
    public SelectorDO findByNameAndPluginNameAndNamespaceIdForUpdate(String name, String pluginName, String namespaceId) {
        PluginDO pluginDO = this.pluginMapper.selectByNameForUpdate(pluginName);
        return this.selectorMapper.findByNameAndPluginIdAndNamespaceId(name, pluginDO.getId(), namespaceId);
    }

    @Override
    public List<SelectorDO> findByNameAndPluginNamesAndNamespaceId(String name, List<String> pluginNames, String namespaceID) {
        List<PluginDO> pluginDOList = this.pluginMapper.selectByNames(pluginNames);
        if (CollectionUtils.isEmpty(pluginDOList)) {
            return Lists.newArrayList();
        }
        List<String> pluginIds = pluginDOList.stream().map(BaseDO::getId).collect(Collectors.toList());
        SelectorQuery selectorQuery = new SelectorQuery();
        selectorQuery.setName(name);
        selectorQuery.setPluginIds(pluginIds);
        selectorQuery.setNamespaceId(namespaceID);
        return this.selectorMapper.selectByQuery(selectorQuery);
    }

    @Override
    public SelectorData buildByNameAndNamespaceId(String name, String namespaceId) {
        return this.buildSelectorData(this.findByNameAndNamespaceId(name, namespaceId));
    }

    @Override
    public SelectorData buildByNameAndPluginNameAndNamespaceId(String name, String pluginName, String namespaceId) {
        return this.buildSelectorData(this.findByNameAndPluginNameAndNamespaceId(name, pluginName, namespaceId));
    }

    @Override
    @DataPermission(dataType="selector")
    @Pageable
    public CommonPager<SelectorVO> listByPageWithPermission(SelectorQuery selectorQuery) {
        return this.listByPage(selectorQuery);
    }

    @Override
    public CommonPager<SelectorVO> listByPage(SelectorQuery selectorQuery) {
        return PageResultUtils.result(selectorQuery.getPageParameter(), () -> this.selectorMapper.selectByQuery(selectorQuery).stream().map(SelectorVO::buildSelectorVO).collect(Collectors.toList()));
    }

    @Override
    public List<SelectorData> findByPluginIdAndNamespaceId(String pluginId, String namespaceId) {
        return this.buildSelectorDataList(this.selectorMapper.findByPluginIdAndNamespaceId(pluginId, namespaceId));
    }

    @Override
    public List<SelectorData> listAll() {
        return this.buildSelectorDataList(this.selectorMapper.selectAll());
    }

    @Override
    public List<SelectorData> listAllByNamespaceId(String namespaceId) {
        return this.buildSelectorDataList(this.selectorMapper.selectAllByNamespaceId(namespaceId));
    }

    @Override
    public List<SelectorVO> listAllData() {
        return this.buildSelectorExportVOList(this.selectorMapper.selectAll());
    }

    @Override
    public List<SelectorVO> listAllDataByNamespaceId(String namespaceId) {
        return this.buildSelectorExportVOList(this.selectorMapper.selectAllByNamespaceId(namespaceId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(List<SelectorDTO> selectorList) {
        if (CollectionUtils.isEmpty(selectorList)) {
            return ConfigImportResult.success();
        }
        StringBuilder errorMsgBuilder = new StringBuilder();
        int successCount = 0;
        Map<String, List<SelectorDO>> pluginSelectorMap = this.selectorMapper.selectAll().stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SelectorDO::getPluginId));
        Map<String, List<SelectorDTO>> importSelectorMap = selectorList.stream().collect(Collectors.groupingBy(SelectorDTO::getPluginId));
        for (Map.Entry<String, List<SelectorDTO>> selectorEntry : importSelectorMap.entrySet()) {
            String pluginId = selectorEntry.getKey();
            List<SelectorDTO> selectorDTOList = selectorEntry.getValue();
            if (!CollectionUtils.isNotEmpty(selectorDTOList)) continue;
            Set existSelectorSet = Optional.ofNullable(pluginSelectorMap.get(pluginId)).orElseGet(Lists::newArrayList).stream().map(SelectorDO::getSelectorName).collect(Collectors.toSet());
            for (SelectorDTO selectorDTO : selectorDTOList) {
                String selectorName = selectorDTO.getName();
                if (CollectionUtils.isNotEmpty(existSelectorSet) && existSelectorSet.contains(selectorName)) {
                    errorMsgBuilder.append(selectorName).append(",");
                    continue;
                }
                this.create(selectorDTO);
                ++successCount;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail selector: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(String namespace, List<SelectorDTO> selectorList, ConfigsImportContext context) {
        if (CollectionUtils.isEmpty(selectorList)) {
            return ConfigImportResult.success();
        }
        Map<String, String> selectorIdMapping = context.getSelectorIdMapping();
        StringBuilder errorMsgBuilder = new StringBuilder();
        int successCount = 0;
        Map<String, List<SelectorDO>> pluginSelectorMap = this.selectorMapper.selectAllByNamespaceId(namespace).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SelectorDO::getPluginId));
        Map<String, List<SelectorDTO>> importSelectorMap = selectorList.stream().collect(Collectors.groupingBy(SelectorDTO::getPluginId));
        for (Map.Entry<String, List<SelectorDTO>> selectorEntry : importSelectorMap.entrySet()) {
            String pluginId = context.getPluginTemplateIdMapping().get(selectorEntry.getKey());
            List<SelectorDTO> selectorDTOList = selectorEntry.getValue();
            if (!CollectionUtils.isNotEmpty(selectorDTOList)) continue;
            Map<String, String> existSelectorSet = Optional.ofNullable(pluginSelectorMap.get(pluginId)).orElseGet(Lists::newArrayList).stream().collect(Collectors.toMap(SelectorDO::getSelectorName, BaseDO::getId));
            for (SelectorDTO selectorDTO : selectorDTOList) {
                String selectorName = selectorDTO.getName();
                if (MapUtils.isNotEmpty(existSelectorSet) && existSelectorSet.containsKey(selectorName)) {
                    errorMsgBuilder.append(selectorName).append(",");
                    selectorIdMapping.put(selectorDTO.getId(), existSelectorSet.get(selectorName));
                    continue;
                }
                String selectorId = UUIDUtils.getInstance().generateShortUuid();
                selectorIdMapping.put(selectorDTO.getId(), selectorId);
                selectorDTO.setId(selectorId);
                selectorDTO.setNamespaceId(namespace);
                selectorDTO.setPluginId(pluginId);
                Optional.ofNullable(selectorDTO.getSelectorConditions()).orElse(Collections.emptyList()).forEach(c -> {
                    c.setSelectorId(selectorId);
                    c.setId(null);
                });
                this.create(selectorDTO);
                ++successCount;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail selector: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean enabledByIdsAndNamespaceId(List<String> ids, Boolean enabled, String namespaceId) {
        ids.forEach(id -> {
            SelectorDO selectorDO = this.selectorMapper.selectById((String)id);
            SelectorDO before = (SelectorDO)JsonUtils.jsonToObject((String)JsonUtils.toJson((Object)selectorDO), SelectorDO.class);
            selectorDO.setEnabled(enabled);
            if (this.selectorMapper.updateEnable((String)id, enabled) > 0) {
                List<SelectorConditionDO> conditionList = this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId()));
                List<SelectorConditionDTO> selectorConditions = conditionList.stream().map(item -> {
                    SelectorConditionDTO selectorConditionDTO = new SelectorConditionDTO();
                    selectorConditionDTO.setId(item.getId());
                    selectorConditionDTO.setSelectorId(item.getSelectorId());
                    selectorConditionDTO.setParamType(item.getParamType());
                    selectorConditionDTO.setOperator(item.getOperator());
                    selectorConditionDTO.setParamName(item.getParamName());
                    selectorConditionDTO.setParamValue(item.getParamValue());
                    return selectorConditionDTO;
                }).toList();
                this.publishEvent(selectorDO, selectorConditions, Collections.emptyList());
                this.selectorEventPublisher.onUpdated(selectorDO, before);
            }
        });
        return Boolean.TRUE;
    }

    @EventListener(value={BatchNamespacePluginDeletedEvent.class})
    public void onPluginDeleted(BatchNamespacePluginDeletedEvent event) {
        this.deleteSelector(this.selectorMapper.findByPluginIdsAndNamespaceId(event.getDeletedPluginIds(), event.getNamespaceId()), event.getPlugins());
    }

    private void createCondition(String selectorId, List<SelectorConditionDTO> selectorConditions) {
        for (SelectorConditionDTO condition : selectorConditions) {
            condition.setSelectorId(selectorId);
            this.selectorConditionMapper.insertSelective(SelectorConditionDO.buildSelectorConditionDO(condition));
        }
    }

    private int deleteSelector(List<SelectorDO> selectors, List<PluginDO> plugins) {
        if (CollectionUtils.isNotEmpty(selectors)) {
            List selectorIds = ListUtil.map(selectors, BaseDO::getId);
            int count = this.selectorMapper.deleteByIds(selectorIds);
            this.selectorConditionMapper.deleteBySelectorIds(selectorIds);
            if (count > 0) {
                this.selectorEventPublisher.onDeleted(selectors, plugins);
            }
            return count;
        }
        return selectors.size();
    }

    private void publishEvent(SelectorDO selectorDO, List<SelectorConditionDTO> selectorConditions, List<SelectorConditionDO> beforeSelectorCondition) {
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        List conditionDataList = ListUtil.map(selectorConditions, ConditionTransfer.INSTANCE::mapToSelectorDTO);
        List beforeConditionDataList = ListUtil.map(beforeSelectorCondition, ConditionTransfer.INSTANCE::mapToSelectorDO);
        SelectorData selectorData = SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList, beforeConditionDataList);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
    }

    private SelectorData buildSelectorData(SelectorDO selectorDO) {
        List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS(this.selectorConditionMapper.selectByQuery(new SelectorConditionQuery(selectorDO.getId())));
        PluginDO pluginDO = this.pluginMapper.selectById(selectorDO.getPluginId());
        if (Objects.isNull(pluginDO)) {
            return null;
        }
        return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
    }

    private List<SelectorData> buildSelectorDataList(List<SelectorDO> selectorDOList) {
        Map idMap = ListUtil.toMap(selectorDOList, BaseDO::getId, SelectorDO::getPluginId);
        if (MapUtils.isEmpty((Map)idMap)) {
            return new ArrayList<SelectorData>();
        }
        Map selectorConditionMap = ListUtil.groupBy(this.selectorConditionMapper.selectBySelectorIds(idMap.keySet()), SelectorConditionDO::getSelectorId);
        Map pluginDOMap = ListUtil.toMap(this.pluginMapper.selectByIds(Lists.newArrayList(idMap.values())), BaseDO::getId);
        return Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).map(selectorDO -> {
            String id = selectorDO.getId();
            String pluginId = selectorDO.getPluginId();
            PluginDO pluginDO = (PluginDO)pluginDOMap.get(pluginId);
            if (Objects.isNull(pluginDO)) {
                return null;
            }
            List<ConditionData> conditionDataList = ConditionTransfer.INSTANCE.mapToSelectorDOS((List)selectorConditionMap.get(id));
            return SelectorDO.transFrom(selectorDO, pluginDO.getName(), conditionDataList);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<SelectorVO> buildSelectorExportVOList(List<SelectorDO> selectorDOList) {
        Map idMap = ListUtil.toMap(selectorDOList, BaseDO::getId, SelectorDO::getPluginId);
        if (MapUtils.isEmpty((Map)idMap)) {
            return new ArrayList<SelectorVO>();
        }
        Map selectorConditionMap = ListUtil.groupBy(this.selectorConditionMapper.selectBySelectorIds(idMap.keySet()), SelectorConditionDO::getSelectorId);
        Map pluginDOMap = ListUtil.toMap(this.pluginMapper.selectByIds(Lists.newArrayList(idMap.values())), BaseDO::getId);
        return Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().filter(Objects::nonNull).map(selectorDO -> {
            String id = selectorDO.getId();
            String pluginId = selectorDO.getPluginId();
            PluginDO pluginDO = (PluginDO)pluginDOMap.get(pluginId);
            if (Objects.isNull(pluginDO)) {
                return null;
            }
            List<SelectorConditionVO> selectorConditionList = SelectorConditionVO.buildSelectorConditionVOList((List)selectorConditionMap.get(id));
            SelectorVO selectorExportVO = SelectorVO.buildSelectorVO(selectorDO);
            selectorExportVO.setSelectorConditions(selectorConditionList);
            return selectorExportVO;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

