/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamCompression;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.write.ChunkingIndex;

@Deprecated
public class NcStreamWriterChannel {
    private static final long maxChunk = 1000000L;
    private static final int sizeToCache = 100;
    private NetcdfFile ncfile;
    private NcStreamProto.Header header;
    private boolean show;

    public NcStreamWriterChannel(NetcdfFile ncfile, String location) throws IOException {
        this.ncfile = ncfile;
        NcStreamProto.Group.Builder rootBuilder = NcStream.encodeGroup(ncfile.getRootGroup(), 100);
        NcStreamProto.Header.Builder headerBuilder = NcStreamProto.Header.newBuilder();
        headerBuilder.setLocation(location == null ? ncfile.getLocation() : location);
        if (ncfile.getTitle() != null) {
            headerBuilder.setTitle(ncfile.getTitle());
        }
        if (ncfile.getId() != null) {
            headerBuilder.setId(ncfile.getId());
        }
        headerBuilder.setRoot(rootBuilder);
        this.header = headerBuilder.build();
    }

    public long sendStart(WritableByteChannel wbc) throws IOException {
        return this.writeBytes(wbc, NcStream.MAGIC_START);
    }

    public long sendEnd(WritableByteChannel wbc) throws IOException {
        return this.writeBytes(wbc, NcStream.MAGIC_END);
    }

    public long sendHeader(WritableByteChannel wbc) throws IOException {
        long size = 0L;
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_HEADER);
        byte[] b = this.header.toByteArray();
        size += (long)NcStream.writeVInt(wbc, b.length);
        if (this.show) {
            System.out.println("Write Header len=" + b.length);
        }
        size += (long)this.writeBytes(wbc, b);
        if (this.show) {
            System.out.println(" header size=" + size);
        }
        return size;
    }

    public long sendData(Variable v, Section section, WritableByteChannel wbc, NcStreamCompression compress) throws IOException, InvalidRangeException {
        if (this.show) {
            System.out.printf(" %s section=%s%n", v.getFullName(), section);
        }
        ByteOrder bo = ByteOrder.nativeOrder();
        long size = 0L;
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_DATA);
        NcStreamProto.Data dataProto = NcStream.encodeDataProto(v, section, compress.type, bo, 0);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt(wbc, datab.length);
        size += (long)this.writeBytes(wbc, datab);
        if (v.getDataType() == DataType.SEQUENCE) {
            assert (v instanceof Structure);
            int count = 0;
            try (DataOutputStream os = new DataOutputStream(Channels.newOutputStream(wbc));){
                Structure seq = (Structure)v;
                try (StructureDataIterator iter = seq.getStructureIterator(-1);){
                    while (iter.hasNext()) {
                        size += (long)this.writeBytes(wbc, NcStream.MAGIC_VDATA);
                        ArrayStructureBB abb = StructureDataDeep.copyToArrayBB(iter.next());
                        size += NcStream.encodeArrayStructure(abb, bo, os);
                        ++count;
                    }
                }
                size += (long)this.writeBytes(wbc, NcStream.MAGIC_VEND);
                if (this.show) {
                    System.out.printf(" NcStreamWriter sent %d sdata bytes = %d%n", count, size);
                }
                long l = size;
                return l;
            }
        }
        long len = section.computeSize();
        if (v.getDataType() != DataType.STRING && v.getDataType() != DataType.OPAQUE && !v.isVariableLength()) {
            len *= (long)v.getElementSize();
        }
        size += (long)NcStream.writeVInt(wbc, (int)len);
        if (this.show) {
            System.out.printf("  %s proto=%d data=%d%n", v.getFullName(), datab.length, len);
        }
        return size += v.readToByteChannel(section, wbc);
    }

    private int writeBytes(WritableByteChannel wbc, byte[] b) throws IOException {
        return wbc.write(ByteBuffer.wrap(b));
    }

    public long streamAll(WritableByteChannel wbc) throws IOException, InvalidRangeException {
        long size = this.writeBytes(wbc, NcStream.MAGIC_START);
        size += this.sendHeader(wbc);
        if (this.show) {
            System.out.printf(" data starts at= %d%n", size);
        }
        for (Variable v : this.ncfile.getVariables()) {
            NcStreamCompression compress;
            Attribute compressAtt = v.findAttribute("_Compress");
            if (compressAtt != null && compressAtt.isString()) {
                String compType = compressAtt.getStringValue();
                if (compType.equalsIgnoreCase("deflate")) {
                    compress = NcStreamCompression.deflate();
                } else {
                    if (this.show) {
                        System.out.printf(" Unknown compression type %s. Defaulting to none.%n", compType);
                    }
                    compress = NcStreamCompression.none();
                }
            } else {
                compress = NcStreamCompression.none();
            }
            long vsize = v.getSize() * (long)v.getElementSize();
            if (this.show) {
                System.out.printf(" var %s len=%d starts at= %d%n", v.getFullName(), vsize, size);
            }
            if (vsize > 1000000L) {
                size += this.copyChunks(wbc, v, 1000000L, compress);
                continue;
            }
            size += this.sendData(v, v.getShapeAsSection(), wbc, compress);
        }
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_END);
        if (this.show) {
            System.out.printf("total size= %d%n", size);
        }
        return size;
    }

    private long copyChunks(WritableByteChannel wbc, Variable oldVar, long maxChunkSize, NcStreamCompression compress) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        long size = 0L;
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                size += this.sendData(oldVar, new Section(chunkOrigin, chunkShape), wbc, compress);
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        return size;
    }

    public static void main2(String[] args) throws InvalidRangeException {
        int[] totalShape = new int[]{1, 40, 530, 240};
        int[] chunkShape = new int[]{1, 1, 530, 240};
        ChunkingIndex index = new ChunkingIndex(totalShape);
        while ((long)index.currentElement() < index.getSize()) {
            int[] chunkOrigin = index.getCurrentCounter();
            System.out.printf(" %s%n", new Section(chunkOrigin, chunkShape));
            index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
        }
    }
}

