/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import ucar.units.Base;
import ucar.units.NameException;
import ucar.units.RegularBaseQuantity;
import ucar.units.SupplementaryBaseQuantity;
import ucar.units.UnknownBaseQuantity;

public abstract class BaseQuantity
implements Base,
Comparable<BaseQuantity>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final RegularBaseQuantity AMOUNT_OF_SUBSTANCE = new RegularBaseQuantity("Amount of Substance", "N", true);
    public static final RegularBaseQuantity ELECTRIC_CURRENT = new RegularBaseQuantity("Electric Current", "I", true);
    public static final RegularBaseQuantity LENGTH = new RegularBaseQuantity("Length", "L", true);
    public static final RegularBaseQuantity LUMINOUS_INTENSITY = new RegularBaseQuantity("Luminous Intensity", "J", true);
    public static final RegularBaseQuantity MASS = new RegularBaseQuantity("Mass", "M", true);
    public static final SupplementaryBaseQuantity PLANE_ANGLE = new SupplementaryBaseQuantity("Plane Angle", null, true);
    public static final SupplementaryBaseQuantity SOLID_ANGLE = new SupplementaryBaseQuantity("Solid Angle", null, true);
    public static final RegularBaseQuantity THERMODYNAMIC_TEMPERATURE = new RegularBaseQuantity("Thermodynamic Temperature", "T", true);
    public static final RegularBaseQuantity TIME = new RegularBaseQuantity("Time", "t", true);
    public static final UnknownBaseQuantity UNKNOWN = new UnknownBaseQuantity();
    private final String name;
    private final String symbol;

    public BaseQuantity(String name, String symbol) throws NameException {
        this(name, symbol, true);
        if (name == null || name.length() == 0 || symbol != null && symbol.length() == 0) {
            throw new NameException("Invalid name or symbol");
        }
    }

    protected BaseQuantity(String name, String symbol, boolean trusted) {
        this.name = name;
        this.symbol = symbol;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public final String getID() {
        String id = this.getSymbol();
        return id == null ? this.getName() : id;
    }

    public final String toString() {
        return this.getID();
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof BaseQuantity && this.getName().equalsIgnoreCase(((BaseQuantity)object).getName()) && (this.getSymbol() == null || this.getSymbol().equals(((BaseQuantity)object).getSymbol()));
    }

    public int hashCode() {
        return this.getName().toLowerCase().hashCode() ^ (this.getSymbol() == null ? 0 : this.getSymbol().hashCode());
    }

    @Override
    public int compareTo(BaseQuantity that) {
        int comp;
        if (this == that) {
            comp = 0;
        } else {
            comp = this.getName().compareToIgnoreCase(that.getName());
            if (comp == 0 && this.getSymbol() != null) {
                comp = this.getSymbol().compareTo(that.getSymbol());
            }
        }
        return comp;
    }

    @Override
    public abstract boolean isDimensionless();
}

