/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.container;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerStartup;
import org.apache.rocketmq.broker.ConfigContext;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.container.BrokerBootHook;
import org.apache.rocketmq.container.BrokerContainer;
import org.apache.rocketmq.container.InnerBrokerController;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.AddBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetBrokerConfigResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.RemoveBrokerRequestHeader;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class BrokerContainerProcessor
implements NettyRequestProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected final BrokerContainer brokerContainer;
    protected List<BrokerBootHook> brokerBootHookList;
    protected final Set<String> configBlackList = new HashSet<String>();

    public BrokerContainerProcessor(BrokerContainer brokerContainer) {
        this.brokerContainer = brokerContainer;
        this.initConfigBlackList();
    }

    private void initConfigBlackList() {
        this.configBlackList.add("brokerConfigPaths");
        this.configBlackList.add("rocketmqHome");
        this.configBlackList.add("configBlackList");
        String[] configArray = this.brokerContainer.getBrokerContainerConfig().getConfigBlackList().split(";");
        this.configBlackList.addAll(Arrays.asList(configArray));
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        switch (request.getCode()) {
            case 902: {
                return this.addBroker(ctx, request);
            }
            case 903: {
                return this.removeBroker(ctx, request);
            }
            case 26: {
                return this.getBrokerConfig(ctx, request);
            }
            case 25: {
                return this.updateBrokerConfig(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    protected synchronized RemotingCommand addBroker(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        InnerBrokerController innerBrokerController;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        AddBrokerRequestHeader requestHeader = (AddBrokerRequestHeader)request.decodeCommandCustomHeader(AddBrokerRequestHeader.class);
        LOGGER.info("addBroker called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        Properties brokerProperties = null;
        String configPath = requestHeader.getConfigPath();
        if (configPath != null && !configPath.isEmpty()) {
            BrokerStartup.SystemConfigFileHelper configFileHelper = new BrokerStartup.SystemConfigFileHelper();
            configFileHelper.setFile(configPath);
            try {
                brokerProperties = configFileHelper.loadConfig();
            }
            catch (Exception e) {
                LOGGER.error("addBroker load config from {} failed, {}", (Object)configPath, (Object)e);
            }
        } else {
            LOGGER.error("addBroker config path is empty");
            response.setCode(1);
            response.setRemark("addBroker config path is empty");
            return response;
        }
        if (brokerProperties == null) {
            LOGGER.error("addBroker properties empty");
            response.setCode(1);
            response.setRemark("addBroker properties empty");
            return response;
        }
        BrokerConfig brokerConfig = new BrokerConfig();
        MessageStoreConfig messageStoreConfig = new MessageStoreConfig();
        AuthConfig authConfig = new AuthConfig();
        MixAll.properties2Object((Properties)brokerProperties, (Object)brokerConfig);
        MixAll.properties2Object((Properties)brokerProperties, (Object)messageStoreConfig);
        MixAll.properties2Object((Properties)brokerProperties, (Object)authConfig);
        messageStoreConfig.setHaListenPort(brokerConfig.getListenPort() + 1);
        brokerConfig.setBrokerConfigPath(configPath);
        if (!messageStoreConfig.isEnableDLegerCommitLog()) {
            if (!brokerConfig.isEnableControllerMode()) {
                switch (messageStoreConfig.getBrokerRole()) {
                    case ASYNC_MASTER: 
                    case SYNC_MASTER: {
                        brokerConfig.setBrokerId(0L);
                        break;
                    }
                    case SLAVE: {
                        if (brokerConfig.getBrokerId() > 0L) break;
                        response.setCode(1);
                        response.setRemark("slave broker id must be > 0");
                        return response;
                    }
                }
            }
            if (messageStoreConfig.getTotalReplicas() < messageStoreConfig.getInSyncReplicas() || messageStoreConfig.getTotalReplicas() < messageStoreConfig.getMinInSyncReplicas() || messageStoreConfig.getInSyncReplicas() < messageStoreConfig.getMinInSyncReplicas()) {
                response.setCode(1);
                response.setRemark("invalid replicas number");
                return response;
            }
        }
        ConfigContext configContext = new ConfigContext.Builder().brokerConfig(brokerConfig).messageStoreConfig(messageStoreConfig).authConfig(authConfig).properties(brokerProperties).build();
        try {
            innerBrokerController = this.brokerContainer.addBroker(configContext);
        }
        catch (Exception e) {
            LOGGER.error("addBroker exception", (Throwable)e);
            response.setCode(1);
            response.setRemark(e.getMessage());
            return response;
        }
        if (innerBrokerController != null) {
            innerBrokerController.getConfiguration().registerConfig(brokerProperties);
            try {
                for (BrokerBootHook brokerBootHook : this.brokerBootHookList) {
                    brokerBootHook.executeBeforeStart(innerBrokerController, brokerProperties);
                }
                innerBrokerController.start();
                for (BrokerBootHook brokerBootHook : this.brokerBootHookList) {
                    brokerBootHook.executeAfterStart(innerBrokerController, brokerProperties);
                }
            }
            catch (Exception e) {
                LOGGER.error("start broker exception", (Throwable)e);
                BrokerIdentity brokerIdentity = messageStoreConfig.isEnableDLegerCommitLog() ? new BrokerIdentity(brokerConfig.getBrokerClusterName(), brokerConfig.getBrokerName(), (long)Integer.parseInt(messageStoreConfig.getdLegerSelfId().substring(1))) : new BrokerIdentity(brokerConfig.getBrokerClusterName(), brokerConfig.getBrokerName(), brokerConfig.getBrokerId());
                this.brokerContainer.removeBroker(brokerIdentity);
                innerBrokerController.shutdown();
                response.setCode(1);
                response.setRemark("start broker failed" + e);
                return response;
            }
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(1);
            response.setRemark("add broker return null");
        }
        return response;
    }

    protected synchronized RemotingCommand removeBroker(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        BrokerController brokerController;
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        RemoveBrokerRequestHeader requestHeader = (RemoveBrokerRequestHeader)request.decodeCommandCustomHeader(RemoveBrokerRequestHeader.class);
        LOGGER.info("removeBroker called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        BrokerIdentity brokerIdentity = new BrokerIdentity(requestHeader.getBrokerClusterName(), requestHeader.getBrokerName(), requestHeader.getBrokerId().longValue());
        try {
            brokerController = this.brokerContainer.removeBroker(brokerIdentity);
        }
        catch (Exception e) {
            response.setCode(1);
            response.setRemark(e.getMessage());
            return response;
        }
        if (brokerController != null) {
            response.setCode(0);
            response.setRemark(null);
        } else {
            response.setCode(211);
            response.setRemark("Broker not exist");
        }
        return response;
    }

    public void registerBrokerBootHook(List<BrokerBootHook> brokerBootHookList) {
        this.brokerBootHookList = brokerBootHookList;
    }

    private RemotingCommand updateBrokerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        LOGGER.info("updateSharedBrokerConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        byte[] body = request.getBody();
        if (body != null) {
            try {
                String bodyStr = new String(body, "UTF-8");
                Properties properties = MixAll.string2Properties((String)bodyStr);
                if (properties == null) {
                    LOGGER.error("string2Properties error");
                    response.setCode(1);
                    response.setRemark("string2Properties error");
                    return response;
                }
                if (this.validateBlackListConfigExist(properties)) {
                    response.setCode(16);
                    response.setRemark("Can not update config in black list.");
                    return response;
                }
                LOGGER.info("updateBrokerContainerConfig, new config: [{}] client: {} ", (Object)properties, (Object)ctx.channel().remoteAddress());
                this.brokerContainer.getConfiguration().update(properties);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private boolean validateBlackListConfigExist(Properties properties) {
        for (String blackConfig : this.configBlackList) {
            if (!properties.containsKey(blackConfig)) continue;
            return true;
        }
        return false;
    }

    private RemotingCommand getBrokerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetBrokerConfigResponseHeader.class);
        GetBrokerConfigResponseHeader responseHeader = (GetBrokerConfigResponseHeader)response.readCustomHeader();
        String content = this.brokerContainer.getConfiguration().getAllConfigsFormatString();
        if (content != null && content.length() > 0) {
            try {
                content = MixAll.adjustConfigForPlatform((String)content);
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        responseHeader.setVersion(this.brokerContainer.getConfiguration().getDataVersionJson());
        response.setCode(0);
        response.setRemark(null);
        return response;
    }
}

