/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.protocol.http2proxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class Http2ProxyFrontendHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    public static final String HANDLER_NAME = "SslHandler";
    private final Channel outboundChannel;
    private final SslHandler sslHandler;

    public Http2ProxyFrontendHandler(Channel outboundChannel, SslHandler sslHandler) {
        this.outboundChannel = outboundChannel;
        this.sslHandler = sslHandler;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.outboundChannel.isActive()) {
            if (this.sslHandler != null && this.outboundChannel.pipeline().get(HANDLER_NAME) == null) {
                this.outboundChannel.pipeline().addBefore("Http2ProxyBackendHandler", HANDLER_NAME, (ChannelHandler)this.sslHandler);
            }
            this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            }));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            Http2ProxyFrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("Http2ProxyFrontendHandler#exceptionCaught", cause);
        Http2ProxyFrontendHandler.closeOnFlush(ctx.channel());
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

