/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v2;

import com.alibaba.fastjson2.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.config.v2.ConfigHelper;
import org.apache.rocketmq.broker.config.v2.ConfigStorage;
import org.apache.rocketmq.broker.config.v2.RecordPrefix;
import org.apache.rocketmq.broker.config.v2.SerializationType;
import org.apache.rocketmq.broker.config.v2.TableId;
import org.apache.rocketmq.broker.config.v2.TablePrefix;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class TopicConfigManagerV2
extends TopicConfigManager {
    private final ConfigStorage configStorage;

    public TopicConfigManagerV2(BrokerController brokerController, ConfigStorage configStorage) {
        super(brokerController);
        this.configStorage = configStorage;
    }

    public boolean load() {
        return this.loadDataVersion() && this.loadTopicConfig();
    }

    @Override
    public boolean loadDataVersion() {
        try {
            ConfigHelper.loadDataVersion(this.configStorage, TableId.TOPIC).ifPresent(buf -> ConfigHelper.onDataVersionLoad(buf, this.dataVersion));
        }
        catch (RocksDBException e) {
            log.error("Failed to load data version of topic", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTopicConfig() {
        int keyLen = 4;
        ByteBuf beginKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        beginKey.writeByte((int)TablePrefix.TABLE.getValue());
        beginKey.writeShort((int)TableId.TOPIC.getValue());
        beginKey.writeByte((int)RecordPrefix.DATA.getValue());
        ByteBuf endKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        endKey.writeByte((int)TablePrefix.TABLE.getValue());
        endKey.writeShort((int)TableId.TOPIC.getValue());
        endKey.writeByte(RecordPrefix.DATA.getValue() + 1);
        try (RocksIterator iterator = this.configStorage.iterate(beginKey.nioBuffer(), endKey.nioBuffer());){
            while (iterator.isValid()) {
                byte[] value;
                byte[] key = iterator.key();
                TopicConfig topicConfig = this.parseTopicConfig(key, value = iterator.value());
                if (null != topicConfig) {
                    super.putTopicConfig(topicConfig);
                }
                iterator.next();
            }
        }
        finally {
            beginKey.release();
            endKey.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicConfig parseTopicConfig(byte[] key, byte[] value) {
        ByteBuf keyBuf = Unpooled.wrappedBuffer((byte[])key);
        ByteBuf valueBuf = Unpooled.wrappedBuffer((byte[])value);
        try {
            keyBuf.readerIndex(4);
            short topicLen = keyBuf.readShort();
            assert (topicLen == keyBuf.readableBytes());
            CharSequence topic = keyBuf.readCharSequence((int)topicLen, StandardCharsets.UTF_8);
            assert (null != topic);
            byte serializationType = valueBuf.readByte();
            if (SerializationType.JSON == SerializationType.valueOf(serializationType)) {
                CharSequence json = valueBuf.readCharSequence(valueBuf.readableBytes(), StandardCharsets.UTF_8);
                TopicConfig topicConfig = (TopicConfig)JSON.parseObject((String)json.toString(), TopicConfig.class);
                assert (topicConfig != null);
                assert (topic.equals(topicConfig.getTopicName()));
                TopicConfig topicConfig2 = topicConfig;
                return topicConfig2;
            }
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
        return null;
    }

    public synchronized void persist() {
        try {
            this.configStorage.flushWAL();
        }
        catch (RocksDBException e) {
            log.error("Failed to flush WAL", (Throwable)e);
        }
    }

    @Override
    public TopicConfig selectTopicConfig(String topic) {
        if (MixAll.isLmq((String)topic)) {
            return this.simpleLmqTopicConfig(topic);
        }
        return super.selectTopicConfig(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopicConfig(TopicConfig topicConfig) {
        if (topicConfig == null || MixAll.isLmq((String)topicConfig.getTopicName())) {
            return;
        }
        super.updateSingleTopicConfigWithoutPersist(topicConfig);
        ByteBuf keyBuf = ConfigHelper.keyBufOf(TableId.TOPIC, topicConfig.getTopicName());
        ByteBuf valueBuf = ConfigHelper.valueBufOf(topicConfig, SerializationType.JSON);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.put(keyBuf.nioBuffer(), valueBuf.nioBuffer());
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.TOPIC, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
            this.persist();
        }
        catch (RocksDBException e) {
            log.error("Failed to update topic config", (Throwable)e);
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TopicConfig removeTopicConfig(String topicName) {
        ByteBuf keyBuf = ConfigHelper.keyBufOf(TableId.TOPIC, topicName);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.delete(keyBuf.nioBuffer());
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.TOPIC, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
        }
        catch (RocksDBException e) {
            log.error("Failed to delete topic config by topicName={}", (Object)topicName, (Object)e);
        }
        finally {
            keyBuf.release();
        }
        return super.removeTopicConfig(topicName);
    }

    @Override
    public boolean containsTopic(String topic) {
        if (MixAll.isLmq((String)topic)) {
            return true;
        }
        return super.containsTopic(topic);
    }

    private TopicConfig simpleLmqTopicConfig(String topic) {
        return new TopicConfig(topic, 1, 1, 6);
    }
}

