/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.monitor.ActionGroupPatchBody;
import com.microsoft.azure.management.monitor.EnableRequest;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.ActionGroupResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ActionGroupsInner
implements InnerSupportsGet<ActionGroupResourceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ActionGroupResourceInner> {
    private ActionGroupsService service;
    private MonitorManagementClientImpl client;

    public ActionGroupsInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (ActionGroupsService)retrofit.create(ActionGroupsService.class);
        this.client = client;
    }

    public ActionGroupResourceInner createOrUpdate(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return (ActionGroupResourceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroup).toBlocking().single()).body());
    }

    public ServiceFuture<ActionGroupResourceInner> createOrUpdateAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, ServiceCallback<ActionGroupResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroup), serviceCallback);
    }

    public Observable<ActionGroupResourceInner> createOrUpdateAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroup).map((Func1)new Func1<ServiceResponse<ActionGroupResourceInner>, ActionGroupResourceInner>(){

            public ActionGroupResourceInner call(ServiceResponse<ActionGroupResourceInner> response) {
                return (ActionGroupResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ActionGroupResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (actionGroup == null) {
            throw new IllegalArgumentException("Parameter actionGroup is required and cannot be null.");
        }
        Validator.validate((Object)((Object)actionGroup));
        String apiVersion = "2018-03-01";
        return this.service.createOrUpdate(resourceGroupName, actionGroupName, this.client.subscriptionId(), actionGroup, "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActionGroupResourceInner>>>(){

            public Observable<ServiceResponse<ActionGroupResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActionGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ActionGroupResourceInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ActionGroupResourceInner>(){}.getType()).register(201, new TypeToken<ActionGroupResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ActionGroupResourceInner getByResourceGroup(String resourceGroupName, String actionGroupName) {
        return (ActionGroupResourceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, actionGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName, ServiceCallback<ActionGroupResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, actionGroupName), serviceCallback);
    }

    public Observable<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, actionGroupName).map((Func1)new Func1<ServiceResponse<ActionGroupResourceInner>, ActionGroupResourceInner>(){

            public ActionGroupResourceInner call(ServiceResponse<ActionGroupResourceInner> response) {
                return (ActionGroupResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ActionGroupResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String actionGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.getByResourceGroup(resourceGroupName, actionGroupName, this.client.subscriptionId(), "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActionGroupResourceInner>>>(){

            public Observable<ServiceResponse<ActionGroupResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActionGroupsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ActionGroupResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ActionGroupResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String actionGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, actionGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String actionGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, actionGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String actionGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, actionGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String actionGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.delete(resourceGroupName, actionGroupName, this.client.subscriptionId(), "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActionGroupsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ActionGroupResourceInner update(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return (ActionGroupResourceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch).toBlocking().single()).body());
    }

    public ServiceFuture<ActionGroupResourceInner> updateAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, ServiceCallback<ActionGroupResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch), serviceCallback);
    }

    public Observable<ActionGroupResourceInner> updateAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return this.updateWithServiceResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch).map((Func1)new Func1<ServiceResponse<ActionGroupResourceInner>, ActionGroupResourceInner>(){

            public ActionGroupResourceInner call(ServiceResponse<ActionGroupResourceInner> response) {
                return (ActionGroupResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ActionGroupResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (actionGroupPatch == null) {
            throw new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null.");
        }
        Validator.validate((Object)actionGroupPatch);
        String apiVersion = "2018-03-01";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, actionGroupName, "2018-03-01", actionGroupPatch, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ActionGroupResourceInner>>>(){

            public Observable<ServiceResponse<ActionGroupResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActionGroupsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ActionGroupResourceInner> updateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ActionGroupResourceInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ActionGroupResourceInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ActionGroupResourceInner>(page){

            public Page<ActionGroupResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ActionGroupResourceInner>> listAsync(ServiceCallback<List<ActionGroupResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<ActionGroupResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<ActionGroupResourceInner>>, Page<ActionGroupResourceInner>>(){

            public Page<ActionGroupResourceInner> call(ServiceResponse<List<ActionGroupResourceInner>> response) {
                PageImpl1<ActionGroupResourceInner> page = new PageImpl1<ActionGroupResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ActionGroupResourceInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.list(this.client.subscriptionId(), "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ActionGroupResourceInner>>>>(){

            public Observable<ServiceResponse<List<ActionGroupResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ActionGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ActionGroupResourceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ActionGroupResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ActionGroupResourceInner>(page){

            public Page<ActionGroupResourceInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ActionGroupResourceInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<ActionGroupResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<ActionGroupResourceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<ActionGroupResourceInner>>, Page<ActionGroupResourceInner>>(){

            public Page<ActionGroupResourceInner> call(ServiceResponse<List<ActionGroupResourceInner>> response) {
                PageImpl1<ActionGroupResourceInner> page = new PageImpl1<ActionGroupResourceInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ActionGroupResourceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ActionGroupResourceInner>>>>(){

            public Observable<ServiceResponse<List<ActionGroupResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ActionGroupsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ActionGroupResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ActionGroupResourceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void enableReceiver(String resourceGroupName, String actionGroupName, String receiverName) {
        ((ServiceResponse)this.enableReceiverWithServiceResponseAsync(resourceGroupName, actionGroupName, receiverName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, String receiverName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.enableReceiverWithServiceResponseAsync(resourceGroupName, actionGroupName, receiverName), serviceCallback);
    }

    public Observable<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, String receiverName) {
        return this.enableReceiverWithServiceResponseAsync(resourceGroupName, actionGroupName, receiverName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> enableReceiverWithServiceResponseAsync(String resourceGroupName, String actionGroupName, String receiverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (actionGroupName == null) {
            throw new IllegalArgumentException("Parameter actionGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (receiverName == null) {
            throw new IllegalArgumentException("Parameter receiverName is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        EnableRequest enableRequest = new EnableRequest();
        enableRequest.withReceiverName(receiverName);
        return this.service.enableReceiver(resourceGroupName, actionGroupName, this.client.subscriptionId(), "2018-03-01", this.client.acceptLanguage(), enableRequest, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ActionGroupsInner.this.enableReceiverDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> enableReceiverDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ActionGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="actionGroupName") String var2, @Path(value="subscriptionId") String var3, @Body ActionGroupResourceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="actionGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="actionGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="actionGroupName") String var3, @Query(value="api-version") String var4, @Body ActionGroupPatchBody var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups list"})
        @GET(value="subscriptions/{subscriptionId}/providers/microsoft.insights/actionGroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.ActionGroups enableReceiver"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/actionGroups/{actionGroupName}/subscribe")
        public Observable<Response<ResponseBody>> enableReceiver(@Path(value="resourceGroupName") String var1, @Path(value="actionGroupName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body EnableRequest var6, @Header(value="User-Agent") String var7);
    }
}

