/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.engine.DeliveryTagGenerator;
import org.apache.qpid.protonj2.engine.impl.ProtonPooledTagGenerator;
import org.apache.qpid.protonj2.engine.impl.ProtonSequentialTagGenerator;
import org.apache.qpid.protonj2.engine.impl.ProtonUuidTagGenerator;
import org.apache.qpid.protonj2.types.DeliveryTag;

public abstract class ProtonDeliveryTagGenerator
implements DeliveryTagGenerator {
    private static final ProtonEmptyTagGenerator EMPTY_TAG_GENERATOR = new ProtonEmptyTagGenerator();

    private static final class ProtonEmptyTagGenerator
    implements DeliveryTagGenerator {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private static final DeliveryTag EMPTY_DELIVERY_TAG = new DeliveryTag.ProtonDeliveryTag(EMPTY_BYTE_ARRAY);

        private ProtonEmptyTagGenerator() {
        }

        @Override
        public DeliveryTag nextTag() {
            return EMPTY_DELIVERY_TAG;
        }
    }

    public static enum BUILTIN {
        SEQUENTIAL{

            @Override
            public DeliveryTagGenerator createGenerator() {
                return new ProtonSequentialTagGenerator();
            }
        }
        ,
        UUID{

            @Override
            public DeliveryTagGenerator createGenerator() {
                return new ProtonUuidTagGenerator();
            }
        }
        ,
        POOLED{

            @Override
            public DeliveryTagGenerator createGenerator() {
                return new ProtonPooledTagGenerator();
            }
        }
        ,
        EMPTY{

            @Override
            public DeliveryTagGenerator createGenerator() {
                return EMPTY_TAG_GENERATOR;
            }
        };


        public abstract DeliveryTagGenerator createGenerator();
    }
}

