/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.utilint.JVMSystemUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

class JvmStats {
    private final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private final String GROUPNAME = "Jvm";
    private final String GROUPDEF = "Statistics capture jvm statistics.";
    private final String GC_COUNT_DESC = "GC collection count.";
    private final String GC_COLLECTION_TIME_DESC = "GC collection time.";
    private final String GC_COUNT_NAME_SUFFIX = ".count";
    private final String GC_TIME_NAME_SUFFIX = ".time";
    public static final StatDefinition LOAD_AVERAGE = new StatDefinition("loadAverage", "Average JVM system load.", StatDefinition.StatType.CUMULATIVE);
    public static final StatDefinition HEAP_MEMORY_USAGE = new StatDefinition("heap", "Heap memory usage.", StatDefinition.StatType.CUMULATIVE);
    private StatGroup prev = null;
    private final Map<String, StatDefinition> statdefmap = new HashMap<String, StatDefinition>();

    public JvmStats() {
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            String name = gcBean.getName();
            String statname = name + ".count";
            StatDefinition sd = new StatDefinition(statname, "GC collection count.");
            this.statdefmap.put(statname, sd);
            statname = name + ".time";
            sd = new StatDefinition(statname, "GC collection time.");
            this.statdefmap.put(statname, sd);
        }
        this.statdefmap.put(LOAD_AVERAGE.getName(), LOAD_AVERAGE);
        this.statdefmap.put(HEAP_MEMORY_USAGE.getName(), HEAP_MEMORY_USAGE);
    }

    public StatGroup loadStats(StatsConfig sc) {
        StatGroup sg = new StatGroup("Jvm", "Statistics capture jvm statistics.");
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            String name = gcBean.getName();
            String statname = name + ".count";
            new LongStat(sg, this.statdefmap.get(statname), gcBean.getCollectionCount());
            statname = name + ".time";
            new LongStat(sg, this.statdefmap.get(statname), gcBean.getCollectionTime());
        }
        new LongStat(sg, LOAD_AVERAGE, (long)JVMSystemUtils.getSystemLoad());
        new LongStat(sg, HEAP_MEMORY_USAGE, this.memoryBean.getHeapMemoryUsage().getUsed());
        StatGroup retgroup = this.prev != null ? sg.computeInterval(this.prev) : sg;
        this.prev = sg;
        return retgroup;
    }

    public void addVMStatDefs(SortedSet<String> projections) {
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            projections.add("Jvm:" + gcBean.getName() + ".count");
            projections.add("Jvm:" + gcBean.getName() + ".time");
        }
        projections.add("Jvm:" + LOAD_AVERAGE.getName());
        projections.add("Jvm:" + HEAP_MEMORY_USAGE.getName());
    }
}

