# interleaveAll

Emits a specifiable number of elements from the original source, then from the provided sources and repeats.

@ref[Fan-in operators](../index.md#fan-in-operators)

## Signature

@apidoc[Source.interleaveAll](Source) { scala="#interleaveAll[U&gt;:Out](that:List[org.apache.pekko.stream.Graph[org.apache.pekko.stream.SourceShape[U],_]],segmentSize:Int,eagerClose:Boolean):FlowOps.this.Repr[U]" java="#interleaveAll(java.util.List[org.apache.pekko.stream.Graph],int,boolean)" }
@apidoc[Flow.interleaveAll](Flow) { scala="#interleaveAll[U&gt;:Out](that:List[org.apache.pekko.stream.Graph[org.apache.pekko.stream.SourceShape[U],_]],segmentSize:Int,eagerClose:Boolean):FlowOps.this.Repr[U]" java="#interleaveAll(java.util.List[org.apache.pekko.stream.Graph],int,boolean)" }


## Description

Emits a specifiable number of elements from the original source, then from the provided sources and repeats.
If one source completes the rest of the other stream will be emitted when `eagerClose` is false, otherwise 
the flow is complete.

## Example
Scala
:   @@snip [FlowInterleaveSpec.scala](/stream-tests/src/test/scala/org/apache/pekko/stream/scaladsl/FlowInterleaveAllSpec.scala) { #interleaveAll }

Java
:   @@snip [SourceOrFlow.java](/docs/src/test/java/jdocs/stream/operators/SourceOrFlow.java) { #interleaveAll }

## Reactive Streams semantics

@@@div { .callout }

**emits** when element is available from the currently consumed upstream

**backpressures** when upstream backpressures

**completes** when all upstreams have completed if `eagerClose` is false, or any upstream completes if `eagerClose` is true.

@@@
