/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.ldb;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.debug.DBDefinitionFactory;
import org.apache.hadoop.ozone.debug.ldb.RDBParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="value-schema", description={"Schema of value in metadataTable"})
public class ValueSchema
extends AbstractSubcommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private RDBParser parent;
    private static final Logger LOG = LoggerFactory.getLogger(ValueSchema.class);
    @CommandLine.Option(names={"--column_family", "--column-family", "--cf"}, required=true, description={"Table name"})
    private String tableName;
    @CommandLine.Option(names={"--dnSchema", "--dn-schema", "-d"}, description={"Datanode DB Schema Version: V1/V2/V3"}, defaultValue="V3")
    private String dnDBSchemaVersion;
    @CommandLine.Option(names={"--depth"}, description={"The level till which the value-schema should be shown. Values in the range [0-10] are allowed)"}, defaultValue="10")
    private int depth;

    @Override
    public Void call() throws Exception {
        if (this.depth < 0 || this.depth > 10) {
            throw new IOException("depth should be specified in the range [0, 10]");
        }
        boolean success = true;
        String dbPath = this.parent.getDbPath();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        success = this.getValueFields(dbPath, fields);
        this.out().println(JsonUtils.toJsonStringWithDefaultPrettyPrinter(fields));
        if (!success) {
            throw new Exception("Exit code is non-zero. Check the error message above");
        }
        return null;
    }

    public boolean getValueFields(String dbPath, Map<String, Object> valueSchema) {
        dbPath = ValueSchema.removeTrailingSlashIfNeeded(dbPath);
        DBDefinitionFactory.setDnDBSchemaVersion(this.dnDBSchemaVersion);
        DBDefinition dbDefinition = DBDefinitionFactory.getDefinition(Paths.get(dbPath, new String[0]), (ConfigurationSource)new OzoneConfiguration());
        if (dbDefinition == null) {
            this.err().println("Error: Incorrect DB Path");
            return false;
        }
        DBColumnFamilyDefinition columnFamilyDefinition = dbDefinition.getColumnFamily(this.tableName);
        if (columnFamilyDefinition == null) {
            this.err().print("Error: Table with name '" + this.tableName + "' not found");
            return false;
        }
        Class c = columnFamilyDefinition.getValueType();
        valueSchema.put(c.getSimpleName(), ValueSchema.getFieldsStructure(c, this.depth));
        return true;
    }

    private static Object getFieldsStructure(Class<?> clazz, int currentDepth) {
        if (clazz.isPrimitive() || String.class.equals(clazz)) {
            return clazz.getSimpleName();
        }
        if (currentDepth == 0) {
            return "struct";
        }
        HashMap<String, Object> finalFields = new HashMap<String, Object>();
        List<Field> clazzFields = ValueSchema.getAllFields(clazz);
        for (Field field : clazzFields) {
            Class<Object> fieldClass;
            try {
                fieldClass = Collection.class.isAssignableFrom(field.getType()) ? (Class<Object>)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] : field.getType();
            }
            catch (ClassCastException ex) {
                fieldClass = field.getType();
            }
            finalFields.put(field.getName(), ValueSchema.getFieldsStructure(fieldClass, currentDepth - 1));
        }
        return finalFields;
    }

    public static List<Field> getAllFields(Class clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(ValueSchema.getAllFields(clazz.getSuperclass()));
        List filteredFields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).collect(Collectors.toList());
        result.addAll(filteredFields);
        return result;
    }

    private static String removeTrailingSlashIfNeeded(String dbPath) {
        if (dbPath.endsWith("/")) {
            dbPath = dbPath.substring(0, dbPath.length() - 1);
        }
        return dbPath;
    }
}

