/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.cli.DebugSubcommand;
import org.apache.hadoop.hdds.utils.NativeLibraryLoader;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksObjectUtils;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.util.NativeCodeLoader;
import picocli.CommandLine;

@CommandLine.Command(name="checknative", description={"Checks if native libraries are loaded"})
public class CheckNative
extends AbstractSubcommand
implements Callable<Void>,
DebugSubcommand {
    @Override
    public Void call() throws Exception {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        results.put("hadoop", CheckNative.checkLibrary(NativeCodeLoader.isNativeCodeLoaded(), NativeCodeLoader::getLibraryName));
        results.put("ISA-L", CheckNative.checkLibrary(ErasureCodeNative.getLoadingFailureReason(), ErasureCodeNative::getLibraryName));
        results.put("OpenSSL", CheckNative.checkLibrary(NativeCodeLoader.isNativeCodeLoaded() ? OpensslCipher.getLoadingFailureReason() : "", OpensslCipher::getLibraryName));
        ManagedRocksObjectUtils.loadRocksDBLibrary();
        NativeLibraryLoader.getInstance().loadLibrary("ozone_rocksdb_tools", Collections.singletonList(ManagedRocksObjectUtils.getRocksDBLibFileName()));
        results.put("rocks-tools", CheckNative.checkLibrary(NativeLibraryLoader.isLibraryLoaded((String)"ozone_rocksdb_tools"), NativeLibraryLoader::getJniLibraryFileName));
        int maxLength = results.keySet().stream().mapToInt(String::length).max().getAsInt();
        this.out().println("Native library checking:");
        results.forEach((name, result) -> this.out().printf("%" + maxLength + "s:  %s%n", name, result));
        return null;
    }

    private static Object checkLibrary(boolean loaded, Supplier<String> libraryName) {
        return CheckNative.checkLibrary(loaded ? null : "", libraryName);
    }

    private static Object checkLibrary(String failureReason, Supplier<String> libraryName) {
        boolean loaded = failureReason == null;
        String detail = loaded ? libraryName.get() : failureReason;
        return String.format("%-5b  %s", loaded, detail);
    }
}

