/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;

@InterfaceAudience.Private
@Metrics(about="Container Replication Supervisor Metrics", context="ozone")
public class ReplicationSupervisorMetrics
implements MetricsSource {
    public static final String SOURCE = ReplicationSupervisorMetrics.class.getSimpleName();
    private final ReplicationSupervisor supervisor;

    public ReplicationSupervisorMetrics(ReplicationSupervisor replicationSupervisor) {
        this.supervisor = replicationSupervisor;
    }

    public static ReplicationSupervisorMetrics create(ReplicationSupervisor supervisor) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ReplicationSupervisorMetrics)ms.register(SOURCE, "Container Replication Supervisor Metrics", (Object)new ReplicationSupervisorMetrics(supervisor));
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(SOURCE);
        builder.addGauge(Interns.info((String)"numInFlightReplications", (String)"Total number of pending replications and reconstructions both low and normal priority"), this.supervisor.getTotalInFlightReplications()).addGauge(Interns.info((String)"numQueuedReplications", (String)"Number of replications in queue"), this.supervisor.getReplicationQueuedCount()).addGauge(Interns.info((String)"numRequestedReplications", (String)"Number of requested replications"), this.supervisor.getReplicationRequestCount()).addGauge(Interns.info((String)"numSuccessReplications", (String)"Number of successful replications"), this.supervisor.getReplicationSuccessCount()).addGauge(Interns.info((String)"numFailureReplications", (String)"Number of failure replications"), this.supervisor.getReplicationFailureCount()).addGauge(Interns.info((String)"numTimeoutReplications", (String)"Number of replication requests timed out before being processed"), this.supervisor.getReplicationTimeoutCount()).addGauge(Interns.info((String)"numSkippedReplications", (String)"Number of replication requests skipped as the container is already present"), this.supervisor.getReplicationSkippedCount()).addGauge(Interns.info((String)"maxReplicationStreams", (String)"Maximum number of concurrent replication tasks which can run simultaneously"), this.supervisor.getMaxReplicationStreams());
        Map<String, String> metricsMap = ReplicationSupervisor.getMetricsMap();
        if (!metricsMap.isEmpty()) {
            metricsMap.forEach((metricsName, descriptionSegment) -> {
                if (!metricsName.equals("")) {
                    builder.addGauge(Interns.info((String)("numRequested" + metricsName), (String)("Number of requested " + descriptionSegment)), this.supervisor.getReplicationRequestCount((String)metricsName)).addGauge(Interns.info((String)("numSuccess" + metricsName), (String)("Number of successful " + descriptionSegment)), this.supervisor.getReplicationSuccessCount((String)metricsName)).addGauge(Interns.info((String)("numFailure" + metricsName), (String)("Number of failure " + descriptionSegment)), this.supervisor.getReplicationFailureCount((String)metricsName)).addGauge(Interns.info((String)("numTimeout" + metricsName), (String)("Number of " + descriptionSegment + " timed out before being processed")), this.supervisor.getReplicationTimeoutCount((String)metricsName)).addGauge(Interns.info((String)("numSkipped" + metricsName), (String)("Number of " + descriptionSegment + " skipped as the container is already present")), this.supervisor.getReplicationSkippedCount((String)metricsName)).addGauge(Interns.info((String)("numQueued" + metricsName), (String)("Number of " + descriptionSegment + " in queue")), this.supervisor.getReplicationQueuedCount((String)metricsName));
                }
            });
        }
        Map<String, Integer> tasks = this.supervisor.getInFlightReplicationSummary();
        for (Map.Entry<String, Integer> entry : tasks.entrySet()) {
            builder.addGauge(Interns.info((String)("numInflight" + entry.getKey()), (String)("Number of normal priority" + entry.getKey() + " tasks pending")), entry.getValue().intValue());
        }
    }
}

