/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractBackgroundContainerScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerMetadataScannerMetrics;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScanHelper;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScannerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundContainerMetadataScanner
extends AbstractBackgroundContainerScanner {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundContainerMetadataScanner.class);
    private final ContainerMetadataScannerMetrics metrics;
    private final ContainerController controller;
    private final ContainerScanHelper scanHelper;

    public BackgroundContainerMetadataScanner(ContainerScannerConfiguration conf, ContainerController controller) {
        super("ContainerMetadataScanner", conf.getMetadataScanInterval());
        this.controller = controller;
        this.metrics = ContainerMetadataScannerMetrics.create();
        this.scanHelper = ContainerScanHelper.withScanGap(LOG, controller, this.metrics, conf);
    }

    @Override
    public Iterator<Container<?>> getContainerIterator() {
        return this.controller.getContainers().iterator();
    }

    @Override
    @VisibleForTesting
    public void scanContainer(Container<?> container) throws IOException, InterruptedException {
        this.scanHelper.scanMetadata(container);
    }

    @Override
    public ContainerMetadataScannerMetrics getMetrics() {
        return this.metrics;
    }
}

