/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.ozone.container.metadata.AbstractRDBStore;
import org.apache.hadoop.ozone.container.metadata.ContainerCreateInfo;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerDBDefinition;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerMetadataStore;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;

public final class WitnessedContainerMetadataStoreImpl
extends AbstractRDBStore<WitnessedContainerDBDefinition>
implements WitnessedContainerMetadataStore {
    private Table<ContainerID, ContainerCreateInfo> containerCreateInfoTable;
    private PreviousVersionTables previousVersionTables;
    private static final ConcurrentMap<String, WitnessedContainerMetadataStore> INSTANCES = new ConcurrentHashMap<String, WitnessedContainerMetadataStore>();

    public static WitnessedContainerMetadataStore get(ConfigurationSource conf) throws IOException {
        String dbDirPath = DBStoreBuilder.getDBDirPath((DBDefinition)WitnessedContainerDBDefinition.get(), (ConfigurationSource)conf).getAbsolutePath();
        try {
            return INSTANCES.compute(dbDirPath, (k, v) -> {
                if (v == null || v.isClosed()) {
                    try {
                        return new WitnessedContainerMetadataStoreImpl(conf, false);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return v;
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private WitnessedContainerMetadataStoreImpl(ConfigurationSource config, boolean openReadOnly) throws RocksDatabaseException, CodecException {
        super(WitnessedContainerDBDefinition.get(), config, openReadOnly);
    }

    @Override
    protected DBStore initDBStore(DBStoreBuilder dbStoreBuilder, ManagedDBOptions options, ConfigurationSource config) throws RocksDatabaseException, CodecException {
        this.previousVersionTables = new PreviousVersionTables();
        this.previousVersionTables.addTables(dbStoreBuilder);
        RDBStore dbStore = dbStoreBuilder.build();
        this.previousVersionTables.init((DBStore)dbStore);
        this.containerCreateInfoTable = ((WitnessedContainerDBDefinition)((Object)this.getDbDef())).getContainerCreateInfoTableDef().getTable((DBStore)dbStore);
        return dbStore;
    }

    @Override
    public Table<ContainerID, ContainerCreateInfo> getContainerCreateInfoTable() {
        if (!VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.WITNESSED_CONTAINER_DB_PROTO_VALUE)) {
            return this.previousVersionTables.getContainerIdsTable();
        }
        return this.containerCreateInfoTable;
    }

    public PreviousVersionTables getPreviousVersionTables() {
        return this.previousVersionTables;
    }

    public static class PreviousVersionTables {
        private static final String CONTAINER_IDS_STR_VAL_TABLE = "containerIds";
        private Table<ContainerID, ContainerCreateInfo> containerIdsTable;

        public void addTables(DBStoreBuilder dbStoreBuilder) {
            if (!VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.WITNESSED_CONTAINER_DB_PROTO_VALUE)) {
                dbStoreBuilder.addTable(CONTAINER_IDS_STR_VAL_TABLE);
            }
        }

        public void init(DBStore dbStore) throws RocksDatabaseException, CodecException {
            if (!VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.WITNESSED_CONTAINER_DB_PROTO_VALUE)) {
                this.containerIdsTable = dbStore.getTable(CONTAINER_IDS_STR_VAL_TABLE, ContainerID.getCodec(), (Codec)new DelegatedCodec((Codec)StringCodec.get(), strVal -> ContainerCreateInfo.valueOf(ContainerProtos.ContainerDataProto.State.valueOf((String)strVal), -1), obj -> obj.getState().name(), ContainerCreateInfo.class));
            }
        }

        public Table<ContainerID, ContainerCreateInfo> getContainerIdsTable() {
            return this.containerIdsTable;
        }
    }
}

