/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.AvailableSpaceFilter;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingUtil;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityVolumeChoosingPolicy
implements VolumeChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityVolumeChoosingPolicy.class);

    @Override
    public synchronized HddsVolume chooseVolume(List<HddsVolume> volumes, long maxContainerSize) throws IOException {
        if (volumes.isEmpty()) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        AvailableSpaceFilter filter = new AvailableSpaceFilter(maxContainerSize);
        List volumesWithEnoughSpace = volumes.stream().filter(filter).collect(Collectors.toList());
        if (volumesWithEnoughSpace.isEmpty()) {
            VolumeChoosingUtil.throwDiskOutOfSpace(filter, LOG);
        } else {
            VolumeChoosingUtil.logIfSomeVolumesOutOfSpace(filter, LOG);
        }
        int count = volumesWithEnoughSpace.size();
        HddsVolume selectedVolume = (HddsVolume)volumesWithEnoughSpace.get(0);
        if (count > 1) {
            long secondAvailable;
            int firstIndex = ThreadLocalRandom.current().nextInt(count);
            int secondIndex = ThreadLocalRandom.current().nextInt(count);
            HddsVolume firstVolume = (HddsVolume)volumesWithEnoughSpace.get(firstIndex);
            HddsVolume secondVolume = (HddsVolume)volumesWithEnoughSpace.get(secondIndex);
            long firstAvailable = firstVolume.getCurrentUsage().getAvailable() - firstVolume.getCommittedBytes();
            selectedVolume = firstAvailable < (secondAvailable = secondVolume.getCurrentUsage().getAvailable() - secondVolume.getCommittedBytes()) ? secondVolume : firstVolume;
        }
        selectedVolume.incCommittedBytes(maxContainerSize);
        return selectedVolume;
    }
}

