/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils.db;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.managed.ManagedBlockBasedTableConfig;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedLRUCache;
import org.apache.ratis.util.MemoizedSupplier;
import org.rocksdb.Cache;
import org.rocksdb.TableFormatConfig;

public abstract class DatanodeDBProfile {
    public abstract ManagedDBOptions getDBOptions();

    public abstract ManagedColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource var1);

    public static DatanodeDBProfile getProfile(DBProfile dbProfile) {
        switch (dbProfile) {
            case SSD: {
                return new SSD();
            }
            case DISK: 
            case TEST: {
                return new Disk();
            }
        }
        throw new IllegalArgumentException("DatanodeDBProfile does not exist for " + dbProfile);
    }

    public static class SSD
    extends DatanodeDBProfile {
        private static final StorageBasedProfile SSD_STORAGE_BASED_PROFILE = new StorageBasedProfile(DBProfile.SSD);

        @Override
        public ManagedDBOptions getDBOptions() {
            return SSD.SSD_STORAGE_BASED_PROFILE.getDBOptions();
        }

        @Override
        public ManagedColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource config) {
            return SSD.SSD_STORAGE_BASED_PROFILE.getColumnFamilyOptions(config);
        }
    }

    public static class Disk
    extends DatanodeDBProfile {
        private static final StorageBasedProfile DISK_STORAGE_BASED_PROFILE = new StorageBasedProfile(DBProfile.DISK);

        @Override
        public ManagedDBOptions getDBOptions() {
            return Disk.DISK_STORAGE_BASED_PROFILE.getDBOptions();
        }

        @Override
        public ManagedColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource config) {
            return Disk.DISK_STORAGE_BASED_PROFILE.getColumnFamilyOptions(config);
        }
    }

    private static final class StorageBasedProfile {
        private final AtomicReference<Supplier<ManagedColumnFamilyOptions>> cfOpts = new AtomicReference();
        private final DBProfile baseProfile;

        private StorageBasedProfile(DBProfile profile) {
            this.baseProfile = profile;
        }

        private ManagedDBOptions getDBOptions() {
            return this.baseProfile.getDBOptions();
        }

        private ManagedColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource config) {
            MemoizedSupplier supplier = MemoizedSupplier.valueOf(() -> this.createColumnFamilyOptions(config));
            this.cfOpts.compareAndSet(null, (Supplier<ManagedColumnFamilyOptions>)supplier);
            return this.cfOpts.get().get();
        }

        private ManagedColumnFamilyOptions createColumnFamilyOptions(ConfigurationSource config) {
            ManagedColumnFamilyOptions options = this.baseProfile.getColumnFamilyOptions();
            options.setReused(true);
            return options.closeAndSetTableFormatConfig((TableFormatConfig)this.getBlockBasedTableConfig(config));
        }

        private ManagedBlockBasedTableConfig getBlockBasedTableConfig(ConfigurationSource config) {
            ManagedBlockBasedTableConfig blockBasedTableConfig = this.baseProfile.getBlockBasedTableConfig();
            if (config == null) {
                return blockBasedTableConfig;
            }
            long cacheSize = (long)config.getStorageSize("hdds.datanode.metadata.rocksdb.cache.size", "1GB", StorageUnit.BYTES);
            blockBasedTableConfig.closeAndSetBlockCache((Cache)new ManagedLRUCache(cacheSize));
            return blockBasedTableConfig;
        }
    }
}

