/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.ozone.container.common.interfaces.DBHandle;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceCountedDB
extends DBHandle {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceCountedDB.class);
    private final AtomicInteger referenceCount = new AtomicInteger(0);

    public ReferenceCountedDB(DatanodeStore store, String containerDBPath) {
        super(store, containerDBPath);
    }

    public long getReferenceCount() {
        return this.referenceCount.get();
    }

    public void incrementReference() {
        this.referenceCount.incrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace("IncRef {} to refCnt {}, stackTrace: {}", new Object[]{this.getContainerDBPath(), this.referenceCount.get(), ExceptionUtils.getStackTrace((Throwable)new Throwable())});
        }
    }

    public void decrementReference() {
        int refCount = this.referenceCount.decrementAndGet();
        Preconditions.checkArgument((refCount >= 0 ? 1 : 0) != 0, (String)"refCount:", (int)refCount);
        if (LOG.isTraceEnabled()) {
            LOG.trace("DecRef {} to refCnt {}, stackTrace: {}", new Object[]{this.getContainerDBPath(), this.referenceCount.get(), ExceptionUtils.getStackTrace((Throwable)new Throwable())});
        }
    }

    @Override
    public boolean cleanup() {
        if (this.getStore() != null && this.getStore().isClosed() || this.referenceCount.get() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Close {} refCnt {}", (Object)this.getContainerDBPath(), (Object)this.referenceCount.get());
            }
            this.getStore().stop();
            return true;
        }
        return false;
    }

    public void close() {
        this.decrementReference();
    }

    public boolean isClosed() {
        return this.getStore().isClosed();
    }
}

