/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.protocol.commands.SetNodeOperationalStateCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetNodeOperationalStateCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SetNodeOperationalStateCommandHandler.class);
    private final ConfigurationSource conf;
    private final Consumer<HddsProtos.NodeOperationalState> replicationSupervisor;
    private final AtomicInteger invocationCount = new AtomicInteger(0);
    private final MutableRate opsLatencyMs;

    public SetNodeOperationalStateCommandHandler(ConfigurationSource conf, Consumer<HddsProtos.NodeOperationalState> replicationSupervisor) {
        this.conf = conf;
        this.replicationSupervisor = replicationSupervisor;
        MetricsRegistry registry = new MetricsRegistry(SetNodeOperationalStateCommandHandler.class.getSimpleName());
        this.opsLatencyMs = registry.newRate(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand + "Ms");
    }

    @Override
    public void handle(SCMCommand<?> command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        long startTime = Time.monotonicNow();
        this.invocationCount.incrementAndGet();
        if (command.getType() != StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand) {
            LOG.warn("Skipping handling command, expected command type {} but found {}", (Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand, (Object)command.getType());
            return;
        }
        SetNodeOperationalStateCommand setNodeCmd = (SetNodeOperationalStateCommand)command;
        StorageContainerDatanodeProtocolProtos.SetNodeOperationalStateCommandProto setNodeCmdProto = setNodeCmd.getProto();
        DatanodeDetails dni = context.getParent().getDatanodeDetails();
        HddsProtos.NodeOperationalState state = setNodeCmdProto.getNodeOperationalState();
        try {
            this.persistUpdatedDatanodeDetails(dni, state, setNodeCmd.getStateExpiryEpochSeconds());
        }
        catch (IOException ioe) {
            LOG.error("Failed to persist the datanode state", (Throwable)ioe);
        }
        this.replicationSupervisor.accept(state);
        this.opsLatencyMs.add(Time.monotonicNow() - startTime);
    }

    private void persistUpdatedDatanodeDetails(DatanodeDetails dnDetails, HddsProtos.NodeOperationalState state, long stateExpiryEpochSeconds) throws IOException {
        DatanodeDetails persistedDni = new DatanodeDetails(dnDetails);
        persistedDni.setPersistedOpState(state);
        persistedDni.setPersistedOpStateExpiryEpochSec(stateExpiryEpochSeconds);
        this.persistDatanodeDetails(persistedDni);
        dnDetails.setPersistedOpState(state);
        dnDetails.setPersistedOpStateExpiryEpochSec(stateExpiryEpochSeconds);
    }

    private void persistDatanodeDetails(DatanodeDetails dnDetails) throws IOException {
        String idFilePath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)this.conf);
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        ContainerUtils.writeDatanodeDetailsTo(dnDetails, idFile, this.conf);
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount.intValue();
    }

    @Override
    public long getAverageRunTime() {
        return (long)this.opsLatencyMs.lastStat().mean();
    }

    @Override
    public long getTotalRunTime() {
        return (long)this.opsLatencyMs.lastStat().total();
    }

    @Override
    public int getQueuedCount() {
        return 0;
    }
}

