/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.interfaces.Container;

public interface ContainerPacker<CONTAINERDATA extends ContainerData> {
    public byte[] unpackContainerData(Container<CONTAINERDATA> var1, InputStream var2, Path var3, Path var4) throws IOException;

    public void pack(Container<CONTAINERDATA> var1, OutputStream var2) throws IOException;

    public byte[] unpackContainerDescriptor(InputStream var1) throws IOException;

    default public void persistCustomContainerState(Container<? extends ContainerData> container, byte[] descriptorContent, ContainerProtos.ContainerDataProto.State state, Path containerMetadataPath) throws IOException {
        if (descriptorContent == null) {
            return;
        }
        ContainerData originalContainerData = ContainerDataYaml.readContainer(descriptorContent);
        container.getContainerData().setState(state);
        container.update(originalContainerData.getMetadata(), true, containerMetadataPath.toString());
    }
}

