/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.checksum;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferFactory;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class ContainerMerkleTreeWriter {
    private final SortedMap<Long, BlockMerkleTreeWriter> id2Block = new TreeMap<Long, BlockMerkleTreeWriter>();
    public static final Supplier<ChecksumByteBuffer> CHECKSUM_BUFFER_SUPPLIER = ChecksumByteBufferFactory::crc32CImpl;

    public ContainerMerkleTreeWriter() {
    }

    public ContainerMerkleTreeWriter(ContainerProtos.ContainerMerkleTree fromTree) {
        for (ContainerProtos.BlockMerkleTree blockTree : fromTree.getBlockMerkleTreeList()) {
            long blockID = blockTree.getBlockID();
            if (blockTree.getDeleted()) {
                this.setDeletedBlock(blockID, blockTree.getDataChecksum());
                continue;
            }
            this.addBlock(blockID);
            for (ContainerProtos.ChunkMerkleTree chunkTree : blockTree.getChunkMerkleTreeList()) {
                this.addChunks(blockID, new ChunkMerkleTreeWriter(chunkTree));
            }
        }
    }

    public void addChunks(long blockID, boolean checksumMatches, Collection<ContainerProtos.ChunkInfo> chunks) {
        for (ContainerProtos.ChunkInfo chunk : chunks) {
            this.addChunks(blockID, new ChunkMerkleTreeWriter(chunk, checksumMatches));
        }
    }

    public void addChunks(long blockID, boolean checksumMatches, ContainerProtos.ChunkInfo ... chunks) {
        for (ContainerProtos.ChunkInfo chunk : chunks) {
            this.addChunks(blockID, new ChunkMerkleTreeWriter(chunk, checksumMatches));
        }
    }

    private void addChunks(long blockID, ChunkMerkleTreeWriter chunkWriter) {
        this.id2Block.computeIfAbsent(blockID, BlockMerkleTreeWriter::new).addChunks(chunkWriter);
    }

    public void addBlock(long blockID) {
        this.id2Block.computeIfAbsent(blockID, BlockMerkleTreeWriter::new);
    }

    public void setDeletedBlock(long blockID, long dataChecksum) {
        BlockMerkleTreeWriter blockWriter = new BlockMerkleTreeWriter(blockID);
        blockWriter.markDeleted(dataChecksum);
        this.id2Block.put(blockID, blockWriter);
    }

    public ContainerProtos.ContainerMerkleTree update(ContainerProtos.ContainerMerkleTree existingTree) {
        for (ContainerProtos.BlockMerkleTree existingBlockTree : existingTree.getBlockMerkleTreeList()) {
            long blockID = existingBlockTree.getBlockID();
            BlockMerkleTreeWriter ourBlockTree = (BlockMerkleTreeWriter)this.id2Block.get(blockID);
            if (ourBlockTree != null) {
                if (ourBlockTree.isDeleted() || !existingBlockTree.getDeleted()) continue;
                this.setDeletedBlock(blockID, existingBlockTree.getDataChecksum());
                continue;
            }
            if (!existingBlockTree.getDeleted()) continue;
            this.setDeletedBlock(blockID, existingBlockTree.getDataChecksum());
        }
        return this.toProtoBuilder().build();
    }

    public ContainerProtos.ContainerMerkleTree addDeletedBlocks(Collection<BlockData> blocks, boolean computeChecksum) {
        for (BlockData block : blocks) {
            long blockID = block.getLocalID();
            BlockMerkleTreeWriter blockWriter = new BlockMerkleTreeWriter(blockID);
            for (ContainerProtos.ChunkInfo chunkInfo : block.getChunks()) {
                blockWriter.addChunks(new ChunkMerkleTreeWriter(chunkInfo, true));
            }
            blockWriter.markDeleted();
            this.id2Block.put(blockID, blockWriter);
        }
        ContainerProtos.ContainerMerkleTree.Builder protoBuilder = this.toProtoBuilder();
        if (!computeChecksum) {
            protoBuilder.clearDataChecksum();
        }
        return protoBuilder.build();
    }

    private ContainerProtos.ContainerMerkleTree.Builder toProtoBuilder() {
        ContainerProtos.ContainerMerkleTree.Builder containerTreeBuilder = ContainerProtos.ContainerMerkleTree.newBuilder();
        ChecksumByteBuffer checksumImpl = CHECKSUM_BUFFER_SUPPLIER.get();
        ByteBuffer containerChecksumBuffer = ByteBuffer.allocate(8 * this.id2Block.size());
        for (BlockMerkleTreeWriter blockTree : this.id2Block.values()) {
            ContainerProtos.BlockMerkleTree blockTreeProto = blockTree.toProto();
            containerTreeBuilder.addBlockMerkleTree(blockTreeProto);
            containerChecksumBuffer.putLong(blockTreeProto.getDataChecksum());
        }
        containerChecksumBuffer.flip();
        checksumImpl.update(containerChecksumBuffer);
        return containerTreeBuilder.setDataChecksum(checksumImpl.getValue());
    }

    public ContainerProtos.ContainerMerkleTree toProto() {
        return this.toProtoBuilder().build();
    }

    private static class ChunkMerkleTreeWriter {
        private final long length;
        private final long offset;
        private final boolean checksumMatches;
        private final long dataChecksum;

        ChunkMerkleTreeWriter(ContainerProtos.ChunkInfo chunk, boolean checksumMatches) {
            this.length = chunk.getLen();
            this.offset = chunk.getOffset();
            this.checksumMatches = checksumMatches;
            ChecksumByteBuffer checksumImpl = CHECKSUM_BUFFER_SUPPLIER.get();
            for (ByteString checksum : chunk.getChecksumData().getChecksumsList()) {
                checksumImpl.update(checksum.asReadOnlyByteBuffer());
            }
            this.dataChecksum = checksumImpl.getValue();
        }

        ChunkMerkleTreeWriter(ContainerProtos.ChunkMerkleTree chunkTree) {
            this.length = chunkTree.getLength();
            this.offset = chunkTree.getOffset();
            this.checksumMatches = chunkTree.getChecksumMatches();
            this.dataChecksum = chunkTree.getDataChecksum();
        }

        public long getOffset() {
            return this.offset;
        }

        public ContainerProtos.ChunkMerkleTree toProto() {
            return ContainerProtos.ChunkMerkleTree.newBuilder().setOffset(this.offset).setLength(this.length).setChecksumMatches(this.checksumMatches).setDataChecksum(this.dataChecksum).build();
        }
    }

    private static class BlockMerkleTreeWriter {
        private final SortedMap<Long, ChunkMerkleTreeWriter> offset2Chunk;
        private final long blockID;
        private boolean deleted;
        private Long dataChecksum;

        BlockMerkleTreeWriter(long blockID) {
            this.blockID = blockID;
            this.offset2Chunk = new TreeMap<Long, ChunkMerkleTreeWriter>();
            this.deleted = false;
        }

        public void markDeleted(long deletedDataChecksum) {
            this.deleted = true;
            this.dataChecksum = deletedDataChecksum;
        }

        public void markDeleted() {
            this.deleted = true;
        }

        public void addChunks(ChunkMerkleTreeWriter ... chunks) {
            for (ChunkMerkleTreeWriter chunk : chunks) {
                this.offset2Chunk.put(chunk.getOffset(), chunk);
            }
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public ContainerProtos.BlockMerkleTree toProto() {
            ContainerProtos.BlockMerkleTree.Builder blockTreeBuilder = ContainerProtos.BlockMerkleTree.newBuilder();
            if (this.dataChecksum != null) {
                blockTreeBuilder.setDataChecksum(this.dataChecksum.longValue());
            } else {
                this.setDataChecksumFromChunks(blockTreeBuilder);
            }
            if (this.deleted) {
                blockTreeBuilder.clearChunkMerkleTree();
            }
            return blockTreeBuilder.setBlockID(this.blockID).setDeleted(this.deleted).build();
        }

        private void setDataChecksumFromChunks(ContainerProtos.BlockMerkleTree.Builder blockTreeBuilder) {
            ChecksumByteBuffer checksumImpl = CHECKSUM_BUFFER_SUPPLIER.get();
            ByteBuffer blockChecksumBuffer = ByteBuffer.allocate(8 * (1 + this.offset2Chunk.size()));
            blockChecksumBuffer.putLong(this.blockID);
            for (ChunkMerkleTreeWriter chunkTree : this.offset2Chunk.values()) {
                ContainerProtos.ChunkMerkleTree chunkTreeProto = chunkTree.toProto();
                blockTreeBuilder.addChunkMerkleTree(chunkTreeProto);
                blockChecksumBuffer.putLong(chunkTreeProto.getDataChecksum());
            }
            blockChecksumBuffer.flip();
            checksumImpl.update(blockChecksumBuffer);
            blockTreeBuilder.setDataChecksum(checksumImpl.getValue());
        }
    }
}

