/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassFactory;
import org.jboss.classfilewriter.ClassField;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DefaultClassFactory;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.WritableEntry;
import org.jboss.classfilewriter.annotations.AnnotationBuilder;
import org.jboss.classfilewriter.annotations.AnnotationsAttribute;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.ByteArrayDataOutputStream;
import org.jboss.classfilewriter.util.DescriptorUtils;

public class ClassFile
implements WritableEntry {
    private final String name;
    private final String superclass;
    private final int accessFlags;
    private final int version;
    private final ConstPool constPool = new ConstPool();
    private final List<String> interfaces = new ArrayList<String>();
    private final Set<ClassField> fields = new HashSet<ClassField>();
    private final Set<ClassMethod> methods = new HashSet<ClassMethod>();
    private byte[] bytecode;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final AnnotationsAttribute runtimeVisibleAnnotationsAttribute;
    private final ClassLoader classLoader;
    private final ClassFactory classFactory;

    @Deprecated
    public ClassFile(String name, String superclass, String ... interfaces) {
        this(name, AccessFlag.of(32, 1), superclass, (ClassLoader)null, interfaces);
    }

    @Deprecated
    public ClassFile(String name, int accessFlags, String superclass, String ... interfaces) {
        this(name, accessFlags, superclass, (ClassLoader)null, interfaces);
    }

    @Deprecated
    public ClassFile(String name, String superclass, ClassLoader classLoader, String ... interfaces) {
        this(name, AccessFlag.of(32, 1), superclass, classLoader, interfaces);
    }

    @Deprecated
    public ClassFile(String name, int accessFlags, String superclass, ClassLoader classLoader, String ... interfaces) {
        this(name, accessFlags, superclass, 50, classLoader, interfaces);
    }

    @Deprecated
    public ClassFile(String name, int accessFlags, String superclass, int version, ClassLoader classLoader, String ... interfaces) {
        if (version > 50 && classLoader == null) {
            throw new IllegalArgumentException("ClassLoader must be specified if version is greater than Java 6");
        }
        this.version = version;
        this.classLoader = classLoader;
        this.classFactory = null;
        this.name = name.replace('/', '.');
        this.superclass = superclass;
        this.accessFlags = accessFlags;
        this.interfaces.addAll(Arrays.asList(interfaces));
        this.runtimeVisibleAnnotationsAttribute = new AnnotationsAttribute(AnnotationsAttribute.Type.RUNTIME_VISIBLE, this.constPool);
        this.attributes.add(this.runtimeVisibleAnnotationsAttribute);
    }

    public ClassFile(String name, String superclass, ClassLoader classLoader, ClassFactory classFactory, String ... interfaces) {
        this(name, AccessFlag.of(32, 1), superclass, classLoader, classFactory, interfaces);
    }

    public ClassFile(String name, int accessFlags, String superclass, ClassLoader classLoader, ClassFactory classFactory, String ... interfaces) {
        this(name, accessFlags, superclass, 50, classLoader, classFactory, interfaces);
    }

    public ClassFile(String name, int accessFlags, String superclass, int version, ClassLoader classLoader, ClassFactory classFactory, String ... interfaces) {
        if (version > 50 && classLoader == null) {
            throw new IllegalArgumentException("ClassLoader must be specified if version is greater than Java 6");
        }
        if (classFactory == null) {
            throw new IllegalArgumentException("ClassFactory must be specified");
        }
        this.version = version;
        this.classLoader = classLoader;
        this.classFactory = classFactory;
        this.name = name.replace('/', '.');
        this.superclass = superclass;
        this.accessFlags = accessFlags;
        this.interfaces.addAll(Arrays.asList(interfaces));
        this.runtimeVisibleAnnotationsAttribute = new AnnotationsAttribute(AnnotationsAttribute.Type.RUNTIME_VISIBLE, this.constPool);
        this.attributes.add(this.runtimeVisibleAnnotationsAttribute);
    }

    public void addInterface(String iface) {
        this.interfaces.add(iface);
    }

    public ClassField addField(int accessFlags, String name, String descriptor) {
        return this.addField(accessFlags, name, descriptor, null);
    }

    public ClassField addField(int accessFlags, String name, String descriptor, String signature) {
        ClassField field = new ClassField((short)accessFlags, name, descriptor, this, this.constPool);
        if (this.fields.contains(field)) {
            throw new DuplicateMemberException("Field  already exists. Field: " + name + " Descriptor:" + signature);
        }
        this.fields.add(field);
        field.setSignature(signature);
        return field;
    }

    public ClassField addField(int accessFlags, String name, Class<?> type) {
        return this.addField(accessFlags, name, DescriptorUtils.makeDescriptor(type));
    }

    public ClassField addField(int accessFlags, String name, Class<?> type, String genericSignature) {
        return this.addField(accessFlags, name, DescriptorUtils.makeDescriptor(type), genericSignature);
    }

    public ClassField addField(Field field) {
        ClassField classField = this.addField((int)((short)field.getModifiers()), field.getName(), field.getType(), null);
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            classField.getRuntimeVisibleAnnotationsAttribute().addAnnotation(AnnotationBuilder.createAnnotation(this.constPool, annotation));
        }
        return classField;
    }

    public ClassMethod addMethod(int accessFlags, String name, String returnType, String ... parameters) {
        ClassMethod method = new ClassMethod(name, returnType, parameters, accessFlags, this);
        if (this.methods.contains(method)) {
            throw new DuplicateMemberException("Method  already exists. Method: " + name + " Parameters:" + Arrays.toString(parameters) + " Return Type: " + returnType);
        }
        this.methods.add(method);
        return method;
    }

    public ClassMethod addMethod(Method method) {
        ClassMethod classMethod = this.addMethod(method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF, method.getName(), DescriptorUtils.makeDescriptor(method.getReturnType()), DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        for (Class<?> e : method.getExceptionTypes()) {
            classMethod.addCheckedExceptions(e);
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            classMethod.getRuntimeVisibleAnnotationsAttribute().addAnnotation(AnnotationBuilder.createAnnotation(this.constPool, annotation));
        }
        int count = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                classMethod.getRuntimeVisibleParameterAnnotationsAttribute().addAnnotation(count, AnnotationBuilder.createAnnotation(this.constPool, annotation));
            }
            ++count;
        }
        return classMethod;
    }

    public ClassMethod addConstructor(Constructor<?> method) {
        ClassMethod classMethod = this.addMethod(method.getModifiers(), "<init>", "V", DescriptorUtils.parameterDescriptors(method.getParameterTypes()));
        for (Class<?> e : method.getExceptionTypes()) {
            classMethod.addCheckedExceptions(e);
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            classMethod.getRuntimeVisibleAnnotationsAttribute().addAnnotation(AnnotationBuilder.createAnnotation(this.constPool, annotation));
        }
        int count = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = annotationArray[i]) {
                classMethod.getRuntimeVisibleParameterAnnotationsAttribute().addAnnotation(count, AnnotationBuilder.createAnnotation(this.constPool, annotation));
            }
            ++count;
        }
        return classMethod;
    }

    @Override
    public void write(ByteArrayDataOutputStream stream) throws IOException {
        int nameIndex = this.constPool.addClassEntry(this.name);
        int superClassIndex = this.constPool.addClassEntry(this.superclass);
        ArrayList<Integer> interfaceIndexes = new ArrayList<Integer>(this.interfaces.size());
        for (String i : this.interfaces) {
            interfaceIndexes.add(this.constPool.addClassEntry(i));
        }
        stream.writeInt(-889275714);
        stream.writeInt(this.version);
        this.constPool.write(stream);
        stream.writeShort(this.accessFlags);
        stream.writeShort(nameIndex);
        stream.writeShort(superClassIndex);
        stream.writeShort(interfaceIndexes.size());
        Iterator<Object> iterator = interfaceIndexes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)((Object)iterator.next());
            stream.writeShort(i);
        }
        stream.writeShort(this.fields.size());
        for (ClassField field : this.fields) {
            field.write(stream);
        }
        stream.writeShort(this.methods.size());
        for (ClassMethod method : this.methods) {
            method.write(stream);
        }
        stream.writeShort(this.attributes.size());
        for (Attribute attribute : this.attributes) {
            attribute.write(stream);
        }
    }

    public Class<?> define() {
        return this.defineInternal(this.classLoader, null);
    }

    @Deprecated
    public Class<?> define(ClassLoader loader) {
        return this.defineInternal(loader, null);
    }

    public Class<?> define(ProtectionDomain domain) {
        return this.defineInternal(this.classLoader, domain);
    }

    @Deprecated
    public Class<?> define(ClassLoader loader, ProtectionDomain domain) {
        return this.defineInternal(loader, domain);
    }

    private Class<?> defineInternal(ClassLoader loader, ProtectionDomain domain) {
        byte[] b = this.toBytecode();
        ClassFactory classFactory = this.classFactory == null ? DefaultClassFactory.INSTANCE : this.classFactory;
        return classFactory.defineClass(loader, this.name, b, 0, b.length, domain);
    }

    public byte[] toBytecode() {
        if (this.bytecode == null) {
            try {
                ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
                this.write(out);
                this.bytecode = out.getBytes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytecode;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public String getDescriptor() {
        return DescriptorUtils.makeDescriptor(this.name);
    }

    public AnnotationsAttribute getRuntimeVisibleAnnotationsAttribute() {
        return this.runtimeVisibleAnnotationsAttribute;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public Set<ClassField> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<ClassMethod> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }
}

